/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.c;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.g;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableGroupJoin<TLeft, TRight, TLeftEnd, TRightEnd, R>
extends io.reactivex.rxjava3.internal.operators.flowable.a<TLeft, R> {
    final org.a.c<? extends TRight> VX;
    final h<? super TLeft, ? extends org.a.c<TLeftEnd>> VY;
    final h<? super TRight, ? extends org.a.c<TRightEnd>> VZ;
    final c<? super TLeft, ? super j<TRight>, ? extends R> Wa;

    public FlowableGroupJoin(j<TLeft> source, org.a.c<? extends TRight> other, h<? super TLeft, ? extends org.a.c<TLeftEnd>> leftEnd, h<? super TRight, ? extends org.a.c<TRightEnd>> rightEnd, c<? super TLeft, ? super j<TRight>, ? extends R> resultSelector) {
        super(source);
        this.VX = other;
        this.VY = leftEnd;
        this.VZ = rightEnd;
        this.Wa = resultSelector;
    }

    @Override
    protected void d(d<? super R> s2) {
        GroupJoinSubscription parent = new GroupJoinSubscription(s2, this.VY, this.VZ, this.Wa);
        s2.onSubscribe(parent);
        LeftRightSubscriber left = new LeftRightSubscriber(parent, true);
        parent.disposables.a((b)left);
        LeftRightSubscriber right = new LeftRightSubscriber(parent, false);
        parent.disposables.a((b)right);
        this.QR.a(left);
        this.VX.subscribe(right);
    }

    static final class LeftRightEndSubscriber
    extends AtomicReference<e>
    implements o<Object>,
    b {
        private static final long serialVersionUID = 1883890389173668373L;
        final a parent;
        final boolean isLeft;
        final int index;

        LeftRightEndSubscriber(a parent, boolean isLeft, int index) {
            this.parent = parent;
            this.isLeft = isLeft;
            this.index = index;
        }

        @Override
        public void dispose() {
            SubscriptionHelper.cancel(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == SubscriptionHelper.CANCELLED;
        }

        @Override
        public void onSubscribe(e s2) {
            SubscriptionHelper.setOnce(this, s2, Long.MAX_VALUE);
        }

        @Override
        public void onNext(Object t2) {
            if (SubscriptionHelper.cancel(this)) {
                this.parent.innerClose(this.isLeft, this);
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.innerCloseError(t2);
        }

        @Override
        public void onComplete() {
            this.parent.innerClose(this.isLeft, this);
        }
    }

    static final class LeftRightSubscriber
    extends AtomicReference<e>
    implements o<Object>,
    b {
        private static final long serialVersionUID = 1883890389173668373L;
        final a parent;
        final boolean isLeft;

        LeftRightSubscriber(a parent, boolean isLeft) {
            this.parent = parent;
            this.isLeft = isLeft;
        }

        @Override
        public void dispose() {
            SubscriptionHelper.cancel(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == SubscriptionHelper.CANCELLED;
        }

        @Override
        public void onSubscribe(e s2) {
            SubscriptionHelper.setOnce(this, s2, Long.MAX_VALUE);
        }

        @Override
        public void onNext(Object t2) {
            this.parent.innerValue(this.isLeft, t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.innerError(t2);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this);
        }
    }

    static final class GroupJoinSubscription<TLeft, TRight, TLeftEnd, TRightEnd, R>
    extends AtomicInteger
    implements a,
    e {
        private static final long serialVersionUID = -6071216598687999801L;
        final d<? super R> downstream;
        final AtomicLong requested;
        final io.reactivex.rxjava3.operators.h<Object> queue;
        final io.reactivex.rxjava3.disposables.a disposables;
        final Map<Integer, UnicastProcessor<TRight>> lefts;
        final Map<Integer, TRight> rights;
        final AtomicReference<Throwable> error;
        final h<? super TLeft, ? extends org.a.c<TLeftEnd>> leftEnd;
        final h<? super TRight, ? extends org.a.c<TRightEnd>> rightEnd;
        final c<? super TLeft, ? super j<TRight>, ? extends R> resultSelector;
        final AtomicInteger active;
        int leftIndex;
        int rightIndex;
        volatile boolean cancelled;
        static final Integer LEFT_VALUE = 1;
        static final Integer RIGHT_VALUE = 2;
        static final Integer LEFT_CLOSE = 3;
        static final Integer RIGHT_CLOSE = 4;

        GroupJoinSubscription(d<? super R> actual, h<? super TLeft, ? extends org.a.c<TLeftEnd>> leftEnd, h<? super TRight, ? extends org.a.c<TRightEnd>> rightEnd, c<? super TLeft, ? super j<TRight>, ? extends R> resultSelector) {
            this.downstream = actual;
            this.requested = new AtomicLong();
            this.disposables = new io.reactivex.rxjava3.disposables.a();
            this.queue = new io.reactivex.rxjava3.operators.h(j.mB());
            this.lefts = new LinkedHashMap<Integer, UnicastProcessor<TRight>>();
            this.rights = new LinkedHashMap<Integer, TRight>();
            this.error = new AtomicReference();
            this.leftEnd = leftEnd;
            this.rightEnd = rightEnd;
            this.resultSelector = resultSelector;
            this.active = new AtomicInteger(2);
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.cancelAll();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void cancelAll() {
            this.disposables.dispose();
        }

        void errorAll(d<?> a2) {
            Throwable ex = ExceptionHelper.a(this.error);
            for (UnicastProcessor<TRight> up : this.lefts.values()) {
                up.onError(ex);
            }
            this.lefts.clear();
            this.rights.clear();
            a2.onError(ex);
        }

        void fail(Throwable exc, d<?> a2, g<?> q2) {
            io.reactivex.rxjava3.exceptions.a.k(exc);
            ExceptionHelper.a(this.error, exc);
            q2.clear();
            this.cancelAll();
            this.errorAll(a2);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            io.reactivex.rxjava3.operators.h<Object> q2 = this.queue;
            d<R> a2 = this.downstream;
            block6: while (true) {
                boolean empty;
                if (this.cancelled) {
                    q2.clear();
                    return;
                }
                Throwable ex = this.error.get();
                if (ex != null) {
                    q2.clear();
                    this.cancelAll();
                    this.errorAll(a2);
                    return;
                }
                boolean d2 = this.active.get() == 0;
                Integer mode = (Integer)q2.poll();
                boolean bl2 = empty = mode == null;
                if (d2 && empty) {
                    for (UnicastProcessor<TRight> up : this.lefts.values()) {
                        up.onComplete();
                    }
                    this.lefts.clear();
                    this.rights.clear();
                    this.disposables.dispose();
                    a2.onComplete();
                    return;
                }
                if (!empty) {
                    LeftRightEndSubscriber end;
                    Object val = q2.poll();
                    if (mode == LEFT_VALUE) {
                        R w2;
                        org.a.c<TLeftEnd> p2;
                        int idx;
                        Object left = val;
                        UnicastProcessor<TRight> up = UnicastProcessor.rU();
                        ++this.leftIndex;
                        this.lefts.put(idx, up);
                        try {
                            p2 = Objects.requireNonNull(this.leftEnd.apply(left), "The leftEnd returned a null Publisher");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a2, q2);
                            return;
                        }
                        LeftRightEndSubscriber end2 = new LeftRightEndSubscriber(this, true, idx);
                        this.disposables.a((b)end2);
                        p2.subscribe(end2);
                        ex = this.error.get();
                        if (ex != null) {
                            q2.clear();
                            this.cancelAll();
                            this.errorAll(a2);
                            return;
                        }
                        try {
                            w2 = Objects.requireNonNull(this.resultSelector.apply(left, up), "The resultSelector returned a null value");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a2, q2);
                            return;
                        }
                        if (this.requested.get() == 0L) {
                            this.fail(MissingBackpressureException.createDefault(), a2, q2);
                            return;
                        }
                        a2.onNext(w2);
                        io.reactivex.rxjava3.internal.util.b.c(this.requested, 1L);
                        Iterator<TRight> iterator = this.rights.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block6;
                            TRight right = iterator.next();
                            up.onNext(right);
                        }
                    }
                    if (mode == RIGHT_VALUE) {
                        org.a.c<TRightEnd> p3;
                        int idx;
                        Object right = val;
                        ++this.rightIndex;
                        this.rights.put(idx, right);
                        try {
                            p3 = Objects.requireNonNull(this.rightEnd.apply(right), "The rightEnd returned a null Publisher");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a2, q2);
                            return;
                        }
                        LeftRightEndSubscriber end3 = new LeftRightEndSubscriber(this, false, idx);
                        this.disposables.a((b)end3);
                        p3.subscribe(end3);
                        ex = this.error.get();
                        if (ex != null) {
                            q2.clear();
                            this.cancelAll();
                            this.errorAll(a2);
                            return;
                        }
                        Iterator<UnicastProcessor<TRight>> iterator = this.lefts.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block6;
                            UnicastProcessor<TRight> up = iterator.next();
                            up.onNext(right);
                        }
                    }
                    if (mode == LEFT_CLOSE) {
                        end = (LeftRightEndSubscriber)val;
                        UnicastProcessor<TRight> up = this.lefts.remove(end.index);
                        this.disposables.b(end);
                        if (up == null) continue;
                        up.onComplete();
                        continue;
                    }
                    end = (LeftRightEndSubscriber)val;
                    this.rights.remove(end.index);
                    this.disposables.b(end);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void innerError(Throwable ex) {
            if (ExceptionHelper.a(this.error, ex)) {
                this.active.decrementAndGet();
                this.drain();
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }

        @Override
        public void innerComplete(LeftRightSubscriber sender) {
            this.disposables.c(sender);
            this.active.decrementAndGet();
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerValue(boolean isLeft, Object o2) {
            GroupJoinSubscription groupJoinSubscription = this;
            synchronized (groupJoinSubscription) {
                this.queue.offer(isLeft ? LEFT_VALUE : RIGHT_VALUE, o2);
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerClose(boolean isLeft, LeftRightEndSubscriber index) {
            GroupJoinSubscription groupJoinSubscription = this;
            synchronized (groupJoinSubscription) {
                this.queue.offer(isLeft ? LEFT_CLOSE : RIGHT_CLOSE, index);
            }
            this.drain();
        }

        @Override
        public void innerCloseError(Throwable ex) {
            if (ExceptionHelper.a(this.error, ex)) {
                this.drain();
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }
    }

    static interface a {
        public void innerError(Throwable var1);

        public void innerComplete(LeftRightSubscriber var1);

        public void innerValue(boolean var1, Object var2);

        public void innerClose(boolean var1, LeftRightEndSubscriber var2);

        public void innerCloseError(Throwable var1);
    }
}

