/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.schedulers.l;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableIntervalRange
extends j<Long> {
    final ah WK;
    final long WL;
    final long WM;
    final long WN;
    final long WO;
    final TimeUnit WP;

    public FlowableIntervalRange(long start, long end, long initialDelay, long period, TimeUnit unit, ah scheduler) {
        this.WN = initialDelay;
        this.WO = period;
        this.WP = unit;
        this.WK = scheduler;
        this.WL = start;
        this.WM = end;
    }

    @Override
    public void d(d<? super Long> s2) {
        IntervalRangeSubscriber is = new IntervalRangeSubscriber(s2, this.WL, this.WM);
        s2.onSubscribe(is);
        ah sch = this.WK;
        if (sch instanceof l) {
            ah.c worker = sch.oS();
            is.setResource(worker);
            worker.b(is, this.WN, this.WO, this.WP);
        } else {
            b d2 = sch.a(is, this.WN, this.WO, this.WP);
            is.setResource(d2);
        }
    }

    static final class IntervalRangeSubscriber
    extends AtomicLong
    implements Runnable,
    e {
        private static final long serialVersionUID = -2809475196591179431L;
        final d<? super Long> downstream;
        final long end;
        long count;
        final AtomicReference<b> resource = new AtomicReference();

        IntervalRangeSubscriber(d<? super Long> actual, long start, long end) {
            this.downstream = actual;
            this.count = start;
            this.end = end;
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this, n2);
            }
        }

        @Override
        public void cancel() {
            DisposableHelper.dispose(this.resource);
        }

        @Override
        public void run() {
            if (this.resource.get() != DisposableHelper.DISPOSED) {
                long r2 = this.get();
                if (r2 != 0L) {
                    long c2 = this.count;
                    this.downstream.onNext((Long)c2);
                    if (c2 == this.end) {
                        if (this.resource.get() != DisposableHelper.DISPOSED) {
                            this.downstream.onComplete();
                        }
                        DisposableHelper.dispose(this.resource);
                        return;
                    }
                    this.count = c2 + 1L;
                    if (r2 != Long.MAX_VALUE) {
                        this.decrementAndGet();
                    }
                } else {
                    this.downstream.onError(new MissingBackpressureException("Could not emit value " + this.count + " due to lack of requests"));
                    DisposableHelper.dispose(this.resource);
                }
            }
        }

        public void setResource(b d2) {
            DisposableHelper.setOnce(this.resource, d2);
        }
    }
}

