/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.c;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableGroupJoin;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.g;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableJoin<TLeft, TRight, TLeftEnd, TRightEnd, R>
extends a<TLeft, R> {
    final org.a.c<? extends TRight> WQ;
    final h<? super TLeft, ? extends org.a.c<TLeftEnd>> WR;
    final h<? super TRight, ? extends org.a.c<TRightEnd>> WT;
    final c<? super TLeft, ? super TRight, ? extends R> WU;

    public FlowableJoin(j<TLeft> source, org.a.c<? extends TRight> other, h<? super TLeft, ? extends org.a.c<TLeftEnd>> leftEnd, h<? super TRight, ? extends org.a.c<TRightEnd>> rightEnd, c<? super TLeft, ? super TRight, ? extends R> resultSelector) {
        super(source);
        this.WQ = other;
        this.WR = leftEnd;
        this.WT = rightEnd;
        this.WU = resultSelector;
    }

    @Override
    protected void d(d<? super R> s2) {
        JoinSubscription parent = new JoinSubscription(s2, this.WR, this.WT, this.WU);
        s2.onSubscribe(parent);
        FlowableGroupJoin.LeftRightSubscriber left = new FlowableGroupJoin.LeftRightSubscriber(parent, true);
        parent.disposables.a((b)left);
        FlowableGroupJoin.LeftRightSubscriber right = new FlowableGroupJoin.LeftRightSubscriber(parent, false);
        parent.disposables.a((b)right);
        this.QR.a(left);
        this.WQ.subscribe(right);
    }

    static final class JoinSubscription<TLeft, TRight, TLeftEnd, TRightEnd, R>
    extends AtomicInteger
    implements FlowableGroupJoin.a,
    e {
        private static final long serialVersionUID = -6071216598687999801L;
        final d<? super R> downstream;
        final AtomicLong requested;
        final io.reactivex.rxjava3.operators.h<Object> queue;
        final io.reactivex.rxjava3.disposables.a disposables;
        final Map<Integer, TLeft> lefts;
        final Map<Integer, TRight> rights;
        final AtomicReference<Throwable> error;
        final h<? super TLeft, ? extends org.a.c<TLeftEnd>> leftEnd;
        final h<? super TRight, ? extends org.a.c<TRightEnd>> rightEnd;
        final c<? super TLeft, ? super TRight, ? extends R> resultSelector;
        final AtomicInteger active;
        int leftIndex;
        int rightIndex;
        volatile boolean cancelled;
        static final Integer LEFT_VALUE = 1;
        static final Integer RIGHT_VALUE = 2;
        static final Integer LEFT_CLOSE = 3;
        static final Integer RIGHT_CLOSE = 4;

        JoinSubscription(d<? super R> actual, h<? super TLeft, ? extends org.a.c<TLeftEnd>> leftEnd, h<? super TRight, ? extends org.a.c<TRightEnd>> rightEnd, c<? super TLeft, ? super TRight, ? extends R> resultSelector) {
            this.downstream = actual;
            this.requested = new AtomicLong();
            this.disposables = new io.reactivex.rxjava3.disposables.a();
            this.queue = new io.reactivex.rxjava3.operators.h(j.mB());
            this.lefts = new LinkedHashMap<Integer, TLeft>();
            this.rights = new LinkedHashMap<Integer, TRight>();
            this.error = new AtomicReference();
            this.leftEnd = leftEnd;
            this.rightEnd = rightEnd;
            this.resultSelector = resultSelector;
            this.active = new AtomicInteger(2);
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.cancelAll();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void cancelAll() {
            this.disposables.dispose();
        }

        void errorAll(d<?> a2) {
            Throwable ex = ExceptionHelper.a(this.error);
            this.lefts.clear();
            this.rights.clear();
            a2.onError(ex);
        }

        void fail(Throwable exc, d<?> a2, g<?> q2) {
            io.reactivex.rxjava3.exceptions.a.k(exc);
            ExceptionHelper.a(this.error, exc);
            q2.clear();
            this.cancelAll();
            this.errorAll(a2);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            io.reactivex.rxjava3.operators.h<Object> q2 = this.queue;
            d<R> a2 = this.downstream;
            while (true) {
                boolean empty;
                if (this.cancelled) {
                    q2.clear();
                    return;
                }
                Throwable ex = this.error.get();
                if (ex != null) {
                    q2.clear();
                    this.cancelAll();
                    this.errorAll(a2);
                    return;
                }
                boolean d2 = this.active.get() == 0;
                Integer mode = (Integer)q2.poll();
                boolean bl2 = empty = mode == null;
                if (d2 && empty) {
                    this.lefts.clear();
                    this.rights.clear();
                    this.disposables.dispose();
                    a2.onComplete();
                    return;
                }
                if (!empty) {
                    FlowableGroupJoin.LeftRightEndSubscriber end;
                    R w2;
                    long e2;
                    long r2;
                    FlowableGroupJoin.LeftRightEndSubscriber end2;
                    org.a.c<Object> p2;
                    int idx;
                    Object val = q2.poll();
                    if (mode == LEFT_VALUE) {
                        Object left = val;
                        ++this.leftIndex;
                        this.lefts.put(idx, left);
                        try {
                            p2 = Objects.requireNonNull(this.leftEnd.apply(left), "The leftEnd returned a null Publisher");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a2, q2);
                            return;
                        }
                        end2 = new FlowableGroupJoin.LeftRightEndSubscriber(this, true, idx);
                        this.disposables.a((b)end2);
                        p2.subscribe(end2);
                        ex = this.error.get();
                        if (ex != null) {
                            q2.clear();
                            this.cancelAll();
                            this.errorAll(a2);
                            return;
                        }
                        r2 = this.requested.get();
                        e2 = 0L;
                        for (Object right : this.rights.values()) {
                            try {
                                w2 = Objects.requireNonNull(this.resultSelector.apply(left, right), "The resultSelector returned a null value");
                            }
                            catch (Throwable exc) {
                                this.fail(exc, a2, q2);
                                return;
                            }
                            if (e2 != r2) {
                                a2.onNext(w2);
                                ++e2;
                                continue;
                            }
                            ExceptionHelper.a(this.error, MissingBackpressureException.createDefault());
                            q2.clear();
                            this.cancelAll();
                            this.errorAll(a2);
                            return;
                        }
                        if (e2 == 0L) continue;
                        io.reactivex.rxjava3.internal.util.b.c(this.requested, e2);
                        continue;
                    }
                    if (mode == RIGHT_VALUE) {
                        Object right = val;
                        ++this.rightIndex;
                        this.rights.put(idx, right);
                        try {
                            p2 = Objects.requireNonNull(this.rightEnd.apply(right), "The rightEnd returned a null Publisher");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a2, q2);
                            return;
                        }
                        end2 = new FlowableGroupJoin.LeftRightEndSubscriber(this, false, idx);
                        this.disposables.a((b)end2);
                        p2.subscribe(end2);
                        ex = this.error.get();
                        if (ex != null) {
                            q2.clear();
                            this.cancelAll();
                            this.errorAll(a2);
                            return;
                        }
                        r2 = this.requested.get();
                        e2 = 0L;
                        for (Object left : this.lefts.values()) {
                            try {
                                w2 = Objects.requireNonNull(this.resultSelector.apply(left, right), "The resultSelector returned a null value");
                            }
                            catch (Throwable exc) {
                                this.fail(exc, a2, q2);
                                return;
                            }
                            if (e2 != r2) {
                                a2.onNext(w2);
                                ++e2;
                                continue;
                            }
                            ExceptionHelper.a(this.error, MissingBackpressureException.createDefault());
                            q2.clear();
                            this.cancelAll();
                            this.errorAll(a2);
                            return;
                        }
                        if (e2 == 0L) continue;
                        io.reactivex.rxjava3.internal.util.b.c(this.requested, e2);
                        continue;
                    }
                    if (mode == LEFT_CLOSE) {
                        end = (FlowableGroupJoin.LeftRightEndSubscriber)val;
                        this.lefts.remove(end.index);
                        this.disposables.b(end);
                        continue;
                    }
                    end = (FlowableGroupJoin.LeftRightEndSubscriber)val;
                    this.rights.remove(end.index);
                    this.disposables.b(end);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void innerError(Throwable ex) {
            if (ExceptionHelper.a(this.error, ex)) {
                this.active.decrementAndGet();
                this.drain();
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }

        @Override
        public void innerComplete(FlowableGroupJoin.LeftRightSubscriber sender) {
            this.disposables.c(sender);
            this.active.decrementAndGet();
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerValue(boolean isLeft, Object o2) {
            JoinSubscription joinSubscription = this;
            synchronized (joinSubscription) {
                this.queue.offer(isLeft ? LEFT_VALUE : RIGHT_VALUE, o2);
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerClose(boolean isLeft, FlowableGroupJoin.LeftRightEndSubscriber index) {
            JoinSubscription joinSubscription = this;
            synchronized (joinSubscription) {
                this.queue.offer(isLeft ? LEFT_CLOSE : RIGHT_CLOSE, index);
            }
            this.drain();
        }

        @Override
        public void innerCloseError(Throwable ex) {
            if (ExceptionHelper.a(this.error, ex)) {
                this.drain();
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }
    }
}

