/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.f;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableMergeWithSingle<T>
extends a<T, T> {
    final ao<? extends T> Xn;

    public FlowableMergeWithSingle(j<T> source, ao<? extends T> other) {
        super(source);
        this.Xn = other;
    }

    @Override
    protected void d(d<? super T> subscriber) {
        MergeWithObserver<? super T> parent = new MergeWithObserver<T>(subscriber);
        subscriber.onSubscribe(parent);
        this.QR.a(parent);
        this.Xn.c(parent.otherObserver);
    }

    static final class MergeWithObserver<T>
    extends AtomicInteger
    implements o<T>,
    e {
        private static final long serialVersionUID = -4592979584110982903L;
        final d<? super T> downstream;
        final AtomicReference<e> mainSubscription;
        final OtherObserver<T> otherObserver;
        final AtomicThrowable errors;
        final AtomicLong requested;
        final int prefetch;
        final int limit;
        volatile f<T> queue;
        T singleItem;
        volatile boolean cancelled;
        volatile boolean mainDone;
        volatile int otherState;
        long emitted;
        int consumed;
        static final int OTHER_STATE_HAS_VALUE = 1;
        static final int OTHER_STATE_CONSUMED_OR_EMPTY = 2;

        MergeWithObserver(d<? super T> downstream) {
            this.downstream = downstream;
            this.mainSubscription = new AtomicReference();
            this.otherObserver = new OtherObserver(this);
            this.errors = new AtomicThrowable();
            this.requested = new AtomicLong();
            this.prefetch = j.mB();
            this.limit = this.prefetch - (this.prefetch >> 2);
        }

        @Override
        public void onSubscribe(e s2) {
            SubscriptionHelper.setOnce(this.mainSubscription, s2, this.prefetch);
        }

        @Override
        public void onNext(T t2) {
            if (this.compareAndSet(0, 1)) {
                long e2 = this.emitted;
                if (this.requested.get() != e2) {
                    f<T> q2 = this.queue;
                    if (q2 == null || q2.isEmpty()) {
                        this.emitted = e2 + 1L;
                        this.downstream.onNext(t2);
                        int c2 = this.consumed + 1;
                        if (c2 == this.limit) {
                            this.consumed = 0;
                            this.mainSubscription.get().request(c2);
                        } else {
                            this.consumed = c2;
                        }
                    } else {
                        q2.offer(t2);
                    }
                } else {
                    f<T> q3 = this.getOrCreateQueue();
                    q3.offer(t2);
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                f<T> q4 = this.getOrCreateQueue();
                q4.offer(t2);
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                DisposableHelper.dispose(this.otherObserver);
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.mainDone = true;
            this.drain();
        }

        @Override
        public void request(long n2) {
            io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
            this.drain();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            SubscriptionHelper.cancel(this.mainSubscription);
            DisposableHelper.dispose(this.otherObserver);
            this.errors.tryTerminateAndReport();
            if (this.getAndIncrement() == 0) {
                this.queue = null;
                this.singleItem = null;
            }
        }

        void otherSuccess(T value) {
            if (this.compareAndSet(0, 1)) {
                long e2 = this.emitted;
                if (this.requested.get() != e2) {
                    this.emitted = e2 + 1L;
                    this.downstream.onNext(value);
                    this.otherState = 2;
                } else {
                    this.singleItem = value;
                    this.otherState = 1;
                    if (this.decrementAndGet() == 0) {
                        return;
                    }
                }
            } else {
                this.singleItem = value;
                this.otherState = 1;
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        void otherError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                SubscriptionHelper.cancel(this.mainSubscription);
                this.drain();
            }
        }

        f<T> getOrCreateQueue() {
            f<T> q2 = this.queue;
            if (q2 == null) {
                this.queue = q2 = new SpscArrayQueue<T>(j.mB());
            }
            return q2;
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            d<T> actual = this.downstream;
            int missed = 1;
            long e2 = this.emitted;
            int c2 = this.consumed;
            int lim = this.limit;
            do {
                long r2 = this.requested.get();
                while (e2 != r2) {
                    boolean empty;
                    if (this.cancelled) {
                        this.singleItem = null;
                        this.queue = null;
                        return;
                    }
                    if (this.errors.get() != null) {
                        this.singleItem = null;
                        this.queue = null;
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    int os = this.otherState;
                    if (os == 1) {
                        T v2 = this.singleItem;
                        this.singleItem = null;
                        this.otherState = 2;
                        os = 2;
                        actual.onNext(v2);
                        ++e2;
                        continue;
                    }
                    boolean d2 = this.mainDone;
                    f<T> q2 = this.queue;
                    Object v3 = q2 != null ? (Object)q2.poll() : null;
                    boolean bl2 = empty = v3 == null;
                    if (d2 && empty && os == 2) {
                        this.queue = null;
                        actual.onComplete();
                        return;
                    }
                    if (empty) break;
                    actual.onNext(v3);
                    ++e2;
                    if (++c2 != lim) continue;
                    c2 = 0;
                    this.mainSubscription.get().request(lim);
                }
                if (e2 == r2) {
                    boolean empty;
                    if (this.cancelled) {
                        this.singleItem = null;
                        this.queue = null;
                        return;
                    }
                    if (this.errors.get() != null) {
                        this.singleItem = null;
                        this.queue = null;
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    boolean d3 = this.mainDone;
                    f<T> q3 = this.queue;
                    boolean bl3 = empty = q3 == null || q3.isEmpty();
                    if (d3 && empty && this.otherState == 2) {
                        this.queue = null;
                        actual.onComplete();
                        return;
                    }
                }
                this.emitted = e2;
                this.consumed = c2;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        static final class OtherObserver<T>
        extends AtomicReference<b>
        implements al<T> {
            private static final long serialVersionUID = -2935427570954647017L;
            final MergeWithObserver<T> parent;

            OtherObserver(MergeWithObserver<T> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onSuccess(T t2) {
                this.parent.otherSuccess(t2);
            }

            @Override
            public void onError(Throwable e2) {
                this.parent.otherError(e2);
            }
        }
    }
}

