/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.h;
import java.util.concurrent.atomic.AtomicLong;
import org.a.d;
import org.a.e;

public final class FlowableOnBackpressureBuffer<T>
extends a<T, T> {
    final int Xs;
    final boolean unbounded;
    final boolean Xt;
    final io.reactivex.rxjava3.b.a Xu;
    final g<? super T> Xv;

    public FlowableOnBackpressureBuffer(j<T> source, int bufferSize, boolean unbounded, boolean delayError, io.reactivex.rxjava3.b.a onOverflow, g<? super T> onDropped) {
        super(source);
        this.Xs = bufferSize;
        this.unbounded = unbounded;
        this.Xt = delayError;
        this.Xu = onOverflow;
        this.Xv = onDropped;
    }

    @Override
    protected void d(d<? super T> s2) {
        this.QR.a(new BackpressureBufferSubscriber<T>(s2, this.Xs, this.unbounded, this.Xt, this.Xu, this.Xv));
    }

    static final class BackpressureBufferSubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements o<T> {
        private static final long serialVersionUID = -2514538129242366402L;
        final d<? super T> downstream;
        final io.reactivex.rxjava3.operators.f<T> queue;
        final boolean delayError;
        final io.reactivex.rxjava3.b.a onOverflow;
        final g<? super T> onDropped;
        e upstream;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        final AtomicLong requested = new AtomicLong();
        boolean outputFused;

        BackpressureBufferSubscriber(d<? super T> actual, int bufferSize, boolean unbounded, boolean delayError, io.reactivex.rxjava3.b.a onOverflow, g<? super T> onDropped) {
            this.downstream = actual;
            this.onOverflow = onOverflow;
            this.delayError = delayError;
            this.onDropped = onDropped;
            io.reactivex.rxjava3.operators.f<Object> q2 = unbounded ? new h(bufferSize) : new SpscArrayQueue(bufferSize);
            this.queue = q2;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            if (!this.queue.offer(t2)) {
                this.upstream.cancel();
                MissingBackpressureException ex = new MissingBackpressureException("Buffer is full");
                try {
                    this.onOverflow.run();
                    this.onDropped.accept(t2);
                }
                catch (Throwable e2) {
                    io.reactivex.rxjava3.exceptions.a.k(e2);
                    ex.initCause(e2);
                }
                this.onError(ex);
                return;
            }
            if (this.outputFused) {
                this.downstream.onNext(null);
            } else {
                this.drain();
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            if (this.outputFused) {
                this.downstream.onError(t2);
            } else {
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            if (this.outputFused) {
                this.downstream.onComplete();
            } else {
                this.drain();
            }
        }

        @Override
        public void request(long n2) {
            if (!this.outputFused && SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                if (!this.outputFused && this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void drain() {
            block5: {
                if (this.getAndIncrement() != 0) break block5;
                int missed = 1;
                io.reactivex.rxjava3.operators.f<T> q2 = this.queue;
                d<T> a2 = this.downstream;
                do {
                    boolean empty;
                    boolean d2;
                    long e2;
                    if (this.checkTerminated(this.done, q2.isEmpty(), a2)) {
                        return;
                    }
                    long r2 = this.requested.get();
                    for (e2 = 0L; e2 != r2; ++e2) {
                        boolean empty2;
                        d2 = this.done;
                        T v2 = q2.poll();
                        boolean bl2 = empty2 = v2 == null;
                        if (this.checkTerminated(d2, empty2, a2)) {
                            return;
                        }
                        if (empty2) break;
                        a2.onNext(v2);
                    }
                    if (e2 == r2 && this.checkTerminated(d2 = this.done, empty = q2.isEmpty(), a2)) {
                        return;
                    }
                    if (e2 == 0L || r2 == Long.MAX_VALUE) continue;
                    this.requested.addAndGet(-e2);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }

        boolean checkTerminated(boolean d2, boolean empty, d<? super T> a2) {
            if (this.cancelled) {
                this.queue.clear();
                return true;
            }
            if (d2) {
                if (this.delayError) {
                    if (empty) {
                        Throwable e2 = this.error;
                        if (e2 != null) {
                            a2.onError(e2);
                        } else {
                            a2.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e3 = this.error;
                    if (e3 != null) {
                        this.queue.clear();
                        a2.onError(e3);
                        return true;
                    }
                    if (empty) {
                        a2.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        @f
        public T poll() {
            return this.queue.poll();
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }
}

