/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.core.BackpressureOverflowStrategy;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.a.d;
import org.a.e;

public final class FlowableOnBackpressureBufferStrategy<T>
extends a<T, T> {
    final long Xw;
    final io.reactivex.rxjava3.b.a Xx;
    final BackpressureOverflowStrategy Xy;
    final g<? super T> Xz;

    public FlowableOnBackpressureBufferStrategy(j<T> source, long bufferSize, io.reactivex.rxjava3.b.a onOverflow, BackpressureOverflowStrategy strategy, g<? super T> onDropped) {
        super(source);
        this.Xw = bufferSize;
        this.Xx = onOverflow;
        this.Xy = strategy;
        this.Xz = onDropped;
    }

    @Override
    protected void d(d<? super T> s2) {
        this.QR.a(new OnBackpressureBufferStrategySubscriber<T>(s2, this.Xx, this.Xy, this.Xw, this.Xz));
    }

    static final class OnBackpressureBufferStrategySubscriber<T>
    extends AtomicInteger
    implements o<T>,
    e {
        private static final long serialVersionUID = 3240706908776709697L;
        final d<? super T> downstream;
        final io.reactivex.rxjava3.b.a onOverflow;
        final g<? super T> onDropped;
        final BackpressureOverflowStrategy strategy;
        final long bufferSize;
        final AtomicLong requested;
        final Deque<T> deque;
        e upstream;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;

        OnBackpressureBufferStrategySubscriber(d<? super T> actual, io.reactivex.rxjava3.b.a onOverflow, BackpressureOverflowStrategy strategy, long bufferSize, g<? super T> onDropped) {
            this.downstream = actual;
            this.onOverflow = onOverflow;
            this.strategy = strategy;
            this.bufferSize = bufferSize;
            this.requested = new AtomicLong();
            this.deque = new ArrayDeque<T>();
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            boolean callOnOverflow = false;
            boolean callError = false;
            boolean callDrain = false;
            Deque<T> dq = this.deque;
            Object toDrop = null;
            Deque<T> deque = dq;
            synchronized (deque) {
                if ((long)dq.size() == this.bufferSize) {
                    switch (this.strategy) {
                        case DROP_LATEST: {
                            toDrop = dq.pollLast();
                            dq.offer(t2);
                            callOnOverflow = true;
                            break;
                        }
                        case DROP_OLDEST: {
                            toDrop = dq.poll();
                            dq.offer(t2);
                            callOnOverflow = true;
                            break;
                        }
                        default: {
                            toDrop = t2;
                            callError = true;
                            break;
                        }
                    }
                } else {
                    dq.offer(t2);
                    callDrain = true;
                }
            }
            if (callOnOverflow && this.onOverflow != null) {
                try {
                    this.onOverflow.run();
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    this.upstream.cancel();
                    this.onError(ex);
                }
            }
            if (this.onDropped != null && toDrop != null) {
                try {
                    this.onDropped.accept(toDrop);
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    this.upstream.cancel();
                    this.onError(ex);
                }
            }
            if (callError) {
                this.upstream.cancel();
                this.onError(MissingBackpressureException.createDefault());
            }
            if (callDrain) {
                this.drain();
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            this.error = t2;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            if (this.getAndIncrement() == 0) {
                this.clear(this.deque);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear(Deque<T> dq) {
            Deque<T> deque = dq;
            synchronized (deque) {
                dq.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Deque<T> dq = this.deque;
            d<T> a2 = this.downstream;
            do {
                boolean d2;
                long e2;
                long r2 = this.requested.get();
                for (e2 = 0L; e2 != r2; ++e2) {
                    boolean empty2;
                    T v2;
                    if (this.cancelled) {
                        this.clear(dq);
                        return;
                    }
                    d2 = this.done;
                    Deque<T> deque = dq;
                    synchronized (deque) {
                        v2 = dq.poll();
                    }
                    boolean bl2 = empty2 = v2 == null;
                    if (d2) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.clear(dq);
                            a2.onError(ex);
                            return;
                        }
                        if (empty2) {
                            a2.onComplete();
                            return;
                        }
                    }
                    if (empty2) break;
                    a2.onNext(v2);
                }
                if (e2 == r2) {
                    boolean empty;
                    if (this.cancelled) {
                        this.clear(dq);
                        return;
                    }
                    d2 = this.done;
                    Deque<T> empty2 = dq;
                    synchronized (empty2) {
                        empty = dq.isEmpty();
                    }
                    if (d2) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.clear(dq);
                            a2.onError(ex);
                            return;
                        }
                        if (empty) {
                            a2.onComplete();
                            return;
                        }
                    }
                }
                if (e2 == 0L) continue;
                b.c(this.requested, e2);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

