/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.a.i;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowablePublish<T>
extends io.reactivex.rxjava3.a.a<T>
implements i<T> {
    final c<T> XL;
    final int XM;
    final AtomicReference<PublishConnection<T>> XN;

    public FlowablePublish(c<T> source, int bufferSize) {
        this.XL = source;
        this.XM = bufferSize;
        this.XN = new AtomicReference();
    }

    @Override
    public c<T> pH() {
        return this.XL;
    }

    @Override
    public void L(g<? super b> connection) {
        PublishConnection<T> conn;
        boolean doConnect = false;
        while ((conn = this.XN.get()) == null || conn.isDisposed()) {
            PublishConnection<T> fresh = new PublishConnection<T>(this.XN, this.XM);
            if (!this.XN.compareAndSet(conn, fresh)) continue;
            conn = fresh;
            break;
        }
        doConnect = !conn.connect.get() && conn.connect.compareAndSet(false, true);
        try {
            connection.accept(conn);
        }
        catch (Throwable ex) {
            a.k(ex);
            throw ExceptionHelper.r(ex);
        }
        if (doConnect) {
            this.XL.subscribe(conn);
        }
    }

    @Override
    protected void d(d<? super T> s2) {
        PublishConnection<Object> conn;
        while ((conn = this.XN.get()) == null) {
            PublishConnection<T> fresh = new PublishConnection<T>(this.XN, this.XM);
            if (!this.XN.compareAndSet(conn, fresh)) continue;
            conn = fresh;
            break;
        }
        InnerSubscription<T> inner = new InnerSubscription<T>(s2, conn);
        s2.onSubscribe(inner);
        if (conn.add(inner)) {
            if (inner.isCancelled()) {
                conn.remove(inner);
            } else {
                conn.drain();
            }
            return;
        }
        Throwable ex = conn.error;
        if (ex != null) {
            inner.downstream.onError(ex);
        } else {
            inner.downstream.onComplete();
        }
    }

    @Override
    public void reset() {
        PublishConnection<T> conn = this.XN.get();
        if (conn != null && conn.isDisposed()) {
            this.XN.compareAndSet(conn, null);
        }
    }

    static final class InnerSubscription<T>
    extends AtomicLong
    implements e {
        private static final long serialVersionUID = 2845000326761540265L;
        final d<? super T> downstream;
        final PublishConnection<T> parent;
        long emitted;

        InnerSubscription(d<? super T> downstream, PublishConnection<T> parent) {
            this.downstream = downstream;
            this.parent = parent;
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.b(this, n2);
                this.parent.drain();
            }
        }

        @Override
        public void cancel() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
                this.parent.drain();
            }
        }

        public boolean isCancelled() {
            return this.get() == Long.MIN_VALUE;
        }
    }

    static final class PublishConnection<T>
    extends AtomicInteger
    implements o<T>,
    b {
        private static final long serialVersionUID = -1672047311619175801L;
        final AtomicReference<PublishConnection<T>> current;
        final AtomicReference<e> upstream;
        final AtomicBoolean connect;
        final AtomicReference<InnerSubscription<T>[]> subscribers;
        final int bufferSize;
        volatile io.reactivex.rxjava3.operators.g<T> queue;
        int sourceMode;
        volatile boolean done;
        Throwable error;
        int consumed;
        static final InnerSubscription[] EMPTY = new InnerSubscription[0];
        static final InnerSubscription[] TERMINATED = new InnerSubscription[0];

        PublishConnection(AtomicReference<PublishConnection<T>> current, int bufferSize) {
            this.current = current;
            this.upstream = new AtomicReference();
            this.connect = new AtomicBoolean();
            this.bufferSize = bufferSize;
            this.subscribers = new AtomicReference<InnerSubscription[]>(EMPTY);
        }

        @Override
        public void dispose() {
            this.subscribers.getAndSet(TERMINATED);
            this.current.compareAndSet(this, null);
            SubscriptionHelper.cancel(this.upstream);
        }

        @Override
        public boolean isDisposed() {
            return this.subscribers.get() == TERMINATED;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.setOnce(this.upstream, s2)) {
                if (s2 instanceof io.reactivex.rxjava3.operators.d) {
                    io.reactivex.rxjava3.operators.d qs = (io.reactivex.rxjava3.operators.d)s2;
                    int m2 = qs.requestFusion(7);
                    if (m2 == 1) {
                        this.sourceMode = m2;
                        this.queue = qs;
                        this.done = true;
                        this.drain();
                        return;
                    }
                    if (m2 == 2) {
                        this.sourceMode = m2;
                        this.queue = qs;
                        s2.request(this.bufferSize);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.bufferSize);
                s2.request(this.bufferSize);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.sourceMode == 0 && !this.queue.offer(t2)) {
                this.onError(new QueueOverflowException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
            } else {
                this.error = t2;
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void drain() {
            boolean async;
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            io.reactivex.rxjava3.operators.g<T> queue = this.queue;
            int consumed = this.consumed;
            int limit = this.bufferSize - (this.bufferSize >> 2);
            boolean bl2 = async = this.sourceMode != 1;
            block2: while (true) {
                if (queue != null) {
                    InnerSubscription<T>[] consumers;
                    long minDemand = Long.MAX_VALUE;
                    boolean hasDemand = false;
                    for (InnerSubscription<T> inner : consumers = this.subscribers.get()) {
                        long request = inner.get();
                        if (request == Long.MIN_VALUE) continue;
                        hasDemand = true;
                        minDemand = Math.min(request - inner.emitted, minDemand);
                    }
                    if (!hasDemand) {
                        minDemand = 0L;
                    }
                    while (minDemand != 0L) {
                        boolean empty;
                        T v2;
                        boolean d2 = this.done;
                        try {
                            v2 = queue.poll();
                        }
                        catch (Throwable ex) {
                            a.k(ex);
                            this.upstream.get().cancel();
                            queue.clear();
                            this.done = true;
                            this.signalError(ex);
                            return;
                        }
                        boolean bl3 = empty = v2 == null;
                        if (this.checkTerminated(d2, empty)) {
                            return;
                        }
                        if (empty) break;
                        for (InnerSubscription<T> inner : consumers) {
                            if (inner.isCancelled()) continue;
                            inner.downstream.onNext(v2);
                            ++inner.emitted;
                        }
                        if (async && ++consumed == limit) {
                            consumed = 0;
                            this.upstream.get().request(limit);
                        }
                        --minDemand;
                        if (consumers == this.subscribers.get()) continue;
                        continue block2;
                    }
                    if (this.checkTerminated(this.done, queue.isEmpty())) {
                        return;
                    }
                }
                this.consumed = consumed;
                if ((missed = this.addAndGet(-missed)) == 0) break;
                if (queue != null) continue;
                queue = this.queue;
            }
        }

        boolean checkTerminated(boolean isDone, boolean isEmpty) {
            if (isDone && isEmpty) {
                Throwable ex = this.error;
                if (ex != null) {
                    this.signalError(ex);
                } else {
                    for (InnerSubscription inner : this.subscribers.getAndSet(TERMINATED)) {
                        if (inner.isCancelled()) continue;
                        inner.downstream.onComplete();
                    }
                }
                return true;
            }
            return false;
        }

        void signalError(Throwable ex) {
            for (InnerSubscription inner : this.subscribers.getAndSet(TERMINATED)) {
                if (inner.isCancelled()) continue;
                inner.downstream.onError(ex);
            }
        }

        boolean add(InnerSubscription<T> inner) {
            InnerSubscription[] u2;
            InnerSubscription<T>[] c2;
            do {
                if ((c2 = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int len = c2.length;
                u2 = new InnerSubscription[len + 1];
                System.arraycopy(c2, 0, u2, 0, len);
                u2[len] = inner;
            } while (!this.subscribers.compareAndSet(c2, u2));
            return true;
        }

        void remove(InnerSubscription<T> inner) {
            InnerSubscription<T>[] c2;
            int len;
            while ((len = (c2 = this.subscribers.get()).length) != 0) {
                InnerSubscription[] u2;
                int j2 = -1;
                for (int i2 = 0; i2 < len; ++i2) {
                    if (c2[i2] != inner) continue;
                    j2 = i2;
                    break;
                }
                if (j2 < 0) {
                    return;
                }
                if (len == 1) {
                    u2 = EMPTY;
                } else {
                    u2 = new InnerSubscription[len - 1];
                    System.arraycopy(c2, 0, u2, 0, j2);
                    System.arraycopy(c2, j2 + 1, u2, j2, len - j2 - 1);
                }
                if (!this.subscribers.compareAndSet(c2, u2)) continue;
                break;
            }
        }
    }
}

