/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.n;
import io.reactivex.rxjava3.operators.g;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowablePublishMulticast<T, R>
extends io.reactivex.rxjava3.internal.operators.flowable.a<T, R> {
    final h<? super j<T>, ? extends c<? extends R>> XO;
    final int XP;
    final boolean XQ;

    public FlowablePublishMulticast(j<T> source, h<? super j<T>, ? extends c<? extends R>> selector, int prefetch, boolean delayError) {
        super(source);
        this.XO = selector;
        this.XP = prefetch;
        this.XQ = delayError;
    }

    @Override
    protected void d(d<? super R> s2) {
        c<R> other;
        a mp = new a(this.XP, this.XQ);
        try {
            other = Objects.requireNonNull(this.XO.apply(mp), "selector returned a null Publisher");
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            EmptySubscription.error(ex, s2);
            return;
        }
        b<? super R> out = new b<R>(s2, mp);
        other.subscribe(out);
        this.QR.a(mp);
    }

    static final class MulticastSubscription<T>
    extends AtomicLong
    implements e {
        private static final long serialVersionUID = 8664815189257569791L;
        final d<? super T> downstream;
        final a<T> parent;
        long emitted;

        MulticastSubscription(d<? super T> actual, a<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.b(this, n2);
                this.parent.drain();
            }
        }

        @Override
        public void cancel() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.b(this);
                this.parent.drain();
            }
        }

        public boolean isCancelled() {
            return this.get() == Long.MIN_VALUE;
        }
    }

    static final class a<T>
    extends j<T>
    implements o<T> {
        static final MulticastSubscription[] XR = new MulticastSubscription[0];
        static final MulticastSubscription[] XS = new MulticastSubscription[0];
        final AtomicInteger XT;
        final AtomicReference<MulticastSubscription<T>[]> XU;
        final int XV;
        final int XW;
        final boolean XX;
        final AtomicReference<e> XY;
        volatile g<T> queue;
        int sourceMode;
        volatile boolean done;
        Throwable error;
        int consumed;

        a(int prefetch, boolean delayError) {
            this.XV = prefetch;
            this.XW = prefetch - (prefetch >> 2);
            this.XX = delayError;
            this.XT = new AtomicInteger();
            this.XY = new AtomicReference();
            this.XU = new AtomicReference<MulticastSubscription[]>(XR);
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.setOnce(this.XY, s2)) {
                if (s2 instanceof io.reactivex.rxjava3.operators.d) {
                    io.reactivex.rxjava3.operators.d qs = (io.reactivex.rxjava3.operators.d)s2;
                    int m2 = qs.requestFusion(3);
                    if (m2 == 1) {
                        this.sourceMode = m2;
                        this.queue = qs;
                        this.done = true;
                        this.drain();
                        return;
                    }
                    if (m2 == 2) {
                        this.sourceMode = m2;
                        this.queue = qs;
                        n.a(s2, this.XV);
                        return;
                    }
                }
                this.queue = n.aJ(this.XV);
                n.a(s2, this.XV);
            }
        }

        void dispose() {
            if (!this.done) {
                g<T> q2;
                SubscriptionHelper.cancel(this.XY);
                if (this.XT.getAndIncrement() == 0 && (q2 = this.queue) != null) {
                    q2.clear();
                }
            }
        }

        boolean isDisposed() {
            return this.XY.get() == SubscriptionHelper.CANCELLED;
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 0 && !this.queue.offer(t2)) {
                this.XY.get().cancel();
                this.onError(MissingBackpressureException.createDefault());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            this.error = t2;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.drain();
            }
        }

        boolean a(MulticastSubscription<T> s2) {
            MulticastSubscription[] next;
            MulticastSubscription<T>[] current;
            do {
                if ((current = this.XU.get()) == XS) {
                    return false;
                }
                int n2 = current.length;
                next = new MulticastSubscription[n2 + 1];
                System.arraycopy(current, 0, next, 0, n2);
                next[n2] = s2;
            } while (!this.XU.compareAndSet(current, next));
            return true;
        }

        void b(MulticastSubscription<T> s2) {
            MulticastSubscription[] next;
            MulticastSubscription<T>[] current;
            do {
                int n2;
                if ((n2 = (current = this.XU.get()).length) == 0) {
                    return;
                }
                int j2 = -1;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (current[i2] != s2) continue;
                    j2 = i2;
                    break;
                }
                if (j2 < 0) {
                    return;
                }
                if (n2 == 1) {
                    next = XR;
                    continue;
                }
                next = new MulticastSubscription[n2 - 1];
                System.arraycopy(current, 0, next, 0, j2);
                System.arraycopy(current, j2 + 1, next, j2, n2 - j2 - 1);
            } while (!this.XU.compareAndSet(current, next));
        }

        @Override
        protected void d(d<? super T> s2) {
            MulticastSubscription<T> ms = new MulticastSubscription<T>(s2, this);
            s2.onSubscribe(ms);
            if (this.a(ms)) {
                if (ms.isCancelled()) {
                    this.b(ms);
                    return;
                }
                this.drain();
            } else {
                Throwable ex = this.error;
                if (ex != null) {
                    s2.onError(ex);
                } else {
                    s2.onComplete();
                }
            }
        }

        void drain() {
            if (this.XT.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            g<T> q2 = this.queue;
            int upstreamConsumed = this.consumed;
            int localLimit = this.XW;
            boolean canRequest = this.sourceMode != 1;
            AtomicReference<MulticastSubscription<T>[]> subs = this.XU;
            MulticastSubscription<T>[] array = subs.get();
            block2: while (true) {
                int n2 = array.length;
                if (q2 != null && n2 != 0) {
                    long r2 = Long.MAX_VALUE;
                    for (MulticastSubscription<T> ms : array) {
                        long u2 = ms.get() - ms.emitted;
                        if (u2 != Long.MIN_VALUE) {
                            if (r2 <= u2) continue;
                            r2 = u2;
                            continue;
                        }
                        --n2;
                    }
                    if (n2 == 0) {
                        r2 = 0L;
                    }
                    while (r2 != 0L) {
                        boolean empty;
                        T v2;
                        Throwable ex;
                        if (this.isDisposed()) {
                            q2.clear();
                            return;
                        }
                        boolean d2 = this.done;
                        if (d2 && !this.XX && (ex = this.error) != null) {
                            this.n(ex);
                            return;
                        }
                        try {
                            v2 = q2.poll();
                        }
                        catch (Throwable ex2) {
                            io.reactivex.rxjava3.exceptions.a.k(ex2);
                            SubscriptionHelper.cancel(this.XY);
                            this.n(ex2);
                            return;
                        }
                        boolean bl2 = empty = v2 == null;
                        if (d2 && empty) {
                            Throwable ex3 = this.error;
                            if (ex3 != null) {
                                this.n(ex3);
                            } else {
                                this.qg();
                            }
                            return;
                        }
                        if (empty) break;
                        boolean subscribersChange = false;
                        for (MulticastSubscription<T> ms : array) {
                            long msr = ms.get();
                            if (msr != Long.MIN_VALUE) {
                                if (msr != Long.MAX_VALUE) {
                                    ++ms.emitted;
                                }
                                ms.downstream.onNext(v2);
                                continue;
                            }
                            subscribersChange = true;
                        }
                        --r2;
                        if (canRequest && ++upstreamConsumed == localLimit) {
                            upstreamConsumed = 0;
                            this.XY.get().request(localLimit);
                        }
                        MulticastSubscription<T>[] freshArray = subs.get();
                        if (!subscribersChange && freshArray == array) continue;
                        array = freshArray;
                        continue block2;
                    }
                    if (r2 == 0L) {
                        Throwable ex;
                        if (this.isDisposed()) {
                            q2.clear();
                            return;
                        }
                        boolean d3 = this.done;
                        if (d3 && !this.XX && (ex = this.error) != null) {
                            this.n(ex);
                            return;
                        }
                        if (d3 && q2.isEmpty()) {
                            ex = this.error;
                            if (ex != null) {
                                this.n(ex);
                            } else {
                                this.qg();
                            }
                            return;
                        }
                    }
                }
                this.consumed = upstreamConsumed;
                if ((missed = this.XT.addAndGet(-missed)) == 0) break;
                if (q2 == null) {
                    q2 = this.queue;
                }
                array = subs.get();
            }
        }

        void n(Throwable ex) {
            for (MulticastSubscription ms : this.XU.getAndSet(XS)) {
                if (ms.get() == Long.MIN_VALUE) continue;
                ms.downstream.onError(ex);
            }
        }

        void qg() {
            for (MulticastSubscription ms : this.XU.getAndSet(XS)) {
                if (ms.get() == Long.MIN_VALUE) continue;
                ms.downstream.onComplete();
            }
        }
    }

    static final class b<R>
    implements o<R>,
    e {
        final d<? super R> XZ;
        final a<?> Ya;
        e upstream;

        b(d<? super R> actual, a<?> processor) {
            this.XZ = actual;
            this.Ya = processor;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.XZ.onSubscribe(this);
            }
        }

        @Override
        public void onNext(R t2) {
            this.XZ.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.XZ.onError(t2);
            this.Ya.dispose();
        }

        @Override
        public void onComplete() {
            this.XZ.onComplete();
            this.Ya.dispose();
        }

        @Override
        public void request(long n2) {
            this.upstream.request(n2);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.Ya.dispose();
        }
    }
}

