/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.internal.a.i;
import io.reactivex.rxjava3.internal.subscribers.SubscriberResourceWrapper;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class FlowableReplay<T>
extends io.reactivex.rxjava3.a.a<T>
implements i<T> {
    final j<T> YA;
    final AtomicReference<ReplaySubscriber<T>> YB;
    final s<? extends c<T>> YC;
    final org.a.c<T> YD;
    static final s YE = new a();

    public static <U, R> j<R> a(s<? extends io.reactivex.rxjava3.a.a<U>> connectableFactory, h<? super j<U>, ? extends org.a.c<R>> selector) {
        return new b(connectableFactory, selector);
    }

    public static <T> io.reactivex.rxjava3.a.a<T> e(j<? extends T> source) {
        return FlowableReplay.a(source, YE);
    }

    public static <T> io.reactivex.rxjava3.a.a<T> b(j<T> source, int bufferSize, boolean eagerTruncate) {
        if (bufferSize == Integer.MAX_VALUE) {
            return FlowableReplay.e(source);
        }
        return FlowableReplay.a(source, new d(bufferSize, eagerTruncate));
    }

    public static <T> io.reactivex.rxjava3.a.a<T> b(j<T> source, long maxAge, TimeUnit unit, ah scheduler, boolean eagerTruncate) {
        return FlowableReplay.a(source, maxAge, unit, scheduler, Integer.MAX_VALUE, eagerTruncate);
    }

    public static <T> io.reactivex.rxjava3.a.a<T> a(j<T> source, long maxAge, TimeUnit unit, ah scheduler, int bufferSize, boolean eagerTruncate) {
        return FlowableReplay.a(source, new f(bufferSize, maxAge, unit, scheduler, eagerTruncate));
    }

    static <T> io.reactivex.rxjava3.a.a<T> a(j<T> source, s<? extends c<T>> bufferFactory) {
        AtomicReference curr = new AtomicReference();
        e onSubscribe = new e(curr, bufferFactory);
        return io.reactivex.rxjava3.d.a.a(new FlowableReplay(onSubscribe, source, curr, bufferFactory));
    }

    private FlowableReplay(org.a.c<T> onSubscribe, j<T> source, AtomicReference<ReplaySubscriber<T>> current, s<? extends c<T>> bufferFactory) {
        this.YD = onSubscribe;
        this.YA = source;
        this.YB = current;
        this.YC = bufferFactory;
    }

    @Override
    public org.a.c<T> pH() {
        return this.YA;
    }

    @Override
    protected void d(org.a.d<? super T> s2) {
        this.YD.subscribe(s2);
    }

    @Override
    public void reset() {
        ReplaySubscriber<T> conn = this.YB.get();
        if (conn != null && conn.isDisposed()) {
            this.YB.compareAndSet(conn, null);
        }
    }

    @Override
    public void L(g<? super io.reactivex.rxjava3.disposables.b> connection) {
        ReplaySubscriber<T> ps;
        while ((ps = this.YB.get()) == null || ps.isDisposed()) {
            c<T> buf;
            try {
                buf = this.YC.get();
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                throw ExceptionHelper.r(ex);
            }
            ReplaySubscriber<T> u2 = new ReplaySubscriber<T>(buf, this.YB);
            if (!this.YB.compareAndSet(ps, u2)) continue;
            ps = u2;
            break;
        }
        boolean doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        try {
            connection.accept(ps);
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            if (doConnect) {
                ps.shouldConnect.compareAndSet(true, false);
            }
            io.reactivex.rxjava3.exceptions.a.k(ex);
            throw ExceptionHelper.r(ex);
        }
        if (doConnect) {
            this.YA.a(ps);
        }
    }

    static final class a
    implements s<Object> {
        a() {
        }

        @Override
        public Object get() {
            return new UnboundedReplayBuffer(16);
        }
    }

    static final class e<T>
    implements org.a.c<T> {
        private final AtomicReference<ReplaySubscriber<T>> YL;
        private final s<? extends c<T>> YM;

        e(AtomicReference<ReplaySubscriber<T>> curr, s<? extends c<T>> bufferFactory) {
            this.YL = curr;
            this.YM = bufferFactory;
        }

        @Override
        public void subscribe(org.a.d<? super T> child) {
            ReplaySubscriber<Object> r2;
            while ((r2 = this.YL.get()) == null) {
                c<T> buf;
                try {
                    buf = this.YM.get();
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    EmptySubscription.error(ex, child);
                    return;
                }
                ReplaySubscriber<T> u2 = new ReplaySubscriber<T>(buf, this.YL);
                if (!this.YL.compareAndSet(null, u2)) continue;
                r2 = u2;
                break;
            }
            InnerSubscription<T> inner = new InnerSubscription<T>(r2, child);
            child.onSubscribe(inner);
            r2.add(inner);
            if (inner.isDisposed()) {
                r2.remove(inner);
                return;
            }
            r2.manageRequests();
            r2.buffer.replay(inner);
        }
    }

    static final class f<T>
    implements s<c<T>> {
        private final int YN;
        private final long YO;
        private final TimeUnit YP;
        private final ah YQ;
        final boolean YR;

        f(int bufferSize, long maxAge, TimeUnit unit, ah scheduler, boolean eagerTruncate) {
            this.YN = bufferSize;
            this.YO = maxAge;
            this.YP = unit;
            this.YQ = scheduler;
            this.YR = eagerTruncate;
        }

        public c<T> qh() {
            return new SizeAndTimeBoundReplayBuffer(this.YN, this.YO, this.YP, this.YQ, this.YR);
        }

        @Override
        public /* synthetic */ Object get() throws Throwable {
            return this.qh();
        }
    }

    static final class d<T>
    implements s<c<T>> {
        final int YJ;
        final boolean YK;

        d(int bufferSize, boolean eagerTruncate) {
            this.YJ = bufferSize;
            this.YK = eagerTruncate;
        }

        public c<T> qh() {
            return new SizeBoundReplayBuffer(this.YJ, this.YK);
        }

        @Override
        public /* synthetic */ Object get() throws Throwable {
            return this.qh();
        }
    }

    static final class b<R, U>
    extends j<R> {
        private final s<? extends io.reactivex.rxjava3.a.a<U>> YF;
        private final h<? super j<U>, ? extends org.a.c<R>> YG;

        b(s<? extends io.reactivex.rxjava3.a.a<U>> connectableFactory, h<? super j<U>, ? extends org.a.c<R>> selector) {
            this.YF = connectableFactory;
            this.YG = selector;
        }

        @Override
        protected void d(org.a.d<? super R> child) {
            org.a.c<R> observable;
            io.reactivex.rxjava3.a.a<U> cf;
            try {
                cf = ExceptionHelper.e(this.YF.get(), "The connectableFactory returned a null ConnectableFlowable.");
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                EmptySubscription.error(e2, child);
                return;
            }
            try {
                observable = ExceptionHelper.e(this.YG.apply(cf), "The selector returned a null Publisher.");
            }
            catch (Throwable e3) {
                io.reactivex.rxjava3.exceptions.a.k(e3);
                EmptySubscription.error(e3, child);
                return;
            }
            SubscriberResourceWrapper<? super R> srw = new SubscriberResourceWrapper<R>(child);
            observable.subscribe(srw);
            cf.L(new a(srw));
        }

        final class a
        implements g<io.reactivex.rxjava3.disposables.b> {
            private final SubscriberResourceWrapper<R> YH;

            a(SubscriberResourceWrapper<R> srw) {
                this.YH = srw;
            }

            @Override
            public void accept(io.reactivex.rxjava3.disposables.b r2) {
                this.YH.setResource(r2);
            }
        }
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = 3457957419649567404L;
        final ah scheduler;
        final long maxAge;
        final TimeUnit unit;
        final int limit;

        SizeAndTimeBoundReplayBuffer(int limit, long maxAge, TimeUnit unit, ah scheduler, boolean eagerTruncate) {
            super(eagerTruncate);
            this.scheduler = scheduler;
            this.limit = limit;
            this.maxAge = maxAge;
            this.unit = unit;
        }

        @Override
        Object enterTransform(Object value, boolean terminal) {
            return new io.reactivex.rxjava3.schedulers.c<Object>(value, terminal ? Long.MAX_VALUE : this.scheduler.h(this.unit), this.unit);
        }

        @Override
        Object leaveTransform(Object value) {
            return ((io.reactivex.rxjava3.schedulers.c)value).sd();
        }

        @Override
        void truncate() {
            long timeLimit = this.scheduler.h(this.unit) - this.maxAge;
            Node prev = (Node)this.get();
            Node next = (Node)prev.get();
            int e2 = 0;
            while (this.size > 1) {
                if (this.size > this.limit) {
                    ++e2;
                    --this.size;
                    prev = next;
                    next = (Node)next.get();
                    continue;
                }
                io.reactivex.rxjava3.schedulers.c v2 = (io.reactivex.rxjava3.schedulers.c)next.value;
                if (v2.sf() > timeLimit) break;
                ++e2;
                --this.size;
                prev = next;
                next = (Node)next.get();
            }
            if (e2 != 0) {
                this.setFirst(prev);
            }
        }

        @Override
        void truncateFinal() {
            io.reactivex.rxjava3.schedulers.c v2;
            long timeLimit = this.scheduler.h(this.unit) - this.maxAge;
            Node prev = (Node)this.get();
            Node next = (Node)prev.get();
            int e2 = 0;
            while (this.size > 1 && (v2 = (io.reactivex.rxjava3.schedulers.c)next.value).sf() <= timeLimit) {
                ++e2;
                --this.size;
                prev = next;
                next = (Node)next.get();
            }
            if (e2 != 0) {
                this.setFirst(prev);
            }
        }

        @Override
        Node getHead() {
            io.reactivex.rxjava3.schedulers.c v2;
            long timeLimit = this.scheduler.h(this.unit) - this.maxAge;
            Node prev = (Node)this.get();
            for (Node next = (Node)prev.get(); next != null && !NotificationLite.isComplete((v2 = (io.reactivex.rxjava3.schedulers.c)next.value).sd()) && !NotificationLite.isError(v2.sd()) && v2.sf() <= timeLimit; next = (Node)next.get()) {
                prev = next;
            }
            return prev;
        }
    }

    static final class SizeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = -5898283885385201806L;
        final int limit;

        SizeBoundReplayBuffer(int limit, boolean eagerTruncate) {
            super(eagerTruncate);
            this.limit = limit;
        }

        @Override
        void truncate() {
            if (this.size > this.limit) {
                this.removeFirst();
            }
        }
    }

    static abstract class BoundedReplayBuffer<T>
    extends AtomicReference<Node>
    implements c<T> {
        private static final long serialVersionUID = 2346567790059478686L;
        final boolean eagerTruncate;
        Node tail;
        int size;
        long index;

        BoundedReplayBuffer(boolean eagerTruncate) {
            Node n2;
            this.eagerTruncate = eagerTruncate;
            this.tail = n2 = new Node(null, 0L);
            this.set(n2);
        }

        final void addLast(Node n2) {
            this.tail.set(n2);
            this.tail = n2;
            ++this.size;
        }

        final void removeFirst() {
            Node head = (Node)this.get();
            Node next = (Node)head.get();
            if (next == null) {
                throw new IllegalStateException("Empty list!");
            }
            --this.size;
            this.setFirst(next);
        }

        final void removeSome(int n2) {
            Node head = (Node)this.get();
            while (n2 > 0) {
                head = (Node)head.get();
                --n2;
                --this.size;
            }
            this.setFirst(head);
            head = (Node)this.get();
            if (head.get() == null) {
                this.tail = head;
            }
        }

        final void setFirst(Node n2) {
            if (this.eagerTruncate) {
                Node m2 = new Node(null, n2.index);
                m2.lazySet(n2.get());
                n2 = m2;
            }
            this.set(n2);
        }

        @Override
        public final void next(T value) {
            Object o2 = this.enterTransform(NotificationLite.next(value), false);
            Node n2 = new Node(o2, ++this.index);
            this.addLast(n2);
            this.truncate();
        }

        @Override
        public final void error(Throwable e2) {
            Object o2 = this.enterTransform(NotificationLite.error(e2), true);
            Node n2 = new Node(o2, ++this.index);
            this.addLast(n2);
            this.truncateFinal();
        }

        @Override
        public final void complete() {
            Object o2 = this.enterTransform(NotificationLite.complete(), true);
            Node n2 = new Node(o2, ++this.index);
            this.addLast(n2);
            this.truncateFinal();
        }

        final void trimHead() {
            Node head = (Node)this.get();
            if (head.value != null) {
                Node n2 = new Node(null, 0L);
                n2.lazySet(head.get());
                this.set(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void replay(InnerSubscription<T> output) {
            InnerSubscription<T> innerSubscription = output;
            synchronized (innerSubscription) {
                if (output.emitting) {
                    output.missed = true;
                    return;
                }
                output.emitting = true;
            }
            while (true) {
                long r2;
                boolean unbounded = (r2 = output.get()) == Long.MAX_VALUE;
                long e2 = 0L;
                Node node = (Node)output.index();
                if (node == null) {
                    node = this.getHead();
                    output.index = node;
                    io.reactivex.rxjava3.internal.util.b.a(output.totalRequested, node.index);
                }
                while (r2 != 0L) {
                    if (output.isDisposed()) {
                        output.index = null;
                        return;
                    }
                    Node v2 = (Node)node.get();
                    if (v2 == null) break;
                    Object o2 = this.leaveTransform(v2.value);
                    try {
                        if (NotificationLite.accept(o2, output.child)) {
                            output.index = null;
                            return;
                        }
                    }
                    catch (Throwable err) {
                        io.reactivex.rxjava3.exceptions.a.k(err);
                        output.index = null;
                        output.dispose();
                        if (!NotificationLite.isError(o2) && !NotificationLite.isComplete(o2)) {
                            output.child.onError(err);
                        } else {
                            io.reactivex.rxjava3.d.a.onError(err);
                        }
                        return;
                    }
                    ++e2;
                    --r2;
                    node = v2;
                }
                if (r2 == 0L && output.isDisposed()) {
                    output.index = null;
                    return;
                }
                if (e2 != 0L) {
                    output.index = node;
                    if (!unbounded) {
                        output.produced(e2);
                    }
                }
                InnerSubscription<T> innerSubscription2 = output;
                synchronized (innerSubscription2) {
                    if (!output.missed) {
                        output.emitting = false;
                        return;
                    }
                    output.missed = false;
                }
            }
        }

        Object enterTransform(Object value, boolean terminal) {
            return value;
        }

        Object leaveTransform(Object value) {
            return value;
        }

        abstract void truncate();

        void truncateFinal() {
            this.trimHead();
        }

        final void collect(Collection<? super T> output) {
            Object o2;
            Object v2;
            Node next;
            Node n2 = this.getHead();
            while ((next = (Node)n2.get()) != null && !NotificationLite.isComplete(v2 = this.leaveTransform(o2 = next.value)) && !NotificationLite.isError(v2)) {
                output.add(NotificationLite.getValue(v2));
                n2 = next;
            }
        }

        boolean hasError() {
            return this.tail.value != null && NotificationLite.isError(this.leaveTransform(this.tail.value));
        }

        boolean hasCompleted() {
            return this.tail.value != null && NotificationLite.isComplete(this.leaveTransform(this.tail.value));
        }

        Node getHead() {
            return (Node)this.get();
        }
    }

    static final class Node
    extends AtomicReference<Node> {
        private static final long serialVersionUID = 245354315435971818L;
        final Object value;
        final long index;

        Node(Object value, long index) {
            this.value = value;
            this.index = index;
        }
    }

    static final class UnboundedReplayBuffer<T>
    extends ArrayList<Object>
    implements c<T> {
        private static final long serialVersionUID = 7063189396499112664L;
        volatile int size;

        UnboundedReplayBuffer(int capacityHint) {
            super(capacityHint);
        }

        @Override
        public void next(T value) {
            this.add(NotificationLite.next(value));
            ++this.size;
        }

        @Override
        public void error(Throwable e2) {
            this.add(NotificationLite.error(e2));
            ++this.size;
        }

        @Override
        public void complete() {
            this.add(NotificationLite.complete());
            ++this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replay(InnerSubscription<T> output) {
            InnerSubscription<T> innerSubscription = output;
            synchronized (innerSubscription) {
                if (output.emitting) {
                    output.missed = true;
                    return;
                }
                output.emitting = true;
            }
            org.a.d child = output.child;
            while (!output.isDisposed()) {
                long r2;
                int sourceIndex = this.size;
                Integer destinationIndexObject = (Integer)output.index();
                int destinationIndex = destinationIndexObject != null ? destinationIndexObject : 0;
                long r0 = r2 = output.get();
                long e2 = 0L;
                while (r2 != 0L && destinationIndex < sourceIndex) {
                    Object o2 = this.get(destinationIndex);
                    try {
                        if (NotificationLite.accept(o2, child)) {
                            return;
                        }
                    }
                    catch (Throwable err) {
                        io.reactivex.rxjava3.exceptions.a.k(err);
                        output.dispose();
                        if (!NotificationLite.isError(o2) && !NotificationLite.isComplete(o2)) {
                            child.onError(err);
                        } else {
                            io.reactivex.rxjava3.d.a.onError(err);
                        }
                        return;
                    }
                    if (output.isDisposed()) {
                        return;
                    }
                    ++destinationIndex;
                    --r2;
                    ++e2;
                }
                if (e2 != 0L) {
                    output.index = destinationIndex;
                    if (r0 != Long.MAX_VALUE) {
                        output.produced(e2);
                    }
                }
                InnerSubscription<T> innerSubscription2 = output;
                synchronized (innerSubscription2) {
                    if (!output.missed) {
                        output.emitting = false;
                        return;
                    }
                    output.missed = false;
                }
            }
            return;
        }
    }

    static interface c<T> {
        public void next(T var1);

        public void error(Throwable var1);

        public void complete();

        public void replay(InnerSubscription<T> var1);
    }

    static final class InnerSubscription<T>
    extends AtomicLong
    implements io.reactivex.rxjava3.disposables.b,
    org.a.e {
        private static final long serialVersionUID = -4453897557930727610L;
        final ReplaySubscriber<T> parent;
        final org.a.d<? super T> child;
        Object index;
        final AtomicLong totalRequested;
        boolean emitting;
        boolean missed;
        static final long CANCELLED = Long.MIN_VALUE;

        InnerSubscription(ReplaySubscriber<T> parent, org.a.d<? super T> child) {
            this.parent = parent;
            this.child = child;
            this.totalRequested = new AtomicLong();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2) && io.reactivex.rxjava3.internal.util.b.b(this, n2) != Long.MIN_VALUE) {
                io.reactivex.rxjava3.internal.util.b.a(this.totalRequested, n2);
                this.parent.manageRequests();
                this.parent.buffer.replay(this);
            }
        }

        public long produced(long n2) {
            return io.reactivex.rxjava3.internal.util.b.d(this, n2);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == Long.MIN_VALUE;
        }

        @Override
        public void cancel() {
            this.dispose();
        }

        @Override
        public void dispose() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
                this.parent.manageRequests();
                this.index = null;
            }
        }

        <U> U index() {
            return (U)this.index;
        }
    }

    static final class ReplaySubscriber<T>
    extends AtomicReference<org.a.e>
    implements o<T>,
    io.reactivex.rxjava3.disposables.b {
        private static final long serialVersionUID = 7224554242710036740L;
        final c<T> buffer;
        boolean done;
        static final InnerSubscription[] EMPTY = new InnerSubscription[0];
        static final InnerSubscription[] TERMINATED = new InnerSubscription[0];
        final AtomicReference<InnerSubscription<T>[]> subscribers;
        final AtomicBoolean shouldConnect;
        final AtomicInteger management;
        long requestedFromUpstream;
        final AtomicReference<ReplaySubscriber<T>> current;

        ReplaySubscriber(c<T> buffer, AtomicReference<ReplaySubscriber<T>> current) {
            this.buffer = buffer;
            this.current = current;
            this.management = new AtomicInteger();
            this.subscribers = new AtomicReference<InnerSubscription[]>(EMPTY);
            this.shouldConnect = new AtomicBoolean();
        }

        @Override
        public boolean isDisposed() {
            return this.subscribers.get() == TERMINATED;
        }

        @Override
        public void dispose() {
            this.subscribers.set(TERMINATED);
            this.current.compareAndSet(this, null);
            SubscriptionHelper.cancel(this);
        }

        boolean add(InnerSubscription<T> producer) {
            InnerSubscription[] u2;
            InnerSubscription<T>[] c2;
            do {
                if ((c2 = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int len = c2.length;
                u2 = new InnerSubscription[len + 1];
                System.arraycopy(c2, 0, u2, 0, len);
                u2[len] = producer;
            } while (!this.subscribers.compareAndSet(c2, u2));
            return true;
        }

        void remove(InnerSubscription<T> p2) {
            InnerSubscription[] u2;
            InnerSubscription<T>[] c2;
            do {
                int len;
                if ((len = (c2 = this.subscribers.get()).length) == 0) {
                    return;
                }
                int j2 = -1;
                for (int i2 = 0; i2 < len; ++i2) {
                    if (!c2[i2].equals(p2)) continue;
                    j2 = i2;
                    break;
                }
                if (j2 < 0) {
                    return;
                }
                if (len == 1) {
                    u2 = EMPTY;
                    continue;
                }
                u2 = new InnerSubscription[len - 1];
                System.arraycopy(c2, 0, u2, 0, j2);
                System.arraycopy(c2, j2 + 1, u2, j2, len - j2 - 1);
            } while (!this.subscribers.compareAndSet(c2, u2));
        }

        @Override
        public void onSubscribe(org.a.e p2) {
            if (SubscriptionHelper.setOnce(this, p2)) {
                this.manageRequests();
                for (InnerSubscription<T> rp : this.subscribers.get()) {
                    this.buffer.replay(rp);
                }
            }
        }

        @Override
        public void onNext(T t2) {
            if (!this.done) {
                this.buffer.next(t2);
                for (InnerSubscription<T> rp : this.subscribers.get()) {
                    this.buffer.replay(rp);
                }
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (!this.done) {
                this.done = true;
                this.buffer.error(e2);
                for (InnerSubscription rp : this.subscribers.getAndSet(TERMINATED)) {
                    this.buffer.replay(rp);
                }
            } else {
                io.reactivex.rxjava3.d.a.onError(e2);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.buffer.complete();
                for (InnerSubscription rp : this.subscribers.getAndSet(TERMINATED)) {
                    this.buffer.replay(rp);
                }
            }
        }

        void manageRequests() {
            AtomicInteger m2 = this.management;
            if (m2.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            do {
                long alreadyRequested;
                if (this.isDisposed()) {
                    return;
                }
                org.a.e p2 = (org.a.e)this.get();
                if (p2 == null) continue;
                long downstreamMaxRequest = alreadyRequested = this.requestedFromUpstream;
                for (InnerSubscription<T> rp : this.subscribers.get()) {
                    downstreamMaxRequest = Math.max(downstreamMaxRequest, rp.totalRequested.get());
                }
                long diff = downstreamMaxRequest - alreadyRequested;
                if (diff == 0L) continue;
                this.requestedFromUpstream = downstreamMaxRequest;
                p2.request(diff);
            } while ((missed = m2.addAndGet(-missed)) != 0);
        }
    }
}

