/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.r;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import java.util.concurrent.atomic.AtomicInteger;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableRetryPredicate<T>
extends a<T, T> {
    final r<? super Throwable> YT;
    final long YU;

    public FlowableRetryPredicate(j<T> source, long count, r<? super Throwable> predicate) {
        super(source);
        this.YT = predicate;
        this.YU = count;
    }

    @Override
    public void d(d<? super T> s2) {
        SubscriptionArbiter sa = new SubscriptionArbiter(false);
        s2.onSubscribe(sa);
        RetrySubscriber<T> rs = new RetrySubscriber<T>(s2, this.YU, this.YT, sa, this.QR);
        rs.subscribeNext();
    }

    static final class RetrySubscriber<T>
    extends AtomicInteger
    implements o<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final d<? super T> downstream;
        final SubscriptionArbiter sa;
        final c<? extends T> source;
        final r<? super Throwable> predicate;
        long remaining;
        long produced;

        RetrySubscriber(d<? super T> actual, long count, r<? super Throwable> predicate, SubscriptionArbiter sa, c<? extends T> source) {
            this.downstream = actual;
            this.sa = sa;
            this.source = source;
            this.predicate = predicate;
            this.remaining = count;
        }

        @Override
        public void onSubscribe(e s2) {
            this.sa.setSubscription(s2);
        }

        @Override
        public void onNext(T t2) {
            ++this.produced;
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            long r2 = this.remaining;
            if (r2 != Long.MAX_VALUE) {
                this.remaining = r2 - 1L;
            }
            if (r2 == 0L) {
                this.downstream.onError(t2);
            } else {
                boolean b2;
                try {
                    b2 = this.predicate.test(t2);
                }
                catch (Throwable e2) {
                    io.reactivex.rxjava3.exceptions.a.k(e2);
                    this.downstream.onError(new CompositeException(t2, e2));
                    return;
                }
                if (!b2) {
                    this.downstream.onError(t2);
                    return;
                }
                this.subscribeNext();
            }
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        void subscribeNext() {
            block3: {
                if (this.getAndIncrement() != 0) break block3;
                int missed = 1;
                do {
                    if (this.sa.isCancelled()) {
                        return;
                    }
                    long p2 = this.produced;
                    if (p2 != 0L) {
                        this.produced = 0L;
                        this.sa.produced(p2);
                    }
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

