/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableSamplePublisher<T>
extends j<T> {
    final c<T> YW;
    final c<?> YX;
    final boolean YY;

    public FlowableSamplePublisher(c<T> source, c<?> other, boolean emitLast) {
        this.YW = source;
        this.YX = other;
        this.YY = emitLast;
    }

    @Override
    protected void d(d<? super T> s2) {
        io.reactivex.rxjava3.subscribers.e<? super T> serial = new io.reactivex.rxjava3.subscribers.e<T>(s2);
        if (this.YY) {
            this.YW.subscribe(new SampleMainEmitLast<T>(serial, this.YX));
        } else {
            this.YW.subscribe(new SampleMainNoLast<T>(serial, this.YX));
        }
    }

    static final class SampleMainEmitLast<T>
    extends SamplePublisherSubscriber<T> {
        private static final long serialVersionUID = -3029755663834015785L;
        final AtomicInteger wip = new AtomicInteger();
        volatile boolean done;

        SampleMainEmitLast(d<? super T> actual, c<?> other) {
            super(actual, other);
        }

        @Override
        void completion() {
            this.done = true;
            if (this.wip.getAndIncrement() == 0) {
                this.emit();
                this.downstream.onComplete();
            }
        }

        @Override
        void run() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    boolean d2 = this.done;
                    this.emit();
                    if (!d2) continue;
                    this.downstream.onComplete();
                    return;
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }

    static final class SampleMainNoLast<T>
    extends SamplePublisherSubscriber<T> {
        private static final long serialVersionUID = -3029755663834015785L;

        SampleMainNoLast(d<? super T> actual, c<?> other) {
            super(actual, other);
        }

        @Override
        void completion() {
            this.downstream.onComplete();
        }

        @Override
        void run() {
            this.emit();
        }
    }

    static final class a<T>
    implements o<Object> {
        final SamplePublisherSubscriber<T> YZ;

        a(SamplePublisherSubscriber<T> parent) {
            this.YZ = parent;
        }

        @Override
        public void onSubscribe(e s2) {
            this.YZ.setOther(s2);
        }

        @Override
        public void onNext(Object t2) {
            this.YZ.run();
        }

        @Override
        public void onError(Throwable t2) {
            this.YZ.error(t2);
        }

        @Override
        public void onComplete() {
            this.YZ.complete();
        }
    }

    static abstract class SamplePublisherSubscriber<T>
    extends AtomicReference<T>
    implements o<T>,
    e {
        private static final long serialVersionUID = -3517602651313910099L;
        final d<? super T> downstream;
        final c<?> sampler;
        final AtomicLong requested = new AtomicLong();
        final AtomicReference<e> other = new AtomicReference();
        e upstream;

        SamplePublisherSubscriber(d<? super T> actual, c<?> other) {
            this.downstream = actual;
            this.sampler = other;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                if (this.other.get() == null) {
                    this.sampler.subscribe(new a(this));
                    s2.request(Long.MAX_VALUE);
                }
            }
        }

        @Override
        public void onNext(T t2) {
            this.lazySet(t2);
        }

        @Override
        public void onError(Throwable t2) {
            SubscriptionHelper.cancel(this.other);
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            SubscriptionHelper.cancel(this.other);
            this.completion();
        }

        void setOther(e o2) {
            SubscriptionHelper.setOnce(this.other, o2, Long.MAX_VALUE);
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
            }
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.other);
            this.upstream.cancel();
        }

        public void error(Throwable e2) {
            this.upstream.cancel();
            this.downstream.onError(e2);
        }

        public void complete() {
            this.upstream.cancel();
            this.completion();
        }

        void emit() {
            Object value = this.getAndSet(null);
            if (value != null) {
                long r2 = this.requested.get();
                if (r2 != 0L) {
                    this.downstream.onNext(value);
                    b.c(this.requested, 1L);
                } else {
                    this.cancel();
                    this.downstream.onError(MissingBackpressureException.createDefault());
                }
            }
        }

        abstract void completion();

        abstract void run();
    }
}

