/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableSampleTimed<T>
extends a<T, T> {
    final long Za;
    final TimeUnit Zb;
    final ah Zc;
    final boolean Zd;
    final g<? super T> Ze;

    public FlowableSampleTimed(j<T> source, long period, TimeUnit unit, ah scheduler, boolean emitLast, g<? super T> onDropped) {
        super(source);
        this.Za = period;
        this.Zb = unit;
        this.Zc = scheduler;
        this.Zd = emitLast;
        this.Ze = onDropped;
    }

    @Override
    protected void d(d<? super T> s2) {
        io.reactivex.rxjava3.subscribers.e<? super T> serial = new io.reactivex.rxjava3.subscribers.e<T>(s2);
        if (this.Zd) {
            this.QR.a(new SampleTimedEmitLast<T>(serial, this.Za, this.Zb, this.Zc, this.Ze));
        } else {
            this.QR.a(new SampleTimedNoLast<T>(serial, this.Za, this.Zb, this.Zc, this.Ze));
        }
    }

    static final class SampleTimedEmitLast<T>
    extends SampleTimedSubscriber<T> {
        private static final long serialVersionUID = -7139995637533111443L;
        final AtomicInteger wip = new AtomicInteger(1);

        SampleTimedEmitLast(d<? super T> actual, long period, TimeUnit unit, ah scheduler, g<? super T> onDropped) {
            super(actual, period, unit, scheduler, onDropped);
        }

        @Override
        void complete() {
            this.emit();
            if (this.wip.decrementAndGet() == 0) {
                this.downstream.onComplete();
            }
        }

        @Override
        public void run() {
            if (this.wip.incrementAndGet() == 2) {
                this.emit();
                if (this.wip.decrementAndGet() == 0) {
                    this.downstream.onComplete();
                }
            }
        }
    }

    static final class SampleTimedNoLast<T>
    extends SampleTimedSubscriber<T> {
        private static final long serialVersionUID = -7139995637533111443L;

        SampleTimedNoLast(d<? super T> actual, long period, TimeUnit unit, ah scheduler, g<? super T> onDropped) {
            super(actual, period, unit, scheduler, onDropped);
        }

        @Override
        void complete() {
            this.downstream.onComplete();
        }

        @Override
        public void run() {
            this.emit();
        }
    }

    static abstract class SampleTimedSubscriber<T>
    extends AtomicReference<T>
    implements o<T>,
    Runnable,
    e {
        private static final long serialVersionUID = -3517602651313910099L;
        final d<? super T> downstream;
        final long period;
        final TimeUnit unit;
        final ah scheduler;
        final g<? super T> onDropped;
        final AtomicLong requested = new AtomicLong();
        final SequentialDisposable timer = new SequentialDisposable();
        e upstream;

        SampleTimedSubscriber(d<? super T> actual, long period, TimeUnit unit, ah scheduler, g<? super T> onDropped) {
            this.downstream = actual;
            this.period = period;
            this.unit = unit;
            this.scheduler = scheduler;
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                this.timer.replace(this.scheduler.a(this, this.period, this.period, this.unit));
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            T oldValue = this.getAndSet(t2);
            if (oldValue != null && this.onDropped != null) {
                try {
                    this.onDropped.accept(oldValue);
                }
                catch (Throwable throwable) {
                    io.reactivex.rxjava3.exceptions.a.k(throwable);
                    this.cancelTimer();
                    this.upstream.cancel();
                    this.downstream.onError(throwable);
                }
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.cancelTimer();
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            this.cancelTimer();
            this.complete();
        }

        void cancelTimer() {
            DisposableHelper.dispose(this.timer);
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
            }
        }

        @Override
        public void cancel() {
            this.cancelTimer();
            this.upstream.cancel();
        }

        void emit() {
            Object value = this.getAndSet(null);
            if (value != null) {
                long r2 = this.requested.get();
                if (r2 != 0L) {
                    this.downstream.onNext(value);
                    b.c(this.requested, 1L);
                } else {
                    this.cancel();
                    this.downstream.onError(MissingBackpressureException.createDefault());
                }
            }
        }

        abstract void complete();
    }
}

