/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.c;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.f;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.a.d;
import org.a.e;

public final class FlowableScanSeed<T, R>
extends a<T, R> {
    final c<R, ? super T, R> Zk;
    final s<R> Zl;

    public FlowableScanSeed(j<T> source, s<R> seedSupplier, c<R, ? super T, R> accumulator) {
        super(source);
        this.Zk = accumulator;
        this.Zl = seedSupplier;
    }

    @Override
    protected void d(d<? super R> s2) {
        R r2;
        try {
            r2 = Objects.requireNonNull(this.Zl.get(), "The seed supplied is null");
        }
        catch (Throwable e2) {
            io.reactivex.rxjava3.exceptions.a.k(e2);
            EmptySubscription.error(e2, s2);
            return;
        }
        this.QR.a(new ScanSeedSubscriber<T, R>(s2, this.Zk, r2, FlowableScanSeed.mB()));
    }

    static final class ScanSeedSubscriber<T, R>
    extends AtomicInteger
    implements o<T>,
    e {
        private static final long serialVersionUID = -1776795561228106469L;
        final d<? super R> downstream;
        final c<R, ? super T, R> accumulator;
        final f<R> queue;
        final AtomicLong requested;
        final int prefetch;
        final int limit;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        e upstream;
        R value;
        int consumed;

        ScanSeedSubscriber(d<? super R> actual, c<R, ? super T, R> accumulator, R value, int prefetch) {
            this.downstream = actual;
            this.accumulator = accumulator;
            this.value = value;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.queue = new SpscArrayQueue<R>(prefetch);
            this.queue.offer(value);
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(this.prefetch - 1);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            R v2 = this.value;
            try {
                v2 = Objects.requireNonNull(this.accumulator.apply(v2, t2), "The accumulator returned a null value");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            this.value = v2;
            this.queue.offer(v2);
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            this.error = t2;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            d<R> a2 = this.downstream;
            f<R> q2 = this.queue;
            int lim = this.limit;
            int c2 = this.consumed;
            do {
                long e2;
                long r2 = this.requested.get();
                for (e2 = 0L; e2 != r2; ++e2) {
                    boolean empty;
                    Throwable ex;
                    if (this.cancelled) {
                        q2.clear();
                        return;
                    }
                    boolean d2 = this.done;
                    if (d2 && (ex = this.error) != null) {
                        q2.clear();
                        a2.onError(ex);
                        return;
                    }
                    R v2 = q2.poll();
                    boolean bl2 = empty = v2 == null;
                    if (d2 && empty) {
                        a2.onComplete();
                        return;
                    }
                    if (empty) break;
                    a2.onNext(v2);
                    if (++c2 != lim) continue;
                    c2 = 0;
                    this.upstream.request(lim);
                }
                if (e2 == r2 && this.done) {
                    Throwable ex = this.error;
                    if (ex != null) {
                        q2.clear();
                        a2.onError(ex);
                        return;
                    }
                    if (q2.isEmpty()) {
                        a2.onComplete();
                        return;
                    }
                }
                if (e2 != 0L) {
                    b.c(this.requested, e2);
                }
                this.consumed = c2;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

