/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.d;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.g;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.e;

public final class FlowableSequenceEqual<T>
extends j<Boolean> {
    final c<? extends T> Zm;
    final c<? extends T> Zn;
    final d<? super T, ? super T> Zo;
    final int Zp;

    public FlowableSequenceEqual(c<? extends T> first, c<? extends T> second, d<? super T, ? super T> comparer, int prefetch) {
        this.Zm = first;
        this.Zn = second;
        this.Zo = comparer;
        this.Zp = prefetch;
    }

    @Override
    public void d(org.a.d<? super Boolean> s2) {
        EqualCoordinator<? extends T> parent = new EqualCoordinator<T>(s2, this.Zp, this.Zo);
        s2.onSubscribe(parent);
        parent.subscribe(this.Zm, this.Zn);
    }

    static final class EqualSubscriber<T>
    extends AtomicReference<e>
    implements o<T> {
        private static final long serialVersionUID = 4804128302091633067L;
        final a parent;
        final int prefetch;
        final int limit;
        long produced;
        volatile g<T> queue;
        volatile boolean done;
        int sourceMode;

        EqualSubscriber(a parent, int prefetch) {
            this.parent = parent;
            this.limit = prefetch - (prefetch >> 2);
            this.prefetch = prefetch;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.setOnce(this, s2)) {
                if (s2 instanceof io.reactivex.rxjava3.operators.d) {
                    io.reactivex.rxjava3.operators.d qs = (io.reactivex.rxjava3.operators.d)s2;
                    int m2 = qs.requestFusion(3);
                    if (m2 == 1) {
                        this.sourceMode = m2;
                        this.queue = qs;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m2 == 2) {
                        this.sourceMode = m2;
                        this.queue = qs;
                        s2.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                s2.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.sourceMode == 0 && !this.queue.offer(t2)) {
                this.onError(MissingBackpressureException.createDefault());
                return;
            }
            this.parent.drain();
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.innerError(t2);
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        public void request() {
            if (this.sourceMode != 1) {
                long p2 = this.produced + 1L;
                if (p2 >= (long)this.limit) {
                    this.produced = 0L;
                    ((e)this.get()).request(p2);
                } else {
                    this.produced = p2;
                }
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel(this);
        }

        void clear() {
            g<T> sq = this.queue;
            if (sq != null) {
                sq.clear();
            }
        }
    }

    static final class EqualCoordinator<T>
    extends DeferredScalarSubscription<Boolean>
    implements a {
        private static final long serialVersionUID = -6178010334400373240L;
        final d<? super T, ? super T> comparer;
        final EqualSubscriber<T> first;
        final EqualSubscriber<T> second;
        final AtomicThrowable errors;
        final AtomicInteger wip;
        T v1;
        T v2;

        EqualCoordinator(org.a.d<? super Boolean> actual, int prefetch, d<? super T, ? super T> comparer) {
            super(actual);
            this.comparer = comparer;
            this.wip = new AtomicInteger();
            this.first = new EqualSubscriber(this, prefetch);
            this.second = new EqualSubscriber(this, prefetch);
            this.errors = new AtomicThrowable();
        }

        void subscribe(c<? extends T> source1, c<? extends T> source2) {
            source1.subscribe(this.first);
            source2.subscribe(this.second);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.first.cancel();
            this.second.cancel();
            this.errors.tryTerminateAndReport();
            if (this.wip.getAndIncrement() == 0) {
                this.first.clear();
                this.second.clear();
            }
        }

        void cancelAndClear() {
            this.first.cancel();
            this.first.clear();
            this.second.cancel();
            this.second.clear();
        }

        @Override
        public void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            block6: do {
                Throwable ex;
                g q1 = this.first.queue;
                g q2 = this.second.queue;
                if (q1 != null && q2 != null) {
                    while (true) {
                        boolean c2;
                        boolean e2;
                        if (this.isCancelled()) {
                            this.first.clear();
                            this.second.clear();
                            return;
                        }
                        ex = (Throwable)this.errors.get();
                        if (ex != null) {
                            this.cancelAndClear();
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        boolean d1 = this.first.done;
                        T a2 = this.v1;
                        if (a2 == null) {
                            try {
                                a2 = q1.poll();
                            }
                            catch (Throwable exc) {
                                io.reactivex.rxjava3.exceptions.a.k(exc);
                                this.cancelAndClear();
                                this.errors.tryAddThrowableOrReport(exc);
                                this.errors.tryTerminateConsumer(this.downstream);
                                return;
                            }
                            this.v1 = a2;
                        }
                        boolean e1 = a2 == null;
                        boolean d2 = this.second.done;
                        T b2 = this.v2;
                        if (b2 == null) {
                            try {
                                b2 = q2.poll();
                            }
                            catch (Throwable exc) {
                                io.reactivex.rxjava3.exceptions.a.k(exc);
                                this.cancelAndClear();
                                this.errors.tryAddThrowableOrReport(exc);
                                this.errors.tryTerminateConsumer(this.downstream);
                                return;
                            }
                            this.v2 = b2;
                        }
                        boolean bl2 = e2 = b2 == null;
                        if (d1 && d2 && e1 && e2) {
                            this.complete(true);
                            return;
                        }
                        if (d1 && d2 && e1 != e2) {
                            this.cancelAndClear();
                            this.complete(false);
                            return;
                        }
                        if (e1 || e2) continue block6;
                        try {
                            c2 = this.comparer.d(a2, b2);
                        }
                        catch (Throwable exc) {
                            io.reactivex.rxjava3.exceptions.a.k(exc);
                            this.cancelAndClear();
                            this.errors.tryAddThrowableOrReport(exc);
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        if (!c2) {
                            this.cancelAndClear();
                            this.complete(false);
                            return;
                        }
                        this.v1 = null;
                        this.v2 = null;
                        this.first.request();
                        this.second.request();
                    }
                }
                if (this.isCancelled()) {
                    this.first.clear();
                    this.second.clear();
                    return;
                }
                ex = (Throwable)this.errors.get();
                if (ex == null) continue;
                this.cancelAndClear();
                this.errors.tryTerminateConsumer(this.downstream);
                return;
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        @Override
        public void innerError(Throwable t2) {
            if (this.errors.tryAddThrowableOrReport(t2)) {
                this.drain();
            }
        }
    }

    static interface a {
        public void drain();

        public void innerError(Throwable var1);
    }
}

