/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.operators.h;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.a.d;
import org.a.e;

public final class FlowableSkipLastTimed<T>
extends a<T, T> {
    final long ZF;
    final TimeUnit ZG;
    final ah ZH;
    final int ZI;
    final boolean ZJ;

    public FlowableSkipLastTimed(j<T> source, long time, TimeUnit unit, ah scheduler, int bufferSize, boolean delayError) {
        super(source);
        this.ZF = time;
        this.ZG = unit;
        this.ZH = scheduler;
        this.ZI = bufferSize;
        this.ZJ = delayError;
    }

    @Override
    protected void d(d<? super T> s2) {
        this.QR.a(new SkipLastTimedSubscriber<T>(s2, this.ZF, this.ZG, this.ZH, this.ZI, this.ZJ));
    }

    static final class SkipLastTimedSubscriber<T>
    extends AtomicInteger
    implements o<T>,
    e {
        private static final long serialVersionUID = -5677354903406201275L;
        final d<? super T> downstream;
        final long time;
        final TimeUnit unit;
        final ah scheduler;
        final h<Object> queue;
        final boolean delayError;
        e upstream;
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;

        SkipLastTimedSubscriber(d<? super T> actual, long time, TimeUnit unit, ah scheduler, int bufferSize, boolean delayError) {
            this.downstream = actual;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.queue = new h(bufferSize);
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            long now = this.scheduler.h(this.unit);
            this.queue.offer(now, t2);
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            d<Object> a2 = this.downstream;
            h<Object> q2 = this.queue;
            boolean delayError = this.delayError;
            TimeUnit unit = this.unit;
            ah scheduler = this.scheduler;
            long time = this.time;
            do {
                long e2;
                long r2 = this.requested.get();
                for (e2 = 0L; e2 != r2; ++e2) {
                    boolean d2 = this.done;
                    Long ts = (Long)q2.peek();
                    boolean empty = ts == null;
                    long now = scheduler.h(unit);
                    if (!empty && ts > now - time) {
                        empty = true;
                    }
                    if (this.checkTerminated(d2, empty, a2, delayError)) {
                        return;
                    }
                    if (empty) break;
                    q2.poll();
                    Object v2 = q2.poll();
                    a2.onNext(v2);
                }
                if (e2 == 0L) continue;
                b.c(this.requested, e2);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminated(boolean d2, boolean empty, d<? super T> a2, boolean delayError) {
            if (this.cancelled) {
                this.queue.clear();
                return true;
            }
            if (d2) {
                if (delayError) {
                    if (empty) {
                        Throwable e2 = this.error;
                        if (e2 != null) {
                            a2.onError(e2);
                        } else {
                            a2.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e3 = this.error;
                    if (e3 != null) {
                        this.queue.clear();
                        a2.onError(e3);
                        return true;
                    }
                    if (empty) {
                        a2.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

