/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.operators.flowable.ba;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.g;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableSwitchMap<T, R>
extends a<T, R> {
    final h<? super T, ? extends c<? extends R>> ZX;
    final int ZY;
    final boolean ZZ;

    public FlowableSwitchMap(j<T> source, h<? super T, ? extends c<? extends R>> mapper, int bufferSize, boolean delayErrors) {
        super(source);
        this.ZX = mapper;
        this.ZY = bufferSize;
        this.ZZ = delayErrors;
    }

    @Override
    protected void d(d<? super R> s2) {
        if (ba.a(this.QR, s2, this.ZX)) {
            return;
        }
        this.QR.a(new SwitchMapSubscriber<T, R>(s2, this.ZX, this.ZY, this.ZZ));
    }

    static final class SwitchMapInnerSubscriber<T, R>
    extends AtomicReference<e>
    implements o<R> {
        private static final long serialVersionUID = 3837284832786408377L;
        final SwitchMapSubscriber<T, R> parent;
        final long index;
        final int bufferSize;
        volatile g<R> queue;
        volatile boolean done;
        int fusionMode;

        SwitchMapInnerSubscriber(SwitchMapSubscriber<T, R> parent, long index, int bufferSize) {
            this.parent = parent;
            this.index = index;
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.setOnce(this, s2)) {
                if (s2 instanceof io.reactivex.rxjava3.operators.d) {
                    io.reactivex.rxjava3.operators.d qs = (io.reactivex.rxjava3.operators.d)s2;
                    int m2 = qs.requestFusion(7);
                    if (m2 == 1) {
                        this.fusionMode = m2;
                        this.queue = qs;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m2 == 2) {
                        this.fusionMode = m2;
                        this.queue = qs;
                        s2.request(this.bufferSize);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<R>(this.bufferSize);
                s2.request(this.bufferSize);
            }
        }

        @Override
        public void onNext(R t2) {
            SwitchMapSubscriber<T, R> p2 = this.parent;
            if (this.index == p2.unique) {
                if (this.fusionMode == 0 && !this.queue.offer(t2)) {
                    this.onError(new QueueOverflowException());
                    return;
                }
                p2.drain();
            }
        }

        @Override
        public void onError(Throwable t2) {
            SwitchMapSubscriber<T, R> p2 = this.parent;
            if (this.index == p2.unique && p2.errors.tryAddThrowable(t2)) {
                if (!p2.delayErrors) {
                    p2.upstream.cancel();
                    p2.done = true;
                }
                this.done = true;
                p2.drain();
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            SwitchMapSubscriber<T, R> p2 = this.parent;
            if (this.index == p2.unique) {
                this.done = true;
                p2.drain();
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel(this);
        }

        public void request(long n2) {
            if (this.fusionMode != 1) {
                ((e)this.get()).request(n2);
            }
        }
    }

    static final class SwitchMapSubscriber<T, R>
    extends AtomicInteger
    implements o<T>,
    e {
        private static final long serialVersionUID = -3491074160481096299L;
        final d<? super R> downstream;
        final h<? super T, ? extends c<? extends R>> mapper;
        final int bufferSize;
        final boolean delayErrors;
        volatile boolean done;
        final AtomicThrowable errors;
        volatile boolean cancelled;
        e upstream;
        final AtomicReference<SwitchMapInnerSubscriber<T, R>> active = new AtomicReference();
        final AtomicLong requested = new AtomicLong();
        static final SwitchMapInnerSubscriber<Object, Object> CANCELLED = new SwitchMapInnerSubscriber(null, -1L, 1);
        volatile long unique;

        SwitchMapSubscriber(d<? super R> actual, h<? super T, ? extends c<? extends R>> mapper, int bufferSize, boolean delayErrors) {
            this.downstream = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            c<R> p2;
            long c2;
            if (this.done) {
                return;
            }
            this.unique = c2 = this.unique + 1L;
            SwitchMapInnerSubscriber<T, R> inner = this.active.get();
            if (inner != null) {
                inner.cancel();
            }
            try {
                p2 = Objects.requireNonNull(this.mapper.apply(t2), "The publisher returned is null");
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                this.upstream.cancel();
                this.onError(e2);
                return;
            }
            SwitchMapInnerSubscriber nextInner = new SwitchMapInnerSubscriber(this, c2, this.bufferSize);
            while ((inner = this.active.get()) != CANCELLED) {
                if (!this.active.compareAndSet(inner, nextInner)) continue;
                p2.subscribe(nextInner);
                break;
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (!this.done && this.errors.tryAddThrowable(t2)) {
                if (!this.delayErrors) {
                    this.disposeInner();
                }
                this.done = true;
                this.drain();
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
                if (this.unique == 0L) {
                    this.upstream.request(Long.MAX_VALUE);
                } else {
                    this.drain();
                }
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                this.disposeInner();
                this.errors.tryTerminateAndReport();
            }
        }

        void disposeInner() {
            SwitchMapInnerSubscriber<Object, Object> a2 = this.active.getAndSet(CANCELLED);
            if (a2 != CANCELLED && a2 != null) {
                a2.cancel();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            d<R> a2 = this.downstream;
            int missing = 1;
            while (true) {
                SwitchMapInnerSubscriber<T, R> inner;
                g q2;
                if (this.cancelled) {
                    return;
                }
                if (this.done) {
                    if (this.delayErrors) {
                        if (this.active.get() == null) {
                            this.errors.tryTerminateConsumer(a2);
                            return;
                        }
                    } else {
                        Throwable err = (Throwable)this.errors.get();
                        if (err != null) {
                            this.disposeInner();
                            this.errors.tryTerminateConsumer(a2);
                            return;
                        }
                        if (this.active.get() == null) {
                            a2.onComplete();
                            return;
                        }
                    }
                }
                g g2 = q2 = (inner = this.active.get()) != null ? inner.queue : null;
                if (q2 != null) {
                    long e2;
                    long r2 = this.requested.get();
                    boolean retry = false;
                    for (e2 = 0L; e2 != r2; ++e2) {
                        boolean empty;
                        Object v2;
                        if (this.cancelled) {
                            return;
                        }
                        boolean d2 = inner.done;
                        try {
                            v2 = q2.poll();
                        }
                        catch (Throwable ex) {
                            io.reactivex.rxjava3.exceptions.a.k(ex);
                            inner.cancel();
                            this.errors.tryAddThrowableOrReport(ex);
                            d2 = true;
                            v2 = null;
                        }
                        boolean bl2 = empty = v2 == null;
                        if (inner != this.active.get()) {
                            retry = true;
                            break;
                        }
                        if (d2) {
                            if (!this.delayErrors) {
                                Throwable err = (Throwable)this.errors.get();
                                if (err != null) {
                                    this.errors.tryTerminateConsumer(a2);
                                    return;
                                }
                                if (empty) {
                                    this.active.compareAndSet(inner, null);
                                    retry = true;
                                    break;
                                }
                            } else if (empty) {
                                this.active.compareAndSet(inner, null);
                                retry = true;
                                break;
                            }
                        }
                        if (empty) break;
                        a2.onNext(v2);
                    }
                    if (e2 == r2 && inner.done) {
                        if (!this.delayErrors) {
                            Throwable err = (Throwable)this.errors.get();
                            if (err != null) {
                                this.disposeInner();
                                this.errors.tryTerminateConsumer(a2);
                                return;
                            }
                            if (q2.isEmpty()) {
                                this.active.compareAndSet(inner, null);
                                continue;
                            }
                        } else if (q2.isEmpty()) {
                            this.active.compareAndSet(inner, null);
                            continue;
                        }
                    }
                    if (e2 != 0L && !this.cancelled) {
                        if (r2 != Long.MAX_VALUE) {
                            this.requested.addAndGet(-e2);
                        }
                        inner.request(e2);
                    }
                    if (retry) continue;
                }
                if ((missing = this.addAndGet(-missing)) == 0) break;
            }
        }

        static {
            CANCELLED.cancel();
        }
    }
}

