/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableThrottleLatest<T>
extends a<T, T> {
    final long aav;
    final TimeUnit aaw;
    final ah aax;
    final boolean aay;
    final g<? super T> aaz;

    public FlowableThrottleLatest(j<T> source, long timeout, TimeUnit unit, ah scheduler, boolean emitLast, g<? super T> onDropped) {
        super(source);
        this.aav = timeout;
        this.aaw = unit;
        this.aax = scheduler;
        this.aay = emitLast;
        this.aaz = onDropped;
    }

    @Override
    protected void d(d<? super T> s2) {
        this.QR.a(new ThrottleLatestSubscriber<T>(s2, this.aav, this.aaw, this.aax.oS(), this.aay, this.aaz));
    }

    static final class ThrottleLatestSubscriber<T>
    extends AtomicInteger
    implements o<T>,
    Runnable,
    e {
        private static final long serialVersionUID = -8296689127439125014L;
        final d<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final ah.c worker;
        final boolean emitLast;
        final AtomicReference<T> latest;
        final AtomicLong requested;
        final g<? super T> onDropped;
        e upstream;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;
        volatile boolean timerFired;
        long emitted;
        boolean timerRunning;

        ThrottleLatestSubscriber(d<? super T> downstream, long timeout, TimeUnit unit, ah.c worker, boolean emitLast, g<? super T> onDropped) {
            this.downstream = downstream;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.emitLast = emitLast;
            this.latest = new AtomicReference();
            this.requested = new AtomicLong();
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            T old = this.latest.getAndSet(t2);
            if (this.onDropped != null && old != null) {
                try {
                    this.onDropped.accept(old);
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    this.upstream.cancel();
                    this.error = ex;
                    this.done = true;
                }
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.worker.dispose();
            if (this.getAndIncrement() == 0) {
                this.clear();
            }
        }

        void clear() {
            if (this.onDropped != null) {
                Object v2 = this.latest.getAndSet(null);
                if (v2 != null) {
                    try {
                        this.onDropped.accept(v2);
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        io.reactivex.rxjava3.d.a.onError(ex);
                    }
                }
            } else {
                this.latest.lazySet(null);
            }
        }

        @Override
        public void run() {
            this.timerFired = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            AtomicReference<T> latest = this.latest;
            AtomicLong requested = this.requested;
            d<T> downstream = this.downstream;
            while (true) {
                long e2;
                boolean empty;
                T v2;
                if (this.cancelled) {
                    this.clear();
                    return;
                }
                boolean d2 = this.done;
                Throwable error = this.error;
                if (d2 && error != null) {
                    if (this.onDropped != null) {
                        v2 = latest.getAndSet(null);
                        if (v2 != null) {
                            try {
                                this.onDropped.accept(v2);
                            }
                            catch (Throwable ex) {
                                io.reactivex.rxjava3.exceptions.a.k(ex);
                                error = new CompositeException(error, ex);
                            }
                        }
                    } else {
                        latest.lazySet(null);
                    }
                    downstream.onError(error);
                    this.worker.dispose();
                    return;
                }
                v2 = latest.get();
                boolean bl2 = empty = v2 == null;
                if (d2) {
                    if (!empty) {
                        v2 = latest.getAndSet(null);
                        if (this.emitLast) {
                            e2 = this.emitted;
                            if (e2 != requested.get()) {
                                this.emitted = e2 + 1L;
                                downstream.onNext(v2);
                                downstream.onComplete();
                            } else {
                                this.tryDropAndSignalMBE(v2);
                            }
                        } else {
                            if (this.onDropped != null) {
                                try {
                                    this.onDropped.accept(v2);
                                }
                                catch (Throwable ex) {
                                    io.reactivex.rxjava3.exceptions.a.k(ex);
                                    downstream.onError(ex);
                                    this.worker.dispose();
                                    return;
                                }
                            }
                            downstream.onComplete();
                        }
                    } else {
                        downstream.onComplete();
                    }
                    this.worker.dispose();
                    return;
                }
                if (empty) {
                    if (this.timerFired) {
                        this.timerRunning = false;
                        this.timerFired = false;
                    }
                } else if (!this.timerRunning || this.timerFired) {
                    v2 = latest.getAndSet(null);
                    e2 = this.emitted;
                    if (e2 == requested.get()) {
                        this.upstream.cancel();
                        this.tryDropAndSignalMBE(v2);
                        this.worker.dispose();
                        return;
                    }
                    downstream.onNext(v2);
                    this.emitted = e2 + 1L;
                    this.timerFired = false;
                    this.timerRunning = true;
                    this.worker.b(this, this.timeout, this.unit);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void tryDropAndSignalMBE(T valueToDrop) {
            RuntimeException errorToSignal = MissingBackpressureException.createDefault();
            if (this.onDropped != null) {
                try {
                    this.onDropped.accept(valueToDrop);
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    errorToSignal = new CompositeException(errorToSignal, ex);
                }
            }
            this.downstream.onError(errorToSignal);
        }
    }
}

