/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableTimeoutTimed;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableTimeout<T, U, V>
extends io.reactivex.rxjava3.internal.operators.flowable.a<T, T> {
    final c<U> aaF;
    final h<? super T, ? extends c<V>> aaG;
    final c<? extends T> aaH;

    public FlowableTimeout(j<T> source, c<U> firstTimeoutIndicator, h<? super T, ? extends c<V>> itemTimeoutIndicator, c<? extends T> other) {
        super(source);
        this.aaF = firstTimeoutIndicator;
        this.aaG = itemTimeoutIndicator;
        this.aaH = other;
    }

    @Override
    protected void d(d<? super T> s2) {
        if (this.aaH == null) {
            TimeoutSubscriber<T> parent = new TimeoutSubscriber<T>(s2, this.aaG);
            s2.onSubscribe(parent);
            parent.startFirstTimeout(this.aaF);
            this.QR.a(parent);
        } else {
            TimeoutFallbackSubscriber<T> parent = new TimeoutFallbackSubscriber<T>(s2, this.aaG, this.aaH);
            s2.onSubscribe(parent);
            parent.startFirstTimeout(this.aaF);
            this.QR.a(parent);
        }
    }

    static final class TimeoutConsumer
    extends AtomicReference<e>
    implements o<Object>,
    b {
        private static final long serialVersionUID = 8708641127342403073L;
        final a parent;
        final long idx;

        TimeoutConsumer(long idx, a parent) {
            this.idx = idx;
            this.parent = parent;
        }

        @Override
        public void onSubscribe(e s2) {
            SubscriptionHelper.setOnce(this, s2, Long.MAX_VALUE);
        }

        @Override
        public void onNext(Object t2) {
            e upstream = (e)this.get();
            if (upstream != SubscriptionHelper.CANCELLED) {
                upstream.cancel();
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.parent.onTimeout(this.idx);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.get() != SubscriptionHelper.CANCELLED) {
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.parent.onTimeoutError(this.idx, t2);
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.get() != SubscriptionHelper.CANCELLED) {
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.parent.onTimeout(this.idx);
            }
        }

        @Override
        public void dispose() {
            SubscriptionHelper.cancel(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == SubscriptionHelper.CANCELLED;
        }
    }

    static final class TimeoutFallbackSubscriber<T>
    extends SubscriptionArbiter
    implements o<T>,
    a {
        private static final long serialVersionUID = 3764492702657003550L;
        final d<? super T> downstream;
        final h<? super T, ? extends c<?>> itemTimeoutIndicator;
        final SequentialDisposable task;
        final AtomicReference<e> upstream;
        final AtomicLong index;
        c<? extends T> fallback;
        long consumed;

        TimeoutFallbackSubscriber(d<? super T> actual, h<? super T, ? extends c<?>> itemTimeoutIndicator, c<? extends T> fallback) {
            super(true);
            this.downstream = actual;
            this.itemTimeoutIndicator = itemTimeoutIndicator;
            this.task = new SequentialDisposable();
            this.upstream = new AtomicReference();
            this.fallback = fallback;
            this.index = new AtomicLong();
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.setOnce(this.upstream, s2)) {
                this.setSubscription(s2);
            }
        }

        @Override
        public void onNext(T t2) {
            c<?> itemTimeoutPublisher;
            long idx = this.index.get();
            if (idx == Long.MAX_VALUE || !this.index.compareAndSet(idx, idx + 1L)) {
                return;
            }
            b d2 = (b)this.task.get();
            if (d2 != null) {
                d2.dispose();
            }
            ++this.consumed;
            this.downstream.onNext(t2);
            try {
                itemTimeoutPublisher = Objects.requireNonNull(this.itemTimeoutIndicator.apply(t2), "The itemTimeoutIndicator returned a null Publisher.");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.get().cancel();
                this.index.getAndSet(Long.MAX_VALUE);
                this.downstream.onError(ex);
                return;
            }
            TimeoutConsumer consumer = new TimeoutConsumer(idx + 1L, this);
            if (this.task.replace(consumer)) {
                itemTimeoutPublisher.subscribe(consumer);
            }
        }

        void startFirstTimeout(c<?> firstTimeoutIndicator) {
            TimeoutConsumer consumer;
            if (firstTimeoutIndicator != null && this.task.replace(consumer = new TimeoutConsumer(0L, this))) {
                firstTimeoutIndicator.subscribe(consumer);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onError(t2);
                this.task.dispose();
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onComplete();
                this.task.dispose();
            }
        }

        @Override
        public void onTimeout(long idx) {
            if (this.index.compareAndSet(idx, Long.MAX_VALUE)) {
                SubscriptionHelper.cancel(this.upstream);
                c<? super T> f2 = this.fallback;
                this.fallback = null;
                long c2 = this.consumed;
                if (c2 != 0L) {
                    this.produced(c2);
                }
                f2.subscribe(new FlowableTimeoutTimed.a<T>(this.downstream, this));
            }
        }

        @Override
        public void onTimeoutError(long idx, Throwable ex) {
            if (this.index.compareAndSet(idx, Long.MAX_VALUE)) {
                SubscriptionHelper.cancel(this.upstream);
                this.downstream.onError(ex);
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.task.dispose();
        }
    }

    static final class TimeoutSubscriber<T>
    extends AtomicLong
    implements o<T>,
    a,
    e {
        private static final long serialVersionUID = 3764492702657003550L;
        final d<? super T> downstream;
        final h<? super T, ? extends c<?>> itemTimeoutIndicator;
        final SequentialDisposable task;
        final AtomicReference<e> upstream;
        final AtomicLong requested;

        TimeoutSubscriber(d<? super T> actual, h<? super T, ? extends c<?>> itemTimeoutIndicator) {
            this.downstream = actual;
            this.itemTimeoutIndicator = itemTimeoutIndicator;
            this.task = new SequentialDisposable();
            this.upstream = new AtomicReference();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(e s2) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, s2);
        }

        @Override
        public void onNext(T t2) {
            c<?> itemTimeoutPublisher;
            long idx = this.get();
            if (idx == Long.MAX_VALUE || !this.compareAndSet(idx, idx + 1L)) {
                return;
            }
            b d2 = (b)this.task.get();
            if (d2 != null) {
                d2.dispose();
            }
            this.downstream.onNext(t2);
            try {
                itemTimeoutPublisher = Objects.requireNonNull(this.itemTimeoutIndicator.apply(t2), "The itemTimeoutIndicator returned a null Publisher.");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.get().cancel();
                this.getAndSet(Long.MAX_VALUE);
                this.downstream.onError(ex);
                return;
            }
            TimeoutConsumer consumer = new TimeoutConsumer(idx + 1L, this);
            if (this.task.replace(consumer)) {
                itemTimeoutPublisher.subscribe(consumer);
            }
        }

        void startFirstTimeout(c<?> firstTimeoutIndicator) {
            TimeoutConsumer consumer;
            if (firstTimeoutIndicator != null && this.task.replace(consumer = new TimeoutConsumer(0L, this))) {
                firstTimeoutIndicator.subscribe(consumer);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onError(t2);
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onComplete();
            }
        }

        @Override
        public void onTimeout(long idx) {
            if (this.compareAndSet(idx, Long.MAX_VALUE)) {
                SubscriptionHelper.cancel(this.upstream);
                this.downstream.onError(new TimeoutException());
            }
        }

        @Override
        public void onTimeoutError(long idx, Throwable ex) {
            if (this.compareAndSet(idx, Long.MAX_VALUE)) {
                SubscriptionHelper.cancel(this.upstream);
                this.downstream.onError(ex);
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }

        @Override
        public void request(long n2) {
            SubscriptionHelper.deferredRequest(this.upstream, this.requested, n2);
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
            this.task.dispose();
        }
    }

    static interface a
    extends FlowableTimeoutTimed.b {
        public void onTimeoutError(long var1, Throwable var3);
    }
}

