/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableTimeoutTimed<T>
extends io.reactivex.rxjava3.internal.operators.flowable.a<T, T> {
    final long aaI;
    final TimeUnit aaJ;
    final ah aaK;
    final org.a.c<? extends T> aaL;

    public FlowableTimeoutTimed(j<T> source, long timeout, TimeUnit unit, ah scheduler, org.a.c<? extends T> other) {
        super(source);
        this.aaI = timeout;
        this.aaJ = unit;
        this.aaK = scheduler;
        this.aaL = other;
    }

    @Override
    protected void d(d<? super T> s2) {
        if (this.aaL == null) {
            TimeoutSubscriber<T> parent = new TimeoutSubscriber<T>(s2, this.aaI, this.aaJ, this.aaK.oS());
            s2.onSubscribe(parent);
            parent.startTimeout(0L);
            this.QR.a(parent);
        } else {
            TimeoutFallbackSubscriber<T> parent = new TimeoutFallbackSubscriber<T>(s2, this.aaI, this.aaJ, this.aaK.oS(), this.aaL);
            s2.onSubscribe(parent);
            parent.startTimeout(0L);
            this.QR.a(parent);
        }
    }

    static interface b {
        public void onTimeout(long var1);
    }

    static final class a<T>
    implements o<T> {
        final d<? super T> aaM;
        final SubscriptionArbiter aaN;

        a(d<? super T> actual, SubscriptionArbiter arbiter) {
            this.aaM = actual;
            this.aaN = arbiter;
        }

        @Override
        public void onSubscribe(e s2) {
            this.aaN.setSubscription(s2);
        }

        @Override
        public void onNext(T t2) {
            this.aaM.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.aaM.onError(t2);
        }

        @Override
        public void onComplete() {
            this.aaM.onComplete();
        }
    }

    static final class TimeoutFallbackSubscriber<T>
    extends SubscriptionArbiter
    implements o<T>,
    b {
        private static final long serialVersionUID = 3764492702657003550L;
        final d<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final ah.c worker;
        final SequentialDisposable task;
        final AtomicReference<e> upstream;
        final AtomicLong index;
        long consumed;
        org.a.c<? extends T> fallback;

        TimeoutFallbackSubscriber(d<? super T> actual, long timeout, TimeUnit unit, ah.c worker, org.a.c<? extends T> fallback) {
            super(true);
            this.downstream = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.fallback = fallback;
            this.task = new SequentialDisposable();
            this.upstream = new AtomicReference();
            this.index = new AtomicLong();
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.setOnce(this.upstream, s2)) {
                this.setSubscription(s2);
            }
        }

        @Override
        public void onNext(T t2) {
            long idx = this.index.get();
            if (idx == Long.MAX_VALUE || !this.index.compareAndSet(idx, idx + 1L)) {
                return;
            }
            ((io.reactivex.rxjava3.disposables.b)this.task.get()).dispose();
            ++this.consumed;
            this.downstream.onNext(t2);
            this.startTimeout(idx + 1L);
        }

        void startTimeout(long nextIndex) {
            this.task.replace(this.worker.b(new c(nextIndex, this), this.timeout, this.unit));
        }

        @Override
        public void onError(Throwable t2) {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onError(t2);
                this.worker.dispose();
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onComplete();
                this.worker.dispose();
            }
        }

        @Override
        public void onTimeout(long idx) {
            if (this.index.compareAndSet(idx, Long.MAX_VALUE)) {
                SubscriptionHelper.cancel(this.upstream);
                long c2 = this.consumed;
                if (c2 != 0L) {
                    this.produced(c2);
                }
                org.a.c<? super T> f2 = this.fallback;
                this.fallback = null;
                f2.subscribe(new a<T>(this.downstream, this));
                this.worker.dispose();
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.worker.dispose();
        }
    }

    static final class c
    implements Runnable {
        final b aaO;
        final long aaP;

        c(long idx, b parent) {
            this.aaP = idx;
            this.aaO = parent;
        }

        @Override
        public void run() {
            this.aaO.onTimeout(this.aaP);
        }
    }

    static final class TimeoutSubscriber<T>
    extends AtomicLong
    implements o<T>,
    b,
    e {
        private static final long serialVersionUID = 3764492702657003550L;
        final d<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final ah.c worker;
        final SequentialDisposable task;
        final AtomicReference<e> upstream;
        final AtomicLong requested;

        TimeoutSubscriber(d<? super T> actual, long timeout, TimeUnit unit, ah.c worker) {
            this.downstream = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.task = new SequentialDisposable();
            this.upstream = new AtomicReference();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(e s2) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, s2);
        }

        @Override
        public void onNext(T t2) {
            long idx = this.get();
            if (idx == Long.MAX_VALUE || !this.compareAndSet(idx, idx + 1L)) {
                return;
            }
            ((io.reactivex.rxjava3.disposables.b)this.task.get()).dispose();
            this.downstream.onNext(t2);
            this.startTimeout(idx + 1L);
        }

        void startTimeout(long nextIndex) {
            this.task.replace(this.worker.b(new c(nextIndex, this), this.timeout, this.unit));
        }

        @Override
        public void onError(Throwable t2) {
            if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onError(t2);
                this.worker.dispose();
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onComplete();
                this.worker.dispose();
            }
        }

        @Override
        public void onTimeout(long idx) {
            if (this.compareAndSet(idx, Long.MAX_VALUE)) {
                SubscriptionHelper.cancel(this.upstream);
                this.downstream.onError(new TimeoutException(ExceptionHelper.Y(this.timeout, this.unit)));
                this.worker.dispose();
            }
        }

        @Override
        public void request(long n2) {
            SubscriptionHelper.deferredRequest(this.upstream, this.requested, n2);
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
            this.worker.dispose();
        }
    }
}

