/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableUsing<T, D>
extends j<T> {
    final s<? extends D> aba;
    final h<? super D, ? extends c<? extends T>> abb;
    final g<? super D> abc;
    final boolean abd;

    public FlowableUsing(s<? extends D> resourceSupplier, h<? super D, ? extends c<? extends T>> sourceSupplier, g<? super D> disposer, boolean eager) {
        this.aba = resourceSupplier;
        this.abb = sourceSupplier;
        this.abc = disposer;
        this.abd = eager;
    }

    @Override
    public void d(d<? super T> s2) {
        c<T> source;
        D resource;
        try {
            resource = this.aba.get();
        }
        catch (Throwable e2) {
            io.reactivex.rxjava3.exceptions.a.k(e2);
            EmptySubscription.error(e2, s2);
            return;
        }
        try {
            source = Objects.requireNonNull(this.abb.apply(resource), "The sourceSupplier returned a null Publisher");
        }
        catch (Throwable e3) {
            io.reactivex.rxjava3.exceptions.a.k(e3);
            try {
                this.abc.accept(resource);
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                EmptySubscription.error(new CompositeException(e3, ex), s2);
                return;
            }
            EmptySubscription.error(e3, s2);
            return;
        }
        UsingSubscriber<? super T, ? super D> us = new UsingSubscriber<T, D>(s2, resource, this.abc, this.abd);
        source.subscribe(us);
    }

    static final class UsingSubscriber<T, D>
    extends AtomicBoolean
    implements o<T>,
    e {
        private static final long serialVersionUID = 5904473792286235046L;
        final d<? super T> downstream;
        final D resource;
        final g<? super D> disposer;
        final boolean eager;
        e upstream;

        UsingSubscriber(d<? super T> actual, D resource, g<? super D> disposer, boolean eager) {
            this.downstream = actual;
            this.resource = resource;
            this.disposer = disposer;
            this.eager = eager;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.eager) {
                Throwable innerError = null;
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e2) {
                        io.reactivex.rxjava3.exceptions.a.k(e2);
                        innerError = e2;
                    }
                }
                if (innerError != null) {
                    this.downstream.onError(new CompositeException(t2, innerError));
                } else {
                    this.downstream.onError(t2);
                }
            } else {
                this.downstream.onError(t2);
                this.disposeResource();
            }
        }

        @Override
        public void onComplete() {
            if (this.eager) {
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e2) {
                        io.reactivex.rxjava3.exceptions.a.k(e2);
                        this.downstream.onError(e2);
                        return;
                    }
                }
                this.downstream.onComplete();
            } else {
                this.downstream.onComplete();
                this.disposeResource();
            }
        }

        @Override
        public void request(long n2) {
            this.upstream.request(n2);
        }

        @Override
        public void cancel() {
            if (this.eager) {
                this.disposeResource();
                this.upstream.cancel();
                this.upstream = SubscriptionHelper.CANCELLED;
            } else {
                this.upstream.cancel();
                this.upstream = SubscriptionHelper.CANCELLED;
                this.disposeResource();
            }
        }

        void disposeResource() {
            if (this.compareAndSet(false, true)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable e2) {
                    io.reactivex.rxjava3.exceptions.a.k(e2);
                    a.onError(e2);
                }
            }
        }
    }
}

