/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.operators.flowable.bn;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.operators.h;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.a.d;
import org.a.e;

public final class FlowableWindow<T>
extends a<T, j<T>> {
    final long abe;
    final long abf;
    final int abg;

    public FlowableWindow(j<T> source, long size, long skip, int bufferSize) {
        super(source);
        this.abe = size;
        this.abf = skip;
        this.abg = bufferSize;
    }

    @Override
    public void d(d<? super j<T>> s2) {
        if (this.abf == this.abe) {
            this.QR.a(new WindowExactSubscriber(s2, this.abe, this.abg));
        } else if (this.abf > this.abe) {
            this.QR.a(new WindowSkipSubscriber(s2, this.abe, this.abf, this.abg));
        } else {
            this.QR.a(new WindowOverlapSubscriber(s2, this.abe, this.abf, this.abg));
        }
    }

    static final class WindowOverlapSubscriber<T>
    extends AtomicInteger
    implements o<T>,
    Runnable,
    e {
        private static final long serialVersionUID = 2428527070996323976L;
        final d<? super j<T>> downstream;
        final h<UnicastProcessor<T>> queue;
        final long size;
        final long skip;
        final ArrayDeque<UnicastProcessor<T>> windows;
        final AtomicBoolean once;
        final AtomicBoolean firstRequest;
        final AtomicLong requested;
        final AtomicInteger wip;
        final int bufferSize;
        long index;
        long produced;
        e upstream;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;

        WindowOverlapSubscriber(d<? super j<T>> actual, long size, long skip, int bufferSize) {
            super(1);
            this.downstream = actual;
            this.size = size;
            this.skip = skip;
            this.queue = new h(bufferSize);
            this.windows = new ArrayDeque();
            this.once = new AtomicBoolean();
            this.firstRequest = new AtomicBoolean();
            this.requested = new AtomicLong();
            this.wip = new AtomicInteger();
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            long p2;
            long i2 = this.index;
            UnicastProcessor newWindow = null;
            if (i2 == 0L && !this.cancelled) {
                this.getAndIncrement();
                newWindow = UnicastProcessor.a(this.bufferSize, this);
                this.windows.offer(newWindow);
            }
            ++i2;
            for (org.a.b b2 : this.windows) {
                b2.onNext(t2);
            }
            if (newWindow != null) {
                this.queue.offer(newWindow);
                this.drain();
            }
            if ((p2 = this.produced + 1L) == this.size) {
                this.produced = p2 - this.skip;
                org.a.b w3 = this.windows.poll();
                if (w3 != null) {
                    w3.onComplete();
                }
            } else {
                this.produced = p2;
            }
            this.index = i2 == this.skip ? 0L : i2;
        }

        @Override
        public void onError(Throwable t2) {
            for (org.a.b b2 : this.windows) {
                b2.onError(t2);
            }
            this.windows.clear();
            this.error = t2;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            for (org.a.b b2 : this.windows) {
                b2.onComplete();
            }
            this.windows.clear();
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            d<j<bn<T>>> a2 = this.downstream;
            h<UnicastProcessor<T>> q2 = this.queue;
            int missed = 1;
            block0: while (true) {
                if (this.cancelled) {
                    UnicastProcessor<T> up = null;
                    while ((up = q2.poll()) != null) {
                        up.onComplete();
                    }
                } else {
                    long e2;
                    long r2 = this.requested.get();
                    for (e2 = 0L; e2 != r2; ++e2) {
                        boolean empty;
                        boolean d2 = this.done;
                        UnicastProcessor<T> t2 = q2.poll();
                        boolean bl2 = empty = t2 == null;
                        if (this.cancelled) continue block0;
                        if (this.checkTerminated(d2, empty, a2, q2)) {
                            return;
                        }
                        if (empty) break;
                        bn<T> intercept = new bn<T>(t2);
                        a2.onNext(intercept);
                        if (!intercept.tryAbandon()) continue;
                        t2.onComplete();
                    }
                    if (e2 == r2) {
                        if (this.cancelled) continue;
                        if (this.checkTerminated(this.done, q2.isEmpty(), a2, q2)) {
                            return;
                        }
                    }
                    if (e2 != 0L && r2 != Long.MAX_VALUE) {
                        this.requested.addAndGet(-e2);
                    }
                }
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            }
        }

        boolean checkTerminated(boolean d2, boolean empty, d<?> a2, h<?> q2) {
            if (d2) {
                Throwable e2 = this.error;
                if (e2 != null) {
                    q2.clear();
                    a2.onError(e2);
                    return true;
                }
                if (empty) {
                    a2.onComplete();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
                if (!this.firstRequest.get() && this.firstRequest.compareAndSet(false, true)) {
                    long u2 = b.h(this.skip, n2 - 1L);
                    long v2 = b.g(this.size, u2);
                    this.upstream.request(v2);
                } else {
                    long u3 = b.h(this.skip, n2);
                    this.upstream.request(u3);
                }
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            if (this.once.compareAndSet(false, true)) {
                this.run();
            }
            this.drain();
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }
    }

    static final class WindowSkipSubscriber<T>
    extends AtomicInteger
    implements o<T>,
    Runnable,
    e {
        private static final long serialVersionUID = -8792836352386833856L;
        final d<? super j<T>> downstream;
        final long size;
        final long skip;
        final AtomicBoolean once;
        final AtomicBoolean firstRequest;
        final int bufferSize;
        long index;
        e upstream;
        UnicastProcessor<T> window;

        WindowSkipSubscriber(d<? super j<T>> actual, long size, long skip, int bufferSize) {
            super(1);
            this.downstream = actual;
            this.size = size;
            this.skip = skip;
            this.once = new AtomicBoolean();
            this.firstRequest = new AtomicBoolean();
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            long i2 = this.index;
            bn<T> intercept = null;
            UnicastProcessor<T> w2 = this.window;
            if (i2 == 0L) {
                this.getAndIncrement();
                w2 = UnicastProcessor.a(this.bufferSize, this);
                this.window = w2;
                intercept = new bn<T>(w2);
                this.downstream.onNext(intercept);
            }
            ++i2;
            if (w2 != null) {
                w2.onNext(t2);
            }
            if (i2 == this.size) {
                this.window = null;
                w2.onComplete();
            }
            this.index = i2 == this.skip ? 0L : i2;
            if (intercept != null && intercept.tryAbandon()) {
                intercept.abs.onComplete();
            }
        }

        @Override
        public void onError(Throwable t2) {
            UnicastProcessor<T> w2 = this.window;
            if (w2 != null) {
                this.window = null;
                w2.onError(t2);
            }
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            UnicastProcessor<T> w2 = this.window;
            if (w2 != null) {
                this.window = null;
                w2.onComplete();
            }
            this.downstream.onComplete();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                if (!this.firstRequest.get() && this.firstRequest.compareAndSet(false, true)) {
                    long u2 = b.h(this.size, n2);
                    long v2 = b.h(this.skip - this.size, n2 - 1L);
                    long w2 = b.g(u2, v2);
                    this.upstream.request(w2);
                } else {
                    long u3 = b.h(this.skip, n2);
                    this.upstream.request(u3);
                }
            }
        }

        @Override
        public void cancel() {
            if (this.once.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }
    }

    static final class WindowExactSubscriber<T>
    extends AtomicInteger
    implements o<T>,
    Runnable,
    e {
        private static final long serialVersionUID = -2365647875069161133L;
        final d<? super j<T>> downstream;
        final long size;
        final AtomicBoolean once;
        final int bufferSize;
        long index;
        e upstream;
        UnicastProcessor<T> window;

        WindowExactSubscriber(d<? super j<T>> actual, long size, int bufferSize) {
            super(1);
            this.downstream = actual;
            this.size = size;
            this.once = new AtomicBoolean();
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            long i2 = this.index;
            UnicastProcessor<T> w2 = this.window;
            bn<T> intercept = null;
            if (i2 == 0L) {
                this.getAndIncrement();
                w2 = UnicastProcessor.a(this.bufferSize, this);
                this.window = w2;
                intercept = new bn<T>(w2);
                this.downstream.onNext(intercept);
            }
            w2.onNext(t2);
            if (++i2 == this.size) {
                this.index = 0L;
                this.window = null;
                w2.onComplete();
            } else {
                this.index = i2;
            }
            if (intercept != null && intercept.tryAbandon()) {
                intercept.abs.onComplete();
            }
        }

        @Override
        public void onError(Throwable t2) {
            UnicastProcessor<T> w2 = this.window;
            if (w2 != null) {
                this.window = null;
                w2.onError(t2);
            }
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            UnicastProcessor<T> w2 = this.window;
            if (w2 != null) {
                this.window = null;
                w2.onComplete();
            }
            this.downstream.onComplete();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                long u2 = b.h(this.size, n2);
                this.upstream.request(u2);
            }
        }

        @Override
        public void cancel() {
            if (this.once.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }
    }
}

