/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.operators.flowable.bn;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableWindowBoundary<T, B>
extends io.reactivex.rxjava3.internal.operators.flowable.a<T, j<T>> {
    final c<B> abh;
    final int abi;

    public FlowableWindowBoundary(j<T> source, c<B> other, int capacityHint) {
        super(source);
        this.abh = other;
        this.abi = capacityHint;
    }

    @Override
    protected void d(d<? super j<T>> subscriber) {
        WindowBoundaryMainSubscriber parent = new WindowBoundaryMainSubscriber(subscriber, this.abi);
        subscriber.onSubscribe(parent);
        parent.innerNext();
        this.abh.subscribe(parent.boundarySubscriber);
        this.QR.a(parent);
    }

    static final class a<T, B>
    extends io.reactivex.rxjava3.subscribers.b<B> {
        final WindowBoundaryMainSubscriber<T, B> abj;
        boolean done;

        a(WindowBoundaryMainSubscriber<T, B> parent) {
            this.abj = parent;
        }

        @Override
        public void onNext(B t2) {
            if (this.done) {
                return;
            }
            this.abj.innerNext();
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            this.done = true;
            this.abj.innerError(t2);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.abj.innerComplete();
        }
    }

    static final class WindowBoundaryMainSubscriber<T, B>
    extends AtomicInteger
    implements o<T>,
    Runnable,
    e {
        private static final long serialVersionUID = 2233020065421370272L;
        final d<? super j<T>> downstream;
        final int capacityHint;
        final a<T, B> boundarySubscriber;
        final AtomicReference<e> upstream;
        final AtomicInteger windows;
        final MpscLinkedQueue<Object> queue;
        final AtomicThrowable errors;
        final AtomicBoolean stopWindows;
        final AtomicLong requested;
        static final Object NEXT_WINDOW = new Object();
        volatile boolean done;
        UnicastProcessor<T> window;
        long emitted;

        WindowBoundaryMainSubscriber(d<? super j<T>> downstream, int capacityHint) {
            this.downstream = downstream;
            this.capacityHint = capacityHint;
            this.boundarySubscriber = new a(this);
            this.upstream = new AtomicReference();
            this.windows = new AtomicInteger(1);
            this.queue = new MpscLinkedQueue();
            this.errors = new AtomicThrowable();
            this.stopWindows = new AtomicBoolean();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(e s2) {
            SubscriptionHelper.setOnce(this.upstream, s2, Long.MAX_VALUE);
        }

        @Override
        public void onNext(T t2) {
            this.queue.offer(t2);
            this.drain();
        }

        @Override
        public void onError(Throwable e2) {
            this.boundarySubscriber.dispose();
            if (this.errors.tryAddThrowableOrReport(e2)) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.boundarySubscriber.dispose();
            this.done = true;
            this.drain();
        }

        @Override
        public void cancel() {
            if (this.stopWindows.compareAndSet(false, true)) {
                this.boundarySubscriber.dispose();
                if (this.windows.decrementAndGet() == 0) {
                    SubscriptionHelper.cancel(this.upstream);
                }
            }
        }

        @Override
        public void request(long n2) {
            b.a(this.requested, n2);
        }

        @Override
        public void run() {
            if (this.windows.decrementAndGet() == 0) {
                SubscriptionHelper.cancel(this.upstream);
            }
        }

        void innerNext() {
            this.queue.offer(NEXT_WINDOW);
            this.drain();
        }

        void innerError(Throwable e2) {
            SubscriptionHelper.cancel(this.upstream);
            if (this.errors.tryAddThrowableOrReport(e2)) {
                this.done = true;
                this.drain();
            }
        }

        void innerComplete() {
            SubscriptionHelper.cancel(this.upstream);
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            d<j<bn<T>>> downstream = this.downstream;
            MpscLinkedQueue<Object> queue = this.queue;
            AtomicThrowable errors = this.errors;
            long emitted = this.emitted;
            while (true) {
                boolean empty;
                if (this.windows.get() == 0) {
                    queue.clear();
                    this.window = null;
                    return;
                }
                UnicastProcessor<Object> w2 = this.window;
                boolean d2 = this.done;
                if (d2 && errors.get() != null) {
                    queue.clear();
                    Throwable ex = errors.terminate();
                    if (w2 != null) {
                        this.window = null;
                        w2.onError(ex);
                    }
                    downstream.onError(ex);
                    return;
                }
                Object v2 = queue.poll();
                boolean bl2 = empty = v2 == null;
                if (d2 && empty) {
                    Throwable ex = errors.terminate();
                    if (ex == null) {
                        if (w2 != null) {
                            this.window = null;
                            w2.onComplete();
                        }
                        downstream.onComplete();
                    } else {
                        if (w2 != null) {
                            this.window = null;
                            w2.onError(ex);
                        }
                        downstream.onError(ex);
                    }
                    return;
                }
                if (!empty) {
                    if (v2 != NEXT_WINDOW) {
                        w2.onNext(v2);
                        continue;
                    }
                    if (w2 != null) {
                        this.window = null;
                        w2.onComplete();
                    }
                    if (this.stopWindows.get()) continue;
                    w2 = UnicastProcessor.a(this.capacityHint, this);
                    this.window = w2;
                    this.windows.getAndIncrement();
                    if (emitted != this.requested.get()) {
                        ++emitted;
                        bn<T> intercept = new bn<T>(w2);
                        downstream.onNext(intercept);
                        if (!intercept.tryAbandon()) continue;
                        w2.onComplete();
                        continue;
                    }
                    SubscriptionHelper.cancel(this.upstream);
                    this.boundarySubscriber.dispose();
                    errors.tryAddThrowableOrReport(MissingBackpressureException.createDefault());
                    this.done = true;
                    continue;
                }
                this.emitted = emitted;
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

