/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableWindowTimed;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.f;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableWindowBoundarySelector<T, B, V>
extends a<T, j<T>> {
    final c<B> abk;
    final h<? super B, ? extends c<V>> abl;
    final int abm;

    public FlowableWindowBoundarySelector(j<T> source, c<B> open, h<? super B, ? extends c<V>> closingIndicator, int bufferSize) {
        super(source);
        this.abk = open;
        this.abl = closingIndicator;
        this.abm = bufferSize;
    }

    @Override
    protected void d(d<? super j<T>> s2) {
        this.QR.a(new WindowBoundaryMainSubscriber(s2, this.abk, this.abl, this.abm));
    }

    static final class WindowBoundaryMainSubscriber<T, B, V>
    extends AtomicInteger
    implements o<T>,
    Runnable,
    e {
        private static final long serialVersionUID = 8646217640096099753L;
        final d<? super j<T>> downstream;
        final c<B> open;
        final h<? super B, ? extends c<V>> closingIndicator;
        final int bufferSize;
        final io.reactivex.rxjava3.disposables.a resources;
        final WindowStartSubscriber<B> startSubscriber;
        final List<UnicastProcessor<T>> windows;
        final f<Object> queue;
        final AtomicLong windowCount;
        final AtomicBoolean downstreamCancelled;
        final AtomicLong requested;
        long emitted;
        volatile boolean upstreamCanceled;
        volatile boolean upstreamDone;
        volatile boolean openDone;
        final AtomicThrowable error;
        e upstream;

        WindowBoundaryMainSubscriber(d<? super j<T>> actual, c<B> open, h<? super B, ? extends c<V>> closingIndicator, int bufferSize) {
            this.downstream = actual;
            this.queue = new MpscLinkedQueue<Object>();
            this.open = open;
            this.closingIndicator = closingIndicator;
            this.bufferSize = bufferSize;
            this.resources = new io.reactivex.rxjava3.disposables.a();
            this.windows = new ArrayList<UnicastProcessor<T>>();
            this.windowCount = new AtomicLong(1L);
            this.downstreamCancelled = new AtomicBoolean();
            this.error = new AtomicThrowable();
            this.startSubscriber = new WindowStartSubscriber(this);
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                this.open.subscribe(this.startSubscriber);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            this.queue.offer(t2);
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            this.startSubscriber.cancel();
            this.resources.dispose();
            if (this.error.tryAddThrowableOrReport(t2)) {
                this.upstreamDone = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.startSubscriber.cancel();
            this.resources.dispose();
            this.upstreamDone = true;
            this.drain();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
            }
        }

        @Override
        public void cancel() {
            if (this.downstreamCancelled.compareAndSet(false, true)) {
                if (this.windowCount.decrementAndGet() == 0L) {
                    this.upstream.cancel();
                    this.startSubscriber.cancel();
                    this.resources.dispose();
                    this.error.tryTerminateAndReport();
                    this.upstreamCanceled = true;
                    this.drain();
                } else {
                    this.startSubscriber.cancel();
                }
            }
        }

        @Override
        public void run() {
            if (this.windowCount.decrementAndGet() == 0L) {
                this.upstream.cancel();
                this.startSubscriber.cancel();
                this.resources.dispose();
                this.error.tryTerminateAndReport();
                this.upstreamCanceled = true;
                this.drain();
            }
        }

        void open(B startValue) {
            this.queue.offer(new b<B>(startValue));
            this.drain();
        }

        void openError(Throwable t2) {
            this.upstream.cancel();
            this.resources.dispose();
            if (this.error.tryAddThrowableOrReport(t2)) {
                this.upstreamDone = true;
                this.drain();
            }
        }

        void openComplete() {
            this.openDone = true;
            this.drain();
        }

        void close(a<T, V> what) {
            this.queue.offer(what);
            this.drain();
        }

        void closeError(Throwable t2) {
            this.upstream.cancel();
            this.startSubscriber.cancel();
            this.resources.dispose();
            if (this.error.tryAddThrowableOrReport(t2)) {
                this.upstreamDone = true;
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            d downstream = this.downstream;
            f<Object> queue = this.queue;
            List<UnicastProcessor<T>> windows = this.windows;
            block2: while (true) {
                if (this.upstreamCanceled) {
                    queue.clear();
                    windows.clear();
                } else {
                    boolean isEmpty;
                    boolean isDone = this.upstreamDone;
                    Object o2 = queue.poll();
                    boolean bl2 = isEmpty = o2 == null;
                    if (isDone && (isEmpty || this.error.get() != null)) {
                        this.terminateDownstream(downstream);
                        this.upstreamCanceled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        if (o2 instanceof b) {
                            if (this.downstreamCancelled.get()) continue;
                            long emitted = this.emitted;
                            if (this.requested.get() != emitted) {
                                c<V> endSource;
                                this.emitted = ++emitted;
                                Object startItem = ((b)o2).abr;
                                try {
                                    endSource = Objects.requireNonNull(this.closingIndicator.apply(startItem), "The closingIndicator returned a null Publisher");
                                }
                                catch (Throwable ex) {
                                    io.reactivex.rxjava3.exceptions.a.k(ex);
                                    this.upstream.cancel();
                                    this.startSubscriber.cancel();
                                    this.resources.dispose();
                                    io.reactivex.rxjava3.exceptions.a.k(ex);
                                    this.error.tryAddThrowableOrReport(ex);
                                    this.upstreamDone = true;
                                    continue;
                                }
                                this.windowCount.getAndIncrement();
                                UnicastProcessor newWindow = UnicastProcessor.a(this.bufferSize, this);
                                a endSubscriber = new a(this, newWindow);
                                downstream.onNext(endSubscriber);
                                if (endSubscriber.tryAbandon()) {
                                    newWindow.onComplete();
                                    continue;
                                }
                                windows.add(newWindow);
                                this.resources.a((io.reactivex.rxjava3.disposables.b)endSubscriber);
                                endSource.subscribe(endSubscriber);
                                continue;
                            }
                            this.upstream.cancel();
                            this.startSubscriber.cancel();
                            this.resources.dispose();
                            this.error.tryAddThrowableOrReport(FlowableWindowTimed.ae(emitted));
                            this.upstreamDone = true;
                            continue;
                        }
                        if (o2 instanceof a) {
                            UnicastProcessor w2 = ((a)o2).abo;
                            windows.remove(w2);
                            this.resources.c((io.reactivex.rxjava3.disposables.b)o2);
                            w2.onComplete();
                            continue;
                        }
                        Object item = o2;
                        Iterator<UnicastProcessor<T>> iterator = windows.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            UnicastProcessor<Object> w3 = iterator.next();
                            w3.onNext(item);
                        }
                    }
                    if (this.openDone && windows.size() == 0) {
                        this.upstream.cancel();
                        this.startSubscriber.cancel();
                        this.resources.dispose();
                        this.terminateDownstream(downstream);
                        this.upstreamCanceled = true;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void terminateDownstream(d<?> downstream) {
            Throwable ex = this.error.terminate();
            if (ex == null) {
                for (UnicastProcessor<T> w2 : this.windows) {
                    w2.onComplete();
                }
                downstream.onComplete();
            } else if (ex != ExceptionHelper.azB) {
                for (UnicastProcessor<T> w3 : this.windows) {
                    w3.onError(ex);
                }
                downstream.onError(ex);
            }
        }

        static final class a<T, V>
        extends j<T>
        implements o<V>,
        io.reactivex.rxjava3.disposables.b {
            final WindowBoundaryMainSubscriber<T, ?, V> abn;
            final UnicastProcessor<T> abo;
            final AtomicReference<e> abp;
            final AtomicBoolean abq;

            a(WindowBoundaryMainSubscriber<T, ?, V> parent, UnicastProcessor<T> window) {
                this.abn = parent;
                this.abo = window;
                this.abp = new AtomicReference();
                this.abq = new AtomicBoolean();
            }

            @Override
            public void onSubscribe(e s2) {
                if (SubscriptionHelper.setOnce(this.abp, s2)) {
                    s2.request(Long.MAX_VALUE);
                }
            }

            @Override
            public void onNext(V t2) {
                if (SubscriptionHelper.cancel(this.abp)) {
                    this.abn.close(this);
                }
            }

            @Override
            public void onError(Throwable t2) {
                if (this.isDisposed()) {
                    io.reactivex.rxjava3.d.a.onError(t2);
                } else {
                    this.abn.closeError(t2);
                }
            }

            @Override
            public void onComplete() {
                this.abn.close(this);
            }

            @Override
            public void dispose() {
                SubscriptionHelper.cancel(this.abp);
            }

            @Override
            public boolean isDisposed() {
                return this.abp.get() == SubscriptionHelper.CANCELLED;
            }

            @Override
            protected void d(d<? super T> s2) {
                this.abo.subscribe(s2);
                this.abq.set(true);
            }

            boolean tryAbandon() {
                return !this.abq.get() && this.abq.compareAndSet(false, true);
            }
        }

        static final class WindowStartSubscriber<B>
        extends AtomicReference<e>
        implements o<B> {
            private static final long serialVersionUID = -3326496781427702834L;
            final WindowBoundaryMainSubscriber<?, B, ?> parent;

            WindowStartSubscriber(WindowBoundaryMainSubscriber<?, B, ?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(e s2) {
                if (SubscriptionHelper.setOnce(this, s2)) {
                    s2.request(Long.MAX_VALUE);
                }
            }

            @Override
            public void onNext(B t2) {
                this.parent.open(t2);
            }

            @Override
            public void onError(Throwable t2) {
                this.parent.openError(t2);
            }

            @Override
            public void onComplete() {
                this.parent.openComplete();
            }

            void cancel() {
                SubscriptionHelper.cancel(this);
            }
        }

        static final class b<B> {
            final B abr;

            b(B item) {
                this.abr = item;
            }
        }
    }
}

