/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.operators.flowable.a;
import io.reactivex.rxjava3.internal.operators.flowable.bn;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.operators.f;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.a.d;
import org.a.e;

public final class FlowableWindowTimed<T>
extends a<T, j<T>> {
    final long abu;
    final long abv;
    final TimeUnit abw;
    final ah abx;
    final long aby;
    final int abz;
    final boolean abA;

    public FlowableWindowTimed(j<T> source, long timespan, long timeskip, TimeUnit unit, ah scheduler, long maxSize, int bufferSize, boolean restartTimerOnMaxSize) {
        super(source);
        this.abu = timespan;
        this.abv = timeskip;
        this.abw = unit;
        this.abx = scheduler;
        this.aby = maxSize;
        this.abz = bufferSize;
        this.abA = restartTimerOnMaxSize;
    }

    @Override
    protected void d(d<? super j<T>> downstream) {
        if (this.abu == this.abv) {
            if (this.aby == Long.MAX_VALUE) {
                this.QR.a(new WindowExactUnboundedSubscriber(downstream, this.abu, this.abw, this.abx, this.abz));
                return;
            }
            this.QR.a(new WindowExactBoundedSubscriber(downstream, this.abu, this.abw, this.abx, this.abz, this.aby, this.abA));
            return;
        }
        this.QR.a(new WindowSkipSubscriber(downstream, this.abu, this.abv, this.abw, this.abx.oS(), this.abz));
    }

    static MissingBackpressureException ae(long index) {
        return new MissingBackpressureException("Unable to emit the next window (#" + index + ") due to lack of requests. Please make sure the downstream is ready to consume windows.");
    }

    static final class WindowSkipSubscriber<T>
    extends AbstractWindowSubscriber<T>
    implements Runnable {
        private static final long serialVersionUID = -7852870764194095894L;
        final long timeskip;
        final ah.c worker;
        final List<UnicastProcessor<T>> windows;
        static final Object WINDOW_OPEN = new Object();
        static final Object WINDOW_CLOSE = new Object();

        WindowSkipSubscriber(d<? super j<T>> actual, long timespan, long timeskip, TimeUnit unit, ah.c worker, int bufferSize) {
            super(actual, timespan, unit, bufferSize);
            this.timeskip = timeskip;
            this.worker = worker;
            this.windows = new LinkedList<UnicastProcessor<T>>();
        }

        @Override
        void createFirstWindow() {
            if (!this.downstreamCancelled.get()) {
                if (this.requested.get() != 0L) {
                    this.emitted = 1L;
                    this.windowCount.getAndIncrement();
                    UnicastProcessor window = UnicastProcessor.a(this.bufferSize, this);
                    this.windows.add(window);
                    bn intercept = new bn(window);
                    this.downstream.onNext(intercept);
                    this.worker.b(new a(this, false), this.timespan, this.unit);
                    this.worker.b(new a(this, true), this.timeskip, this.timeskip, this.unit);
                    if (intercept.tryAbandon()) {
                        window.onComplete();
                        this.windows.remove(window);
                    }
                    this.upstream.request(Long.MAX_VALUE);
                } else {
                    this.upstream.cancel();
                    this.downstream.onError(FlowableWindowTimed.ae(this.emitted));
                    this.cleanupResources();
                    this.upstreamCancelled = true;
                }
            }
        }

        @Override
        void cleanupResources() {
            this.worker.dispose();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            f queue = this.queue;
            d downstream = this.downstream;
            List<UnicastProcessor<T>> windows = this.windows;
            block0: while (true) {
                if (this.upstreamCancelled) {
                    queue.clear();
                    windows.clear();
                } else {
                    boolean isEmpty;
                    boolean isDone = this.done;
                    Object o2 = queue.poll();
                    boolean bl2 = isEmpty = o2 == null;
                    if (isDone && isEmpty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            for (UnicastProcessor window : windows) {
                                window.onError(ex);
                            }
                            downstream.onError(ex);
                        } else {
                            for (UnicastProcessor window : windows) {
                                window.onComplete();
                            }
                            downstream.onComplete();
                        }
                        this.cleanupResources();
                        this.upstreamCancelled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        UnicastProcessor window;
                        if (o2 == WINDOW_OPEN) {
                            if (this.downstreamCancelled.get()) continue;
                            long emitted = this.emitted;
                            if (this.requested.get() != emitted) {
                                this.emitted = ++emitted;
                                this.windowCount.getAndIncrement();
                                window = UnicastProcessor.a(this.bufferSize, this);
                                windows.add(window);
                                bn<T> intercept = new bn<T>(window);
                                downstream.onNext(intercept);
                                this.worker.b(new a(this, false), this.timespan, this.unit);
                                if (!intercept.tryAbandon()) continue;
                                window.onComplete();
                                continue;
                            }
                            this.upstream.cancel();
                            MissingBackpressureException ex = FlowableWindowTimed.ae(emitted);
                            for (UnicastProcessor<T> window2 : windows) {
                                window2.onError(ex);
                            }
                            downstream.onError(ex);
                            this.cleanupResources();
                            this.upstreamCancelled = true;
                            continue;
                        }
                        if (o2 == WINDOW_CLOSE) {
                            if (windows.isEmpty()) continue;
                            windows.remove(0).onComplete();
                            continue;
                        }
                        Object item = o2;
                        Iterator<UnicastProcessor<T>> iterator = windows.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block0;
                            window = iterator.next();
                            window.onNext(item);
                        }
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void run() {
            this.windowDone();
        }

        void boundary(boolean isOpen) {
            this.queue.offer(isOpen ? WINDOW_OPEN : WINDOW_CLOSE);
            this.drain();
        }

        static final class a
        implements Runnable {
            final WindowSkipSubscriber<?> abE;
            final boolean abF;

            a(WindowSkipSubscriber<?> parent, boolean isOpen) {
                this.abE = parent;
                this.abF = isOpen;
            }

            @Override
            public void run() {
                this.abE.boundary(this.abF);
            }
        }
    }

    static final class WindowExactBoundedSubscriber<T>
    extends AbstractWindowSubscriber<T>
    implements Runnable {
        private static final long serialVersionUID = -6130475889925953722L;
        final ah scheduler;
        final boolean restartTimerOnMaxSize;
        final long maxSize;
        final ah.c worker;
        long count;
        UnicastProcessor<T> window;
        final SequentialDisposable timer;

        WindowExactBoundedSubscriber(d<? super j<T>> actual, long timespan, TimeUnit unit, ah scheduler, int bufferSize, long maxSize, boolean restartTimerOnMaxSize) {
            super(actual, timespan, unit, bufferSize);
            this.scheduler = scheduler;
            this.maxSize = maxSize;
            this.restartTimerOnMaxSize = restartTimerOnMaxSize;
            this.worker = restartTimerOnMaxSize ? scheduler.oS() : null;
            this.timer = new SequentialDisposable();
        }

        @Override
        void createFirstWindow() {
            if (!this.downstreamCancelled.get()) {
                if (this.requested.get() != 0L) {
                    this.emitted = 1L;
                    this.windowCount.getAndIncrement();
                    this.window = UnicastProcessor.a(this.bufferSize, this);
                    bn<T> intercept = new bn<T>(this.window);
                    this.downstream.onNext(intercept);
                    a boundaryTask = new a(this, 1L);
                    if (this.restartTimerOnMaxSize) {
                        this.timer.replace(this.worker.b(boundaryTask, this.timespan, this.timespan, this.unit));
                    } else {
                        this.timer.replace(this.scheduler.a(boundaryTask, this.timespan, this.timespan, this.unit));
                    }
                    if (intercept.tryAbandon()) {
                        this.window.onComplete();
                    }
                    this.upstream.request(Long.MAX_VALUE);
                } else {
                    this.upstream.cancel();
                    this.downstream.onError(FlowableWindowTimed.ae(this.emitted));
                    this.cleanupResources();
                    this.upstreamCancelled = true;
                }
            }
        }

        @Override
        public void run() {
            this.windowDone();
        }

        @Override
        void cleanupResources() {
            this.timer.dispose();
            ah.c w2 = this.worker;
            if (w2 != null) {
                w2.dispose();
            }
        }

        void boundary(a sender) {
            this.queue.offer(sender);
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            f queue = this.queue;
            d downstream = this.downstream;
            UnicastProcessor window = this.window;
            while (true) {
                if (this.upstreamCancelled) {
                    queue.clear();
                    window = null;
                    this.window = null;
                } else {
                    boolean isEmpty;
                    boolean isDone = this.done;
                    Object o2 = queue.poll();
                    boolean bl2 = isEmpty = o2 == null;
                    if (isDone && isEmpty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            if (window != null) {
                                window.onError(ex);
                            }
                            downstream.onError(ex);
                        } else {
                            if (window != null) {
                                window.onComplete();
                            }
                            downstream.onComplete();
                        }
                        this.cleanupResources();
                        this.upstreamCancelled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        if (o2 instanceof a) {
                            a boundary = (a)o2;
                            if (boundary.abC != this.emitted && this.restartTimerOnMaxSize) continue;
                            this.count = 0L;
                            window = this.createNewWindow(window);
                            continue;
                        }
                        if (window == null) continue;
                        Object item = o2;
                        window.onNext(item);
                        long count = this.count + 1L;
                        if (count == this.maxSize) {
                            this.count = 0L;
                            window = this.createNewWindow(window);
                            continue;
                        }
                        this.count = count;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        UnicastProcessor<T> createNewWindow(UnicastProcessor<T> window) {
            if (window != null) {
                window.onComplete();
                window = null;
            }
            if (this.downstreamCancelled.get()) {
                this.cleanupResources();
            } else {
                long emitted = this.emitted;
                if (this.requested.get() == emitted) {
                    this.upstream.cancel();
                    this.cleanupResources();
                    this.upstreamCancelled = true;
                    this.downstream.onError(FlowableWindowTimed.ae(emitted));
                } else {
                    this.emitted = ++emitted;
                    this.windowCount.getAndIncrement();
                    window = UnicastProcessor.a(this.bufferSize, this);
                    this.window = window;
                    bn<T> intercept = new bn<T>(window);
                    this.downstream.onNext(intercept);
                    if (this.restartTimerOnMaxSize) {
                        this.timer.update(this.worker.b(new a(this, emitted), this.timespan, this.timespan, this.unit));
                    }
                    if (intercept.tryAbandon()) {
                        window.onComplete();
                    }
                }
            }
            return window;
        }

        static final class a
        implements Runnable {
            final WindowExactBoundedSubscriber<?> abB;
            final long abC;

            a(WindowExactBoundedSubscriber<?> parent, long index) {
                this.abB = parent;
                this.abC = index;
            }

            @Override
            public void run() {
                this.abB.boundary(this);
            }
        }
    }

    static final class WindowExactUnboundedSubscriber<T>
    extends AbstractWindowSubscriber<T>
    implements Runnable {
        private static final long serialVersionUID = 1155822639622580836L;
        final ah scheduler;
        UnicastProcessor<T> window;
        final SequentialDisposable timer;
        static final Object NEXT_WINDOW = new Object();
        final Runnable windowRunnable;

        WindowExactUnboundedSubscriber(d<? super j<T>> actual, long timespan, TimeUnit unit, ah scheduler, int bufferSize) {
            super(actual, timespan, unit, bufferSize);
            this.scheduler = scheduler;
            this.timer = new SequentialDisposable();
            this.windowRunnable = new a();
        }

        @Override
        void createFirstWindow() {
            if (!this.downstreamCancelled.get()) {
                if (this.requested.get() != 0L) {
                    this.windowCount.getAndIncrement();
                    this.window = UnicastProcessor.a(this.bufferSize, this.windowRunnable);
                    this.emitted = 1L;
                    bn<T> intercept = new bn<T>(this.window);
                    this.downstream.onNext(intercept);
                    this.timer.replace(this.scheduler.a(this, this.timespan, this.timespan, this.unit));
                    if (intercept.tryAbandon()) {
                        this.window.onComplete();
                    }
                    this.upstream.request(Long.MAX_VALUE);
                } else {
                    this.upstream.cancel();
                    this.downstream.onError(FlowableWindowTimed.ae(this.emitted));
                    this.cleanupResources();
                    this.upstreamCancelled = true;
                }
            }
        }

        @Override
        public void run() {
            this.queue.offer(NEXT_WINDOW);
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            f queue = this.queue;
            d downstream = this.downstream;
            UnicastProcessor window = this.window;
            int missed = 1;
            while (true) {
                if (this.upstreamCancelled) {
                    queue.clear();
                    window = null;
                    this.window = null;
                } else {
                    boolean isEmpty;
                    boolean isDone = this.done;
                    Object o2 = queue.poll();
                    boolean bl2 = isEmpty = o2 == null;
                    if (isDone && isEmpty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            if (window != null) {
                                window.onError(ex);
                            }
                            downstream.onError(ex);
                        } else {
                            if (window != null) {
                                window.onComplete();
                            }
                            downstream.onComplete();
                        }
                        this.cleanupResources();
                        this.upstreamCancelled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        if (o2 == NEXT_WINDOW) {
                            if (window != null) {
                                window.onComplete();
                                window = null;
                                this.window = null;
                            }
                            if (this.downstreamCancelled.get()) {
                                this.timer.dispose();
                                continue;
                            }
                            if (this.requested.get() == this.emitted) {
                                this.upstream.cancel();
                                this.cleanupResources();
                                this.upstreamCancelled = true;
                                downstream.onError(FlowableWindowTimed.ae(this.emitted));
                                continue;
                            }
                            ++this.emitted;
                            this.windowCount.getAndIncrement();
                            window = UnicastProcessor.a(this.bufferSize, this.windowRunnable);
                            this.window = window;
                            bn<T> intercept = new bn<T>(window);
                            downstream.onNext(intercept);
                            if (!intercept.tryAbandon()) continue;
                            window.onComplete();
                            continue;
                        }
                        if (window == null) continue;
                        Object item = o2;
                        window.onNext(item);
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        void cleanupResources() {
            this.timer.dispose();
        }

        final class a
        implements Runnable {
            a() {
            }

            @Override
            public void run() {
                WindowExactUnboundedSubscriber.this.windowDone();
            }
        }
    }

    static abstract class AbstractWindowSubscriber<T>
    extends AtomicInteger
    implements o<T>,
    e {
        private static final long serialVersionUID = 5724293814035355511L;
        final d<? super j<T>> downstream;
        final f<Object> queue;
        final long timespan;
        final TimeUnit unit;
        final int bufferSize;
        final AtomicLong requested;
        long emitted;
        volatile boolean done;
        Throwable error;
        e upstream;
        final AtomicBoolean downstreamCancelled;
        volatile boolean upstreamCancelled;
        final AtomicInteger windowCount;

        AbstractWindowSubscriber(d<? super j<T>> downstream, long timespan, TimeUnit unit, int bufferSize) {
            this.downstream = downstream;
            this.queue = new MpscLinkedQueue<Object>();
            this.timespan = timespan;
            this.unit = unit;
            this.bufferSize = bufferSize;
            this.requested = new AtomicLong();
            this.downstreamCancelled = new AtomicBoolean();
            this.windowCount = new AtomicInteger(1);
        }

        @Override
        public final void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                this.createFirstWindow();
            }
        }

        abstract void createFirstWindow();

        @Override
        public final void onNext(T t2) {
            this.queue.offer(t2);
            this.drain();
        }

        @Override
        public final void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            this.drain();
        }

        @Override
        public final void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public final void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
            }
        }

        @Override
        public final void cancel() {
            if (this.downstreamCancelled.compareAndSet(false, true)) {
                this.windowDone();
            }
        }

        final void windowDone() {
            if (this.windowCount.decrementAndGet() == 0) {
                this.cleanupResources();
                this.upstream.cancel();
                this.upstreamCancelled = true;
                this.drain();
            }
        }

        abstract void cleanupResources();

        abstract void drain();
    }
}

