/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.g;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.d;
import org.a.e;

public final class FlowableZip<T, R>
extends j<R> {
    final c<? extends T>[] abO;
    final Iterable<? extends c<? extends T>> abP;
    final h<? super Object[], ? extends R> abQ;
    final int abR;
    final boolean abS;

    public FlowableZip(c<? extends T>[] sources, Iterable<? extends c<? extends T>> sourcesIterable, h<? super Object[], ? extends R> zipper, int bufferSize, boolean delayError) {
        this.abO = sources;
        this.abP = sourcesIterable;
        this.abQ = zipper;
        this.abR = bufferSize;
        this.abS = delayError;
    }

    @Override
    public void d(d<? super R> s2) {
        c<? extends T>[] sources = this.abO;
        int count = 0;
        if (sources == null) {
            sources = new c[8];
            for (c<? extends T> c2 : this.abP) {
                if (count == sources.length) {
                    c[] b2 = new c[count + (count >> 2)];
                    System.arraycopy(sources, 0, b2, 0, count);
                    sources = b2;
                }
                sources[count++] = c2;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptySubscription.complete(s2);
            return;
        }
        ZipCoordinator<? extends T, R> coordinator = new ZipCoordinator<T, R>(s2, this.abQ, count, this.abR, this.abS);
        s2.onSubscribe(coordinator);
        coordinator.subscribe(sources, count);
    }

    static final class ZipSubscriber<T, R>
    extends AtomicReference<e>
    implements o<T>,
    e {
        private static final long serialVersionUID = -4627193790118206028L;
        final ZipCoordinator<T, R> parent;
        final int prefetch;
        final int limit;
        g<T> queue;
        long produced;
        volatile boolean done;
        int sourceMode;

        ZipSubscriber(ZipCoordinator<T, R> parent, int prefetch) {
            this.parent = parent;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.setOnce(this, s2)) {
                if (s2 instanceof io.reactivex.rxjava3.operators.d) {
                    io.reactivex.rxjava3.operators.d f2 = (io.reactivex.rxjava3.operators.d)s2;
                    int m2 = f2.requestFusion(7);
                    if (m2 == 1) {
                        this.sourceMode = m2;
                        this.queue = f2;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m2 == 2) {
                        this.sourceMode = m2;
                        this.queue = f2;
                        s2.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                s2.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.sourceMode != 2) {
                this.queue.offer(t2);
            }
            this.parent.drain();
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.error(this, t2);
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this);
        }

        @Override
        public void request(long n2) {
            if (this.sourceMode != 1) {
                long p2 = this.produced + n2;
                if (p2 >= (long)this.limit) {
                    this.produced = 0L;
                    ((e)this.get()).request(p2);
                } else {
                    this.produced = p2;
                }
            }
        }
    }

    static final class ZipCoordinator<T, R>
    extends AtomicInteger
    implements e {
        private static final long serialVersionUID = -2434867452883857743L;
        final d<? super R> downstream;
        final ZipSubscriber<T, R>[] subscribers;
        final h<? super Object[], ? extends R> zipper;
        final AtomicLong requested;
        final AtomicThrowable errors;
        final boolean delayErrors;
        volatile boolean cancelled;
        final Object[] current;

        ZipCoordinator(d<? super R> actual, h<? super Object[], ? extends R> zipper, int n2, int prefetch, boolean delayErrors) {
            this.downstream = actual;
            this.zipper = zipper;
            this.delayErrors = delayErrors;
            ZipSubscriber[] a2 = new ZipSubscriber[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                a2[i2] = new ZipSubscriber(this, prefetch);
            }
            this.current = new Object[n2];
            this.subscribers = a2;
            this.requested = new AtomicLong();
            this.errors = new AtomicThrowable();
        }

        void subscribe(c<? extends T>[] sources, int n2) {
            ZipSubscriber<T, R>[] a2 = this.subscribers;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.cancelled || !this.delayErrors && this.errors.get() != null) {
                    return;
                }
                sources[i2].subscribe(a2[i2]);
            }
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
            }
        }

        void error(ZipSubscriber<T, R> inner, Throwable e2) {
            if (this.errors.tryAddThrowableOrReport(e2)) {
                inner.done = true;
                this.drain();
            }
        }

        void cancelAll() {
            for (ZipSubscriber<T, R> s2 : this.subscribers) {
                s2.cancel();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            d<R> a2 = this.downstream;
            ZipSubscriber<T, R>[] qs = this.subscribers;
            int n2 = qs.length;
            Object[] values = this.current;
            int missed = 1;
            do {
                long e2;
                long r2 = this.requested.get();
                for (e2 = 0L; r2 != e2; ++e2) {
                    R v2;
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.delayErrors && this.errors.get() != null) {
                        this.cancelAll();
                        this.errors.tryTerminateConsumer(a2);
                        return;
                    }
                    boolean empty = false;
                    for (int j2 = 0; j2 < n2; ++j2) {
                        boolean sourceEmpty;
                        ZipSubscriber<T, R> inner = qs[j2];
                        if (values[j2] != null) continue;
                        boolean d2 = inner.done;
                        g q2 = inner.queue;
                        Object v3 = null;
                        try {
                            v3 = q2 != null ? q2.poll() : null;
                        }
                        catch (Throwable ex) {
                            a.k(ex);
                            this.errors.tryAddThrowableOrReport(ex);
                            if (!this.delayErrors) {
                                this.cancelAll();
                                this.errors.tryTerminateConsumer(a2);
                                return;
                            }
                            d2 = true;
                        }
                        boolean bl2 = sourceEmpty = v3 == null;
                        if (d2 && sourceEmpty) {
                            this.cancelAll();
                            this.errors.tryTerminateConsumer(a2);
                            return;
                        }
                        if (!sourceEmpty) {
                            values[j2] = v3;
                            continue;
                        }
                        empty = true;
                    }
                    if (empty) break;
                    try {
                        v2 = Objects.requireNonNull(this.zipper.apply((Object[])values.clone()), "The zipper returned a null value");
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        this.cancelAll();
                        this.errors.tryAddThrowableOrReport(ex);
                        this.errors.tryTerminateConsumer(a2);
                        return;
                    }
                    a2.onNext(v2);
                    Arrays.fill(values, null);
                }
                if (r2 == e2) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.delayErrors && this.errors.get() != null) {
                        this.cancelAll();
                        this.errors.tryTerminateConsumer(a2);
                        return;
                    }
                    for (int j3 = 0; j3 < n2; ++j3) {
                        boolean empty;
                        ZipSubscriber<T, R> inner = qs[j3];
                        if (values[j3] != null) continue;
                        boolean d3 = inner.done;
                        g q3 = inner.queue;
                        Object v4 = null;
                        try {
                            v4 = q3 != null ? q3.poll() : null;
                        }
                        catch (Throwable ex) {
                            a.k(ex);
                            this.errors.tryAddThrowableOrReport(ex);
                            if (!this.delayErrors) {
                                this.cancelAll();
                                this.errors.tryTerminateConsumer(a2);
                                return;
                            }
                            d3 = true;
                        }
                        boolean bl3 = empty = v4 == null;
                        if (d3 && empty) {
                            this.cancelAll();
                            this.errors.tryTerminateConsumer(a2);
                            return;
                        }
                        if (empty) continue;
                        values[j3] = v4;
                    }
                }
                if (e2 == 0L) continue;
                for (ZipSubscriber<T, R> inner : qs) {
                    inner.request(e2);
                }
                if (r2 == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e2);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

