/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class MaybeConcatArrayDelayError<T>
extends j<T> {
    final w<? extends T>[] ack;

    public MaybeConcatArrayDelayError(w<? extends T>[] sources) {
        this.ack = sources;
    }

    @Override
    protected void d(d<? super T> s2) {
        ConcatMaybeObserver<T> parent = new ConcatMaybeObserver<T>(s2, this.ack);
        s2.onSubscribe(parent);
        parent.drain();
    }

    static final class ConcatMaybeObserver<T>
    extends AtomicInteger
    implements t<T>,
    e {
        private static final long serialVersionUID = 3520831347801429610L;
        final d<? super T> downstream;
        final AtomicLong requested;
        final AtomicReference<Object> current;
        final SequentialDisposable disposables;
        final w<? extends T>[] sources;
        final AtomicThrowable errors;
        int index;
        long produced;

        ConcatMaybeObserver(d<? super T> actual, w<? extends T>[] sources) {
            this.downstream = actual;
            this.sources = sources;
            this.requested = new AtomicLong();
            this.disposables = new SequentialDisposable();
            this.current = new AtomicReference<NotificationLite>(NotificationLite.COMPLETE);
            this.errors = new AtomicThrowable();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.disposables.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public void onSubscribe(b d2) {
            this.disposables.replace(d2);
        }

        @Override
        public void onSuccess(T value) {
            this.current.lazySet(value);
            this.drain();
        }

        @Override
        public void onError(Throwable e2) {
            this.current.lazySet((Object)NotificationLite.COMPLETE);
            if (this.errors.tryAddThrowableOrReport(e2)) {
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.current.lazySet((Object)NotificationLite.COMPLETE);
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            AtomicReference<Object> c2 = this.current;
            d<Object> a2 = this.downstream;
            SequentialDisposable cancelled = this.disposables;
            do {
                boolean goNextSource;
                if (cancelled.isDisposed()) {
                    c2.lazySet(null);
                    return;
                }
                Object o2 = c2.get();
                if (o2 == null) continue;
                if (o2 != NotificationLite.COMPLETE) {
                    long p2 = this.produced;
                    if (p2 != this.requested.get()) {
                        this.produced = p2 + 1L;
                        c2.lazySet(null);
                        goNextSource = true;
                        a2.onNext(o2);
                    } else {
                        goNextSource = false;
                    }
                } else {
                    goNextSource = true;
                    c2.lazySet(null);
                }
                if (!goNextSource || cancelled.isDisposed()) continue;
                int i2 = this.index;
                if (i2 == this.sources.length) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                this.index = i2 + 1;
                this.sources[i2].c(this);
            } while (this.decrementAndGet() != 0);
        }
    }
}

