/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class MaybeConcatIterable<T>
extends j<T> {
    final Iterable<? extends w<? extends T>> acl;

    public MaybeConcatIterable(Iterable<? extends w<? extends T>> sources) {
        this.acl = sources;
    }

    @Override
    protected void d(d<? super T> s2) {
        Iterator<? extends w<? extends T>> it;
        try {
            it = Objects.requireNonNull(this.acl.iterator(), "The sources Iterable returned a null Iterator");
        }
        catch (Throwable ex) {
            a.k(ex);
            EmptySubscription.error(ex, s2);
            return;
        }
        ConcatMaybeObserver<T> parent = new ConcatMaybeObserver<T>(s2, it);
        s2.onSubscribe(parent);
        parent.drain();
    }

    static final class ConcatMaybeObserver<T>
    extends AtomicInteger
    implements t<T>,
    e {
        private static final long serialVersionUID = 3520831347801429610L;
        final d<? super T> downstream;
        final AtomicLong requested;
        final AtomicReference<Object> current;
        final SequentialDisposable disposables;
        final Iterator<? extends w<? extends T>> sources;
        long produced;

        ConcatMaybeObserver(d<? super T> actual, Iterator<? extends w<? extends T>> sources) {
            this.downstream = actual;
            this.sources = sources;
            this.requested = new AtomicLong();
            this.disposables = new SequentialDisposable();
            this.current = new AtomicReference<NotificationLite>(NotificationLite.COMPLETE);
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.disposables.dispose();
        }

        @Override
        public void onSubscribe(b d2) {
            this.disposables.replace(d2);
        }

        @Override
        public void onSuccess(T value) {
            this.current.lazySet(value);
            this.drain();
        }

        @Override
        public void onError(Throwable e2) {
            this.downstream.onError(e2);
        }

        @Override
        public void onComplete() {
            this.current.lazySet((Object)NotificationLite.COMPLETE);
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            AtomicReference<Object> c2 = this.current;
            d<Object> a2 = this.downstream;
            SequentialDisposable cancelled = this.disposables;
            do {
                boolean b2;
                boolean goNextSource;
                if (cancelled.isDisposed()) {
                    c2.lazySet(null);
                    return;
                }
                Object o2 = c2.get();
                if (o2 == null) continue;
                if (o2 != NotificationLite.COMPLETE) {
                    long p2 = this.produced;
                    if (p2 != this.requested.get()) {
                        this.produced = p2 + 1L;
                        c2.lazySet(null);
                        goNextSource = true;
                        a2.onNext(o2);
                    } else {
                        goNextSource = false;
                    }
                } else {
                    goNextSource = true;
                    c2.lazySet(null);
                }
                if (!goNextSource || cancelled.isDisposed()) continue;
                try {
                    b2 = this.sources.hasNext();
                }
                catch (Throwable ex) {
                    a.k(ex);
                    a2.onError(ex);
                    return;
                }
                if (b2) {
                    w<T> source;
                    try {
                        source = Objects.requireNonNull(this.sources.next(), "The source Iterator returned a null MaybeSource");
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        a2.onError(ex);
                        return;
                    }
                    source.c(this);
                    continue;
                }
                a2.onComplete();
            } while (this.decrementAndGet() != 0);
        }
    }
}

