/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.b.d;
import io.reactivex.rxjava3.core.ai;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeEqualSingle<T>
extends ai<Boolean> {
    final w<? extends T> adc;
    final w<? extends T> add;
    final d<? super T, ? super T> ade;

    public MaybeEqualSingle(w<? extends T> source1, w<? extends T> source2, d<? super T, ? super T> isEqual) {
        this.adc = source1;
        this.add = source2;
        this.ade = isEqual;
    }

    @Override
    protected void d(al<? super Boolean> observer) {
        EqualCoordinator<? extends T> parent = new EqualCoordinator<T>(observer, this.ade);
        observer.onSubscribe(parent);
        parent.subscribe(this.adc, this.add);
    }

    static final class EqualObserver<T>
    extends AtomicReference<b>
    implements t<T> {
        private static final long serialVersionUID = -3031974433025990931L;
        final EqualCoordinator<T> parent;
        Object value;

        EqualObserver(EqualCoordinator<T> parent) {
            this.parent = parent;
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this, d2);
        }

        @Override
        public void onSuccess(T value) {
            this.value = value;
            this.parent.done();
        }

        @Override
        public void onError(Throwable e2) {
            this.parent.error(this, e2);
        }

        @Override
        public void onComplete() {
            this.parent.done();
        }
    }

    static final class EqualCoordinator<T>
    extends AtomicInteger
    implements b {
        final al<? super Boolean> downstream;
        final EqualObserver<T> observer1;
        final EqualObserver<T> observer2;
        final d<? super T, ? super T> isEqual;

        EqualCoordinator(al<? super Boolean> actual, d<? super T, ? super T> isEqual) {
            super(2);
            this.downstream = actual;
            this.isEqual = isEqual;
            this.observer1 = new EqualObserver(this);
            this.observer2 = new EqualObserver(this);
        }

        void subscribe(w<? extends T> source1, w<? extends T> source2) {
            source1.c(this.observer1);
            source2.c(this.observer2);
        }

        @Override
        public void dispose() {
            this.observer1.dispose();
            this.observer2.dispose();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.observer1.get());
        }

        void done() {
            if (this.decrementAndGet() == 0) {
                Object o1 = this.observer1.value;
                Object o2 = this.observer2.value;
                if (o1 != null && o2 != null) {
                    boolean b2;
                    try {
                        b2 = this.isEqual.d(o1, o2);
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        this.downstream.onError(ex);
                        return;
                    }
                    this.downstream.onSuccess((Boolean)b2);
                } else {
                    this.downstream.onSuccess((Boolean)(o1 == null && o2 == null ? 1 : 0));
                }
            }
        }

        void error(EqualObserver<T> sender, Throwable ex) {
            if (this.getAndSet(0) > 0) {
                if (sender == this.observer1) {
                    this.observer2.dispose();
                } else {
                    this.observer1.dispose();
                }
                this.downstream.onError(ex);
            } else {
                a.onError(ex);
            }
        }
    }
}

