/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.a.d;

public final class MaybeFlatMapIterableFlowable<T, R>
extends j<R> {
    final w<T> adu;
    final h<? super T, ? extends Iterable<? extends R>> adv;

    public MaybeFlatMapIterableFlowable(w<T> source, h<? super T, ? extends Iterable<? extends R>> mapper) {
        this.adu = source;
        this.adv = mapper;
    }

    @Override
    protected void d(d<? super R> s2) {
        this.adu.c(new FlatMapIterableObserver<T, R>(s2, this.adv));
    }

    static final class FlatMapIterableObserver<T, R>
    extends BasicIntQueueSubscription<R>
    implements t<T> {
        private static final long serialVersionUID = -8938804753851907758L;
        final d<? super R> downstream;
        final h<? super T, ? extends Iterable<? extends R>> mapper;
        final AtomicLong requested;
        b upstream;
        volatile Iterator<? extends R> it;
        volatile boolean cancelled;
        boolean outputFused;

        FlatMapIterableObserver(d<? super R> actual, h<? super T, ? extends Iterable<? extends R>> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            boolean has;
            Iterator<R> iterator;
            try {
                iterator = this.mapper.apply(value).iterator();
                has = iterator.hasNext();
            }
            catch (Throwable ex) {
                a.k(ex);
                this.downstream.onError(ex);
                return;
            }
            if (!has) {
                this.downstream.onComplete();
                return;
            }
            this.it = iterator;
            this.drain();
        }

        @Override
        public void onError(Throwable e2) {
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onError(e2);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.dispose();
            this.upstream = DisposableHelper.DISPOSED;
        }

        void fastPath(d<? super R> a2, Iterator<? extends R> iterator) {
            boolean b2;
            do {
                R v2;
                if (this.cancelled) {
                    return;
                }
                try {
                    v2 = iterator.next();
                }
                catch (Throwable ex) {
                    a.k(ex);
                    a2.onError(ex);
                    return;
                }
                a2.onNext(v2);
                if (this.cancelled) {
                    return;
                }
                try {
                    b2 = iterator.hasNext();
                }
                catch (Throwable ex) {
                    a.k(ex);
                    a2.onError(ex);
                    return;
                }
            } while (b2);
            a2.onComplete();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            d<R> a2 = this.downstream;
            Iterator<R> iterator = this.it;
            if (this.outputFused && iterator != null) {
                a2.onNext(null);
                a2.onComplete();
                return;
            }
            int missed = 1;
            while (true) {
                if (iterator != null) {
                    long e2;
                    long r2 = this.requested.get();
                    if (r2 == Long.MAX_VALUE) {
                        this.fastPath(a2, iterator);
                        return;
                    }
                    for (e2 = 0L; e2 != r2; ++e2) {
                        R v2;
                        if (this.cancelled) {
                            return;
                        }
                        try {
                            v2 = Objects.requireNonNull(iterator.next(), "The iterator returned a null value");
                        }
                        catch (Throwable ex) {
                            a.k(ex);
                            a2.onError(ex);
                            return;
                        }
                        a2.onNext(v2);
                        if (this.cancelled) {
                            return;
                        }
                        try {
                            boolean b2 = iterator.hasNext();
                            continue;
                        }
                        catch (Throwable ex) {
                            a.k(ex);
                            a2.onError(ex);
                            return;
                        }
                    }
                    if (e2 != 0L) {
                        io.reactivex.rxjava3.internal.util.b.c(this.requested, e2);
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
                if (iterator != null) continue;
                iterator = this.it;
            }
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        public void clear() {
            this.it = null;
        }

        @Override
        public boolean isEmpty() {
            return this.it == null;
        }

        @Override
        @f
        public R poll() {
            Iterator<R> iterator = this.it;
            if (iterator != null) {
                R v2 = Objects.requireNonNull(iterator.next(), "The iterator returned a null value");
                if (!iterator.hasNext()) {
                    this.it = null;
                }
                return v2;
            }
            return null;
        }
    }
}

