/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.maybe.a;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeFlatMapNotification<T, R>
extends a<T, R> {
    final h<? super T, ? extends w<? extends R>> adA;
    final h<? super Throwable, ? extends w<? extends R>> adB;
    final s<? extends w<? extends R>> adC;

    public MaybeFlatMapNotification(w<T> source, h<? super T, ? extends w<? extends R>> onSuccessMapper, h<? super Throwable, ? extends w<? extends R>> onErrorMapper, s<? extends w<? extends R>> onCompleteSupplier) {
        super(source);
        this.adA = onSuccessMapper;
        this.adB = onErrorMapper;
        this.adC = onCompleteSupplier;
    }

    @Override
    protected void d(t<? super R> observer) {
        this.abY.c(new FlatMapMaybeObserver<T, R>(observer, this.adA, this.adB, this.adC));
    }

    static final class FlatMapMaybeObserver<T, R>
    extends AtomicReference<b>
    implements t<T>,
    b {
        private static final long serialVersionUID = 4375739915521278546L;
        final t<? super R> downstream;
        final h<? super T, ? extends w<? extends R>> onSuccessMapper;
        final h<? super Throwable, ? extends w<? extends R>> onErrorMapper;
        final s<? extends w<? extends R>> onCompleteSupplier;
        b upstream;

        FlatMapMaybeObserver(t<? super R> actual, h<? super T, ? extends w<? extends R>> onSuccessMapper, h<? super Throwable, ? extends w<? extends R>> onErrorMapper, s<? extends w<? extends R>> onCompleteSupplier) {
            this.downstream = actual;
            this.onSuccessMapper = onSuccessMapper;
            this.onErrorMapper = onErrorMapper;
            this.onCompleteSupplier = onCompleteSupplier;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            w<R> source;
            try {
                source = Objects.requireNonNull(this.onSuccessMapper.apply(value), "The onSuccessMapper returned a null MaybeSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.downstream.onError(ex);
                return;
            }
            if (!this.isDisposed()) {
                source.c(new a());
            }
        }

        @Override
        public void onError(Throwable e2) {
            w<R> source;
            try {
                source = Objects.requireNonNull(this.onErrorMapper.apply(e2), "The onErrorMapper returned a null MaybeSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.downstream.onError(new CompositeException(e2, ex));
                return;
            }
            if (!this.isDisposed()) {
                source.c(new a());
            }
        }

        @Override
        public void onComplete() {
            w<R> source;
            try {
                source = Objects.requireNonNull(this.onCompleteSupplier.get(), "The onCompleteSupplier returned a null MaybeSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.downstream.onError(ex);
                return;
            }
            if (!this.isDisposed()) {
                source.c(new a());
            }
        }

        final class a
        implements t<R> {
            a() {
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(FlatMapMaybeObserver.this, d2);
            }

            @Override
            public void onSuccess(R value) {
                FlatMapMaybeObserver.this.downstream.onSuccess(value);
            }

            @Override
            public void onError(Throwable e2) {
                FlatMapMaybeObserver.this.downstream.onError(e2);
            }

            @Override
            public void onComplete() {
                FlatMapMaybeObserver.this.downstream.onComplete();
            }
        }
    }
}

