/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.core.q;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeFlatMapSingle<T, R>
extends q<R> {
    final w<T> adE;
    final h<? super T, ? extends ao<? extends R>> adF;

    public MaybeFlatMapSingle(w<T> source, h<? super T, ? extends ao<? extends R>> mapper) {
        this.adE = source;
        this.adF = mapper;
    }

    @Override
    protected void d(t<? super R> downstream) {
        this.adE.c(new FlatMapMaybeObserver<T, R>(downstream, this.adF));
    }

    static final class a<R>
    implements al<R> {
        final AtomicReference<b> adG;
        final t<? super R> adH;

        a(AtomicReference<b> parent, t<? super R> downstream) {
            this.adG = parent;
            this.adH = downstream;
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.replace(this.adG, d2);
        }

        @Override
        public void onSuccess(R value) {
            this.adH.onSuccess(value);
        }

        @Override
        public void onError(Throwable e2) {
            this.adH.onError(e2);
        }
    }

    static final class FlatMapMaybeObserver<T, R>
    extends AtomicReference<b>
    implements t<T>,
    b {
        private static final long serialVersionUID = 4827726964688405508L;
        final t<? super R> downstream;
        final h<? super T, ? extends ao<? extends R>> mapper;

        FlatMapMaybeObserver(t<? super R> actual, h<? super T, ? extends ao<? extends R>> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.setOnce(this, d2)) {
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            ao<R> ss;
            try {
                ss = Objects.requireNonNull(this.mapper.apply(value), "The mapper returned a null SingleSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.onError(ex);
                return;
            }
            if (!this.isDisposed()) {
                ss.c(new a<R>(this, this.downstream));
            }
        }

        @Override
        public void onError(Throwable e2) {
            this.downstream.onError(e2);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

