/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import io.reactivex.rxjava3.operators.g;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.a.d;

public final class MaybeMergeArray<T>
extends j<T> {
    final w<? extends T>[] aei;

    public MaybeMergeArray(w<? extends T>[] sources) {
        this.aei = sources;
    }

    @Override
    protected void d(d<? super T> s2) {
        w<? extends T>[] maybes = this.aei;
        int n2 = maybes.length;
        a queue = n2 <= MaybeMergeArray.mB() ? new MpscFillOnceSimpleQueue(n2) : new ClqSimpleQueue();
        MergeMaybeObserver<T> parent = new MergeMaybeObserver<T>(s2, n2, queue);
        s2.onSubscribe(parent);
        AtomicThrowable e2 = parent.errors;
        for (w<T> w2 : maybes) {
            if (parent.isCancelled() || e2.get() != null) {
                return;
            }
            w2.c(parent);
        }
    }

    static final class ClqSimpleQueue<T>
    extends ConcurrentLinkedQueue<T>
    implements a<T> {
        private static final long serialVersionUID = -4025173261791142821L;
        int consumerIndex;
        final AtomicInteger producerIndex = new AtomicInteger();

        ClqSimpleQueue() {
        }

        @Override
        public boolean offer(T v1, T v2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offer(T e2) {
            this.producerIndex.getAndIncrement();
            return super.offer(e2);
        }

        @Override
        @f
        public T poll() {
            Object v2 = super.poll();
            if (v2 != null) {
                ++this.consumerIndex;
            }
            return (T)v2;
        }

        @Override
        public int consumerIndex() {
            return this.consumerIndex;
        }

        @Override
        public int producerIndex() {
            return this.producerIndex.get();
        }

        @Override
        public void drop() {
            this.poll();
        }
    }

    static final class MpscFillOnceSimpleQueue<T>
    extends AtomicReferenceArray<T>
    implements a<T> {
        private static final long serialVersionUID = -7969063454040569579L;
        final AtomicInteger producerIndex = new AtomicInteger();
        int consumerIndex;

        MpscFillOnceSimpleQueue(int length) {
            super(length);
        }

        @Override
        public boolean offer(T value) {
            Objects.requireNonNull(value, "value is null");
            int idx = this.producerIndex.getAndIncrement();
            if (idx < this.length()) {
                this.lazySet(idx, value);
                return true;
            }
            return false;
        }

        @Override
        public boolean offer(T v1, T v2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @f
        public T poll() {
            int ci = this.consumerIndex;
            if (ci == this.length()) {
                return null;
            }
            AtomicInteger pi = this.producerIndex;
            do {
                Object v2;
                if ((v2 = this.get(ci)) == null) continue;
                this.consumerIndex = ci + 1;
                this.lazySet(ci, null);
                return (T)v2;
            } while (pi.get() != ci);
            return null;
        }

        @Override
        public T peek() {
            int ci = this.consumerIndex;
            if (ci == this.length()) {
                return null;
            }
            return (T)this.get(ci);
        }

        @Override
        public void drop() {
            int ci = this.consumerIndex;
            this.lazySet(ci, null);
            this.consumerIndex = ci + 1;
        }

        @Override
        public boolean isEmpty() {
            return this.consumerIndex == this.producerIndex();
        }

        @Override
        public void clear() {
            while (this.poll() != null && !this.isEmpty()) {
            }
        }

        @Override
        public int consumerIndex() {
            return this.consumerIndex;
        }

        @Override
        public int producerIndex() {
            return this.producerIndex.get();
        }
    }

    static interface a<T>
    extends g<T> {
        @Override
        @f
        public T poll();

        public T peek();

        public void drop();

        public int consumerIndex();

        public int producerIndex();
    }

    static final class MergeMaybeObserver<T>
    extends BasicIntQueueSubscription<T>
    implements t<T> {
        private static final long serialVersionUID = -660395290758764731L;
        final d<? super T> downstream;
        final io.reactivex.rxjava3.disposables.a set;
        final AtomicLong requested;
        final a<Object> queue;
        final AtomicThrowable errors;
        final int sourceCount;
        volatile boolean cancelled;
        boolean outputFused;
        long consumed;

        MergeMaybeObserver(d<? super T> actual, int sourceCount, a<Object> queue) {
            this.downstream = actual;
            this.sourceCount = sourceCount;
            this.set = new io.reactivex.rxjava3.disposables.a();
            this.requested = new AtomicLong();
            this.errors = new AtomicThrowable();
            this.queue = queue;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        @f
        public T poll() {
            Object o2;
            while ((o2 = this.queue.poll()) == NotificationLite.COMPLETE) {
            }
            return (T)o2;
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.set.dispose();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public void onSubscribe(b d2) {
            this.set.a(d2);
        }

        @Override
        public void onSuccess(T value) {
            this.queue.offer(value);
            this.drain();
        }

        @Override
        public void onError(Throwable e2) {
            if (this.errors.tryAddThrowableOrReport(e2)) {
                this.set.dispose();
                this.queue.offer((Object)NotificationLite.COMPLETE);
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.queue.offer((Object)NotificationLite.COMPLETE);
            this.drain();
        }

        boolean isCancelled() {
            return this.cancelled;
        }

        void drainNormal() {
            int missed = 1;
            d<Object> a2 = this.downstream;
            a<Object> q2 = this.queue;
            long e2 = this.consumed;
            do {
                Throwable ex;
                long r2 = this.requested.get();
                while (e2 != r2) {
                    if (this.cancelled) {
                        q2.clear();
                        return;
                    }
                    ex = (Throwable)this.errors.get();
                    if (ex != null) {
                        q2.clear();
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    if (q2.consumerIndex() == this.sourceCount) {
                        a2.onComplete();
                        return;
                    }
                    Object v2 = q2.poll();
                    if (v2 == null) break;
                    if (v2 == NotificationLite.COMPLETE) continue;
                    a2.onNext(v2);
                    ++e2;
                }
                if (e2 == r2) {
                    ex = (Throwable)this.errors.get();
                    if (ex != null) {
                        q2.clear();
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    while (q2.peek() == NotificationLite.COMPLETE) {
                        q2.drop();
                    }
                    if (q2.consumerIndex() == this.sourceCount) {
                        a2.onComplete();
                        return;
                    }
                }
                this.consumed = e2;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        void drainFused() {
            int missed = 1;
            d<T> a2 = this.downstream;
            a<Object> q2 = this.queue;
            do {
                boolean d2;
                if (this.cancelled) {
                    q2.clear();
                    return;
                }
                Throwable ex = (Throwable)this.errors.get();
                if (ex != null) {
                    q2.clear();
                    a2.onError(ex);
                    return;
                }
                boolean bl2 = d2 = q2.producerIndex() == this.sourceCount;
                if (!q2.isEmpty()) {
                    a2.onNext(null);
                }
                if (!d2) continue;
                a2.onComplete();
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            if (this.outputFused) {
                this.drainFused();
            } else {
                this.drainNormal();
            }
        }
    }
}

