/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.maybe.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.e;

public final class MaybeTimeoutPublisher<T, U>
extends a<T, T> {
    final c<U> aeZ;
    final w<? extends T> afa;

    public MaybeTimeoutPublisher(w<T> source, c<U> other, w<? extends T> fallback) {
        super(source);
        this.aeZ = other;
        this.afa = fallback;
    }

    @Override
    protected void d(t<? super T> observer) {
        TimeoutMainMaybeObserver parent = new TimeoutMainMaybeObserver(observer, this.afa);
        observer.onSubscribe(parent);
        this.aeZ.subscribe(parent.other);
        this.abY.c(parent);
    }

    static final class TimeoutFallbackMaybeObserver<T>
    extends AtomicReference<b>
    implements t<T> {
        private static final long serialVersionUID = 8663801314800248617L;
        final t<? super T> downstream;

        TimeoutFallbackMaybeObserver(t<? super T> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this, d2);
        }

        @Override
        public void onSuccess(T value) {
            this.downstream.onSuccess(value);
        }

        @Override
        public void onError(Throwable e2) {
            this.downstream.onError(e2);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }

    static final class TimeoutOtherMaybeObserver<T, U>
    extends AtomicReference<e>
    implements o<Object> {
        private static final long serialVersionUID = 8663801314800248617L;
        final TimeoutMainMaybeObserver<T, U> parent;

        TimeoutOtherMaybeObserver(TimeoutMainMaybeObserver<T, U> parent) {
            this.parent = parent;
        }

        @Override
        public void onSubscribe(e s2) {
            SubscriptionHelper.setOnce(this, s2, Long.MAX_VALUE);
        }

        @Override
        public void onNext(Object value) {
            ((e)this.get()).cancel();
            this.parent.otherComplete();
        }

        @Override
        public void onError(Throwable e2) {
            this.parent.otherError(e2);
        }

        @Override
        public void onComplete() {
            this.parent.otherComplete();
        }
    }

    static final class TimeoutMainMaybeObserver<T, U>
    extends AtomicReference<b>
    implements t<T>,
    b {
        private static final long serialVersionUID = -5955289211445418871L;
        final t<? super T> downstream;
        final TimeoutOtherMaybeObserver<T, U> other;
        final w<? extends T> fallback;
        final TimeoutFallbackMaybeObserver<T> otherObserver;

        TimeoutMainMaybeObserver(t<? super T> actual, w<? extends T> fallback) {
            this.downstream = actual;
            this.other = new TimeoutOtherMaybeObserver(this);
            this.fallback = fallback;
            this.otherObserver = fallback != null ? new TimeoutFallbackMaybeObserver<T>(actual) : null;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
            SubscriptionHelper.cancel(this.other);
            TimeoutFallbackMaybeObserver<T> oo = this.otherObserver;
            if (oo != null) {
                DisposableHelper.dispose(oo);
            }
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this, d2);
        }

        @Override
        public void onSuccess(T value) {
            SubscriptionHelper.cancel(this.other);
            if (this.getAndSet(DisposableHelper.DISPOSED) != DisposableHelper.DISPOSED) {
                this.downstream.onSuccess(value);
            }
        }

        @Override
        public void onError(Throwable e2) {
            SubscriptionHelper.cancel(this.other);
            if (this.getAndSet(DisposableHelper.DISPOSED) != DisposableHelper.DISPOSED) {
                this.downstream.onError(e2);
            } else {
                io.reactivex.rxjava3.d.a.onError(e2);
            }
        }

        @Override
        public void onComplete() {
            SubscriptionHelper.cancel(this.other);
            if (this.getAndSet(DisposableHelper.DISPOSED) != DisposableHelper.DISPOSED) {
                this.downstream.onComplete();
            }
        }

        public void otherError(Throwable e2) {
            if (DisposableHelper.dispose(this)) {
                this.downstream.onError(e2);
            } else {
                io.reactivex.rxjava3.d.a.onError(e2);
            }
        }

        public void otherComplete() {
            if (DisposableHelper.dispose(this)) {
                if (this.fallback == null) {
                    this.downstream.onError(new TimeoutException());
                } else {
                    this.fallback.c(this.otherObserver);
                }
            }
        }
    }
}

