/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.q;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeUsing<T, D>
extends q<T> {
    final s<? extends D> afm;
    final h<? super D, ? extends w<? extends T>> afn;
    final g<? super D> afo;
    final boolean afp;

    public MaybeUsing(s<? extends D> resourceSupplier, h<? super D, ? extends w<? extends T>> sourceSupplier, g<? super D> resourceDisposer, boolean eager) {
        this.afm = resourceSupplier;
        this.afn = sourceSupplier;
        this.afo = resourceDisposer;
        this.afp = eager;
    }

    @Override
    protected void d(t<? super T> observer) {
        w<T> source;
        D resource;
        try {
            resource = this.afm.get();
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        try {
            source = Objects.requireNonNull(this.afn.apply(resource), "The sourceSupplier returned a null MaybeSource");
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            if (this.afp) {
                try {
                    this.afo.accept(resource);
                }
                catch (Throwable exc) {
                    io.reactivex.rxjava3.exceptions.a.k(exc);
                    EmptyDisposable.error((Throwable)new CompositeException(ex, exc), observer);
                    return;
                }
            }
            EmptyDisposable.error(ex, observer);
            if (!this.afp) {
                try {
                    this.afo.accept(resource);
                }
                catch (Throwable exc) {
                    io.reactivex.rxjava3.exceptions.a.k(exc);
                    a.onError(exc);
                }
            }
            return;
        }
        source.c(new UsingObserver<T, D>(observer, resource, this.afo, this.afp));
    }

    static final class UsingObserver<T, D>
    extends AtomicReference<Object>
    implements t<T>,
    b {
        private static final long serialVersionUID = -674404550052917487L;
        final t<? super T> downstream;
        final g<? super D> disposer;
        final boolean eager;
        b upstream;

        UsingObserver(t<? super T> actual, D resource, g<? super D> disposer, boolean eager) {
            super(resource);
            this.downstream = actual;
            this.disposer = disposer;
            this.eager = eager;
        }

        @Override
        public void dispose() {
            if (this.eager) {
                this.disposeResource();
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
            } else {
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
                this.disposeResource();
            }
        }

        void disposeResource() {
            UsingObserver resource = this.getAndSet(this);
            if (resource != this) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    a.onError(ex);
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingObserver resource = this.getAndSet(this);
                if (resource != this) {
                    try {
                        this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        this.downstream.onError(ex);
                        return;
                    }
                } else {
                    return;
                }
            }
            this.downstream.onSuccess(value);
            if (!this.eager) {
                this.disposeResource();
            }
        }

        @Override
        public void onError(Throwable e2) {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingObserver resource = this.getAndSet(this);
                if (resource != this) {
                    try {
                        this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        e2 = new CompositeException(e2, ex);
                    }
                } else {
                    return;
                }
            }
            this.downstream.onError(e2);
            if (!this.eager) {
                this.disposeResource();
            }
        }

        @Override
        public void onComplete() {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingObserver resource = this.getAndSet(this);
                if (resource != this) {
                    try {
                        this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        this.downstream.onError(ex);
                        return;
                    }
                } else {
                    return;
                }
            }
            this.downstream.onComplete();
            if (!this.eager) {
                this.disposeResource();
            }
        }
    }
}

