/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.q;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.maybe.af;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeZipArray<T, R>
extends q<R> {
    final w<? extends T>[] afq;
    final h<? super Object[], ? extends R> afr;

    public MaybeZipArray(w<? extends T>[] sources, h<? super Object[], ? extends R> zipper) {
        this.afq = sources;
        this.afr = zipper;
    }

    @Override
    protected void d(t<? super R> observer) {
        w<? extends T>[] sources = this.afq;
        int n2 = sources.length;
        if (n2 == 1) {
            sources[0].c(new af.a(observer, new a()));
            return;
        }
        ZipCoordinator parent = new ZipCoordinator(observer, n2, this.afr);
        observer.onSubscribe(parent);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (parent.isDisposed()) {
                return;
            }
            w source = sources[i2];
            if (source == null) {
                parent.innerError(new NullPointerException("One of the sources is null"), i2);
                return;
            }
            source.c(parent.observers[i2]);
        }
    }

    final class a
    implements h<T, R> {
        a() {
        }

        @Override
        public R apply(T t2) throws Throwable {
            return Objects.requireNonNull(MaybeZipArray.this.afr.apply((Object[])new Object[]{t2}), "The zipper returned a null value");
        }
    }

    static final class ZipMaybeObserver<T>
    extends AtomicReference<b>
    implements t<T> {
        private static final long serialVersionUID = 3323743579927613702L;
        final ZipCoordinator<T, ?> parent;
        final int index;

        ZipMaybeObserver(ZipCoordinator<T, ?> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this, d2);
        }

        @Override
        public void onSuccess(T value) {
            this.parent.innerSuccess(value, this.index);
        }

        @Override
        public void onError(Throwable e2) {
            this.parent.innerError(e2, this.index);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this.index);
        }
    }

    static final class ZipCoordinator<T, R>
    extends AtomicInteger
    implements b {
        private static final long serialVersionUID = -5556924161382950569L;
        final t<? super R> downstream;
        final h<? super Object[], ? extends R> zipper;
        final ZipMaybeObserver<T>[] observers;
        Object[] values;

        ZipCoordinator(t<? super R> observer, int n2, h<? super Object[], ? extends R> zipper) {
            super(n2);
            this.downstream = observer;
            this.zipper = zipper;
            ZipMaybeObserver[] o2 = new ZipMaybeObserver[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                o2[i2] = new ZipMaybeObserver(this, i2);
            }
            this.observers = o2;
            this.values = new Object[n2];
        }

        @Override
        public boolean isDisposed() {
            return this.get() <= 0;
        }

        @Override
        public void dispose() {
            if (this.getAndSet(0) > 0) {
                for (ZipMaybeObserver<T> d2 : this.observers) {
                    d2.dispose();
                }
                this.values = null;
            }
        }

        void innerSuccess(T value, int index) {
            Object[] values = this.values;
            if (values != null) {
                values[index] = value;
            }
            if (this.decrementAndGet() == 0) {
                R v2;
                try {
                    v2 = Objects.requireNonNull(this.zipper.apply((Object[])values), "The zipper returned a null value");
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    this.values = null;
                    this.downstream.onError(ex);
                    return;
                }
                this.values = null;
                this.downstream.onSuccess(v2);
            }
        }

        void disposeExcept(int index) {
            int i2;
            ZipMaybeObserver<T>[] observers = this.observers;
            int n2 = observers.length;
            for (i2 = 0; i2 < index; ++i2) {
                observers[i2].dispose();
            }
            for (i2 = index + 1; i2 < n2; ++i2) {
                observers[i2].dispose();
            }
        }

        void innerError(Throwable ex, int index) {
            if (this.getAndSet(0) > 0) {
                this.disposeExcept(index);
                this.values = null;
                this.downstream.onError(ex);
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }

        void innerComplete(int index) {
            if (this.getAndSet(0) > 0) {
                this.disposeExcept(index);
                this.values = null;
                this.downstream.onComplete();
            }
        }
    }
}

