/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.operators.g;
import io.reactivex.rxjava3.operators.h;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ConcatMapXMainObserver<T>
extends AtomicInteger
implements ag<T>,
b {
    private static final long serialVersionUID = -3214213361171757852L;
    final AtomicThrowable errors;
    final int prefetch;
    final ErrorMode errorMode;
    g<T> queue;
    b upstream;
    volatile boolean done;
    volatile boolean disposed;

    public ConcatMapXMainObserver(int prefetch, ErrorMode errorMode) {
        this.errorMode = errorMode;
        this.errors = new AtomicThrowable();
        this.prefetch = prefetch;
    }

    @Override
    public final void onSubscribe(b d2) {
        if (DisposableHelper.validate(this.upstream, d2)) {
            this.upstream = d2;
            if (d2 instanceof io.reactivex.rxjava3.operators.b) {
                io.reactivex.rxjava3.operators.b qd = (io.reactivex.rxjava3.operators.b)d2;
                int mode = qd.requestFusion(7);
                if (mode == 1) {
                    this.queue = qd;
                    this.done = true;
                    this.onSubscribeDownstream();
                    this.drain();
                    return;
                }
                if (mode == 2) {
                    this.queue = qd;
                    this.onSubscribeDownstream();
                    return;
                }
            }
            this.queue = new h(this.prefetch);
            this.onSubscribeDownstream();
        }
    }

    @Override
    public final void onNext(T t2) {
        if (t2 != null) {
            this.queue.offer(t2);
        }
        this.drain();
    }

    @Override
    public final void onError(Throwable t2) {
        if (this.errors.tryAddThrowableOrReport(t2)) {
            if (this.errorMode == ErrorMode.IMMEDIATE) {
                this.disposeInner();
            }
            this.done = true;
            this.drain();
        }
    }

    @Override
    public final void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    public final void dispose() {
        this.disposed = true;
        this.upstream.dispose();
        this.disposeInner();
        this.errors.tryTerminateAndReport();
        if (this.getAndIncrement() == 0) {
            this.queue.clear();
            this.clearValue();
        }
    }

    @Override
    public final boolean isDisposed() {
        return this.disposed;
    }

    void clearValue() {
    }

    abstract void onSubscribeDownstream();

    abstract void disposeInner();

    abstract void drain();
}

