/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.d;
import io.reactivex.rxjava3.operators.g;
import java.util.concurrent.atomic.AtomicInteger;
import org.a.e;

public abstract class ConcatMapXMainSubscriber<T>
extends AtomicInteger
implements o<T> {
    private static final long serialVersionUID = -3214213361171757852L;
    final AtomicThrowable errors;
    final int prefetch;
    final ErrorMode errorMode;
    g<T> queue;
    e upstream;
    volatile boolean done;
    volatile boolean cancelled;
    boolean syncFused;

    public ConcatMapXMainSubscriber(int prefetch, ErrorMode errorMode) {
        this.errorMode = errorMode;
        this.errors = new AtomicThrowable();
        this.prefetch = prefetch;
    }

    @Override
    public final void onSubscribe(e s2) {
        if (SubscriptionHelper.validate(this.upstream, s2)) {
            this.upstream = s2;
            if (s2 instanceof d) {
                d qs = (d)s2;
                int mode = qs.requestFusion(7);
                if (mode == 1) {
                    this.queue = qs;
                    this.syncFused = true;
                    this.done = true;
                    this.onSubscribeDownstream();
                    this.drain();
                    return;
                }
                if (mode == 2) {
                    this.queue = qs;
                    this.onSubscribeDownstream();
                    this.upstream.request(this.prefetch);
                    return;
                }
            }
            this.queue = new SpscArrayQueue<T>(this.prefetch);
            this.onSubscribeDownstream();
            this.upstream.request(this.prefetch);
        }
    }

    @Override
    public final void onNext(T t2) {
        if (t2 != null && !this.queue.offer(t2)) {
            this.upstream.cancel();
            this.onError(new QueueOverflowException());
            return;
        }
        this.drain();
    }

    @Override
    public final void onError(Throwable t2) {
        if (this.errors.tryAddThrowableOrReport(t2)) {
            if (this.errorMode == ErrorMode.IMMEDIATE) {
                this.disposeInner();
            }
            this.done = true;
            this.drain();
        }
    }

    @Override
    public final void onComplete() {
        this.done = true;
        this.drain();
    }

    final void stop() {
        this.cancelled = true;
        this.upstream.cancel();
        this.disposeInner();
        this.errors.tryTerminateAndReport();
        if (this.getAndIncrement() == 0) {
            this.queue.clear();
            this.clearValue();
        }
    }

    void clearValue() {
    }

    abstract void onSubscribeDownstream();

    abstract void disposeInner();

    abstract void drain();
}

