/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.a;
import io.reactivex.rxjava3.core.d;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.mixed.ConcatMapXMainSubscriber;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.operators.g;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class FlowableConcatMapCompletable<T>
extends a {
    final j<T> afz;
    final h<? super T, ? extends io.reactivex.rxjava3.core.g> afA;
    final ErrorMode afB;
    final int afC;

    public FlowableConcatMapCompletable(j<T> source, h<? super T, ? extends io.reactivex.rxjava3.core.g> mapper, ErrorMode errorMode, int prefetch) {
        this.afz = source;
        this.afA = mapper;
        this.afB = errorMode;
        this.afC = prefetch;
    }

    @Override
    protected void d(d observer) {
        this.afz.a((o<? super T>)new ConcatMapCompletableObserver<T>(observer, this.afA, this.afB, this.afC));
    }

    static final class ConcatMapCompletableObserver<T>
    extends ConcatMapXMainSubscriber<T>
    implements b {
        private static final long serialVersionUID = 3610901111000061034L;
        final d downstream;
        final h<? super T, ? extends io.reactivex.rxjava3.core.g> mapper;
        final ConcatMapInnerObserver inner;
        volatile boolean active;
        int consumed;

        ConcatMapCompletableObserver(d downstream, h<? super T, ? extends io.reactivex.rxjava3.core.g> mapper, ErrorMode errorMode, int prefetch) {
            super(prefetch, errorMode);
            this.downstream = downstream;
            this.mapper = mapper;
            this.inner = new ConcatMapInnerObserver(this);
        }

        @Override
        void onSubscribeDownstream() {
            this.downstream.onSubscribe(this);
        }

        @Override
        void disposeInner() {
            this.inner.dispose();
        }

        @Override
        public void dispose() {
            this.stop();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void innerError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                if (this.errorMode == ErrorMode.IMMEDIATE) {
                    this.upstream.cancel();
                    this.errors.tryTerminateConsumer(this.downstream);
                    if (this.getAndIncrement() == 0) {
                        this.queue.clear();
                    }
                } else {
                    this.active = false;
                    this.drain();
                }
            }
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            ErrorMode errorMode = this.errorMode;
            g queue = this.queue;
            AtomicThrowable errors = this.errors;
            boolean syncFused = this.syncFused;
            do {
                io.reactivex.rxjava3.core.g cs;
                boolean empty;
                Object v2;
                if (this.cancelled) {
                    queue.clear();
                    return;
                }
                if (errors.get() != null && (errorMode == ErrorMode.IMMEDIATE || errorMode == ErrorMode.BOUNDARY && !this.active)) {
                    queue.clear();
                    errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (this.active) continue;
                boolean d2 = this.done;
                try {
                    v2 = queue.poll();
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    this.upstream.cancel();
                    errors.tryAddThrowableOrReport(ex);
                    errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                boolean bl2 = empty = v2 == null;
                if (d2 && empty) {
                    errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (empty) continue;
                int limit = this.prefetch - (this.prefetch >> 1);
                if (!syncFused) {
                    int c2 = this.consumed + 1;
                    if (c2 == limit) {
                        this.consumed = 0;
                        this.upstream.request(limit);
                    } else {
                        this.consumed = c2;
                    }
                }
                try {
                    cs = Objects.requireNonNull(this.mapper.apply(v2), "The mapper returned a null CompletableSource");
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    queue.clear();
                    this.upstream.cancel();
                    errors.tryAddThrowableOrReport(ex);
                    errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                this.active = true;
                cs.c(this.inner);
            } while (this.decrementAndGet() != 0);
        }

        static final class ConcatMapInnerObserver
        extends AtomicReference<b>
        implements d {
            private static final long serialVersionUID = 5638352172918776687L;
            final ConcatMapCompletableObserver<?> parent;

            ConcatMapInnerObserver(ConcatMapCompletableObserver<?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.replace(this, d2);
            }

            @Override
            public void onError(Throwable e2) {
                this.parent.innerError(e2);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

