/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.mixed.ConcatMapXMainSubscriber;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.operators.g;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableConcatMapMaybe<T, R>
extends j<R> {
    final j<T> afD;
    final h<? super T, ? extends w<? extends R>> afE;
    final ErrorMode afF;
    final int afG;

    public FlowableConcatMapMaybe(j<T> source, h<? super T, ? extends w<? extends R>> mapper, ErrorMode errorMode, int prefetch) {
        this.afD = source;
        this.afE = mapper;
        this.afF = errorMode;
        this.afG = prefetch;
    }

    @Override
    protected void d(d<? super R> s2) {
        this.afD.a(new ConcatMapMaybeSubscriber<T, R>(s2, this.afE, this.afG, this.afF));
    }

    static final class ConcatMapMaybeSubscriber<T, R>
    extends ConcatMapXMainSubscriber<T>
    implements e {
        private static final long serialVersionUID = -9140123220065488293L;
        final d<? super R> downstream;
        final h<? super T, ? extends w<? extends R>> mapper;
        final AtomicLong requested;
        final ConcatMapMaybeObserver<R> inner;
        long emitted;
        int consumed;
        R item;
        volatile int state;
        static final int STATE_INACTIVE = 0;
        static final int STATE_ACTIVE = 1;
        static final int STATE_RESULT_VALUE = 2;

        ConcatMapMaybeSubscriber(d<? super R> downstream, h<? super T, ? extends w<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
            super(prefetch, errorMode);
            this.downstream = downstream;
            this.mapper = mapper;
            this.requested = new AtomicLong();
            this.inner = new ConcatMapMaybeObserver(this);
        }

        @Override
        void onSubscribeDownstream() {
            this.downstream.onSubscribe(this);
        }

        @Override
        public void request(long n2) {
            io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
            this.drain();
        }

        @Override
        public void cancel() {
            this.stop();
        }

        void innerSuccess(R item) {
            this.item = item;
            this.state = 2;
            this.drain();
        }

        void innerComplete() {
            this.state = 0;
            this.drain();
        }

        void innerError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                if (this.errorMode != ErrorMode.END) {
                    this.upstream.cancel();
                }
                this.state = 0;
                this.drain();
            }
        }

        @Override
        void clearValue() {
            this.item = null;
        }

        @Override
        void disposeInner() {
            this.inner.dispose();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            d<R> downstream = this.downstream;
            ErrorMode errorMode = this.errorMode;
            g queue = this.queue;
            AtomicThrowable errors = this.errors;
            AtomicLong requested = this.requested;
            int limit = this.prefetch - (this.prefetch >> 1);
            boolean syncFused = this.syncFused;
            while (true) {
                if (this.cancelled) {
                    queue.clear();
                    this.item = null;
                } else {
                    long e2;
                    int s2 = this.state;
                    if (errors.get() != null && (errorMode == ErrorMode.IMMEDIATE || errorMode == ErrorMode.BOUNDARY && s2 == 0)) {
                        queue.clear();
                        this.item = null;
                        errors.tryTerminateConsumer(downstream);
                        return;
                    }
                    if (s2 == 0) {
                        boolean empty;
                        Object v2;
                        boolean d2 = this.done;
                        try {
                            v2 = queue.poll();
                        }
                        catch (Throwable ex) {
                            a.k(ex);
                            this.upstream.cancel();
                            errors.tryAddThrowableOrReport(ex);
                            errors.tryTerminateConsumer(downstream);
                            return;
                        }
                        boolean bl2 = empty = v2 == null;
                        if (d2 && empty) {
                            errors.tryTerminateConsumer(downstream);
                            return;
                        }
                        if (!empty) {
                            w<R> ms;
                            if (!syncFused) {
                                int c2 = this.consumed + 1;
                                if (c2 == limit) {
                                    this.consumed = 0;
                                    this.upstream.request(limit);
                                } else {
                                    this.consumed = c2;
                                }
                            }
                            try {
                                ms = Objects.requireNonNull(this.mapper.apply(v2), "The mapper returned a null MaybeSource");
                            }
                            catch (Throwable ex) {
                                a.k(ex);
                                this.upstream.cancel();
                                queue.clear();
                                errors.tryAddThrowableOrReport(ex);
                                errors.tryTerminateConsumer(downstream);
                                return;
                            }
                            this.state = 1;
                            ms.c(this.inner);
                        }
                    } else if (s2 == 2 && (e2 = this.emitted) != requested.get()) {
                        R w2 = this.item;
                        this.item = null;
                        downstream.onNext(w2);
                        this.emitted = e2 + 1L;
                        this.state = 0;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class ConcatMapMaybeObserver<R>
        extends AtomicReference<b>
        implements t<R> {
            private static final long serialVersionUID = -3051469169682093892L;
            final ConcatMapMaybeSubscriber<?, R> parent;

            ConcatMapMaybeObserver(ConcatMapMaybeSubscriber<?, R> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.replace(this, d2);
            }

            @Override
            public void onSuccess(R t2) {
                this.parent.innerSuccess(t2);
            }

            @Override
            public void onError(Throwable e2) {
                this.parent.innerError(e2);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

