/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.mixed.ConcatMapXMainSubscriber;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.operators.g;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableConcatMapSingle<T, R>
extends j<R> {
    final j<T> afL;
    final h<? super T, ? extends ao<? extends R>> afM;
    final ErrorMode afN;
    final int afO;

    public FlowableConcatMapSingle(j<T> source, h<? super T, ? extends ao<? extends R>> mapper, ErrorMode errorMode, int prefetch) {
        this.afL = source;
        this.afM = mapper;
        this.afN = errorMode;
        this.afO = prefetch;
    }

    @Override
    protected void d(d<? super R> s2) {
        this.afL.a(new ConcatMapSingleSubscriber<T, R>(s2, this.afM, this.afO, this.afN));
    }

    static final class ConcatMapSingleSubscriber<T, R>
    extends ConcatMapXMainSubscriber<T>
    implements e {
        private static final long serialVersionUID = -9140123220065488293L;
        final d<? super R> downstream;
        final h<? super T, ? extends ao<? extends R>> mapper;
        final AtomicLong requested;
        final ConcatMapSingleObserver<R> inner;
        long emitted;
        int consumed;
        R item;
        volatile int state;
        static final int STATE_INACTIVE = 0;
        static final int STATE_ACTIVE = 1;
        static final int STATE_RESULT_VALUE = 2;

        ConcatMapSingleSubscriber(d<? super R> downstream, h<? super T, ? extends ao<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
            super(prefetch, errorMode);
            this.downstream = downstream;
            this.mapper = mapper;
            this.requested = new AtomicLong();
            this.inner = new ConcatMapSingleObserver(this);
        }

        @Override
        void onSubscribeDownstream() {
            this.downstream.onSubscribe(this);
        }

        @Override
        public void request(long n2) {
            io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
            this.drain();
        }

        @Override
        public void cancel() {
            this.stop();
        }

        @Override
        void clearValue() {
            this.item = null;
        }

        @Override
        void disposeInner() {
            this.inner.dispose();
        }

        void innerSuccess(R item) {
            this.item = item;
            this.state = 2;
            this.drain();
        }

        void innerError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                if (this.errorMode != ErrorMode.END) {
                    this.upstream.cancel();
                }
                this.state = 0;
                this.drain();
            }
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            d<R> downstream = this.downstream;
            ErrorMode errorMode = this.errorMode;
            g queue = this.queue;
            AtomicThrowable errors = this.errors;
            AtomicLong requested = this.requested;
            int limit = this.prefetch - (this.prefetch >> 1);
            boolean syncFused = this.syncFused;
            while (true) {
                if (this.cancelled) {
                    queue.clear();
                    this.item = null;
                } else {
                    long e2;
                    int s2 = this.state;
                    if (errors.get() != null && (errorMode == ErrorMode.IMMEDIATE || errorMode == ErrorMode.BOUNDARY && s2 == 0)) {
                        queue.clear();
                        this.item = null;
                        errors.tryTerminateConsumer(downstream);
                        return;
                    }
                    if (s2 == 0) {
                        boolean empty;
                        Object v2;
                        boolean d2 = this.done;
                        try {
                            v2 = queue.poll();
                        }
                        catch (Throwable ex) {
                            a.k(ex);
                            this.upstream.cancel();
                            errors.tryAddThrowableOrReport(ex);
                            errors.tryTerminateConsumer(downstream);
                            return;
                        }
                        boolean bl2 = empty = v2 == null;
                        if (d2 && empty) {
                            errors.tryTerminateConsumer(downstream);
                            return;
                        }
                        if (!empty) {
                            ao<R> ss;
                            if (!syncFused) {
                                int c2 = this.consumed + 1;
                                if (c2 == limit) {
                                    this.consumed = 0;
                                    this.upstream.request(limit);
                                } else {
                                    this.consumed = c2;
                                }
                            }
                            try {
                                ss = Objects.requireNonNull(this.mapper.apply(v2), "The mapper returned a null SingleSource");
                            }
                            catch (Throwable ex) {
                                a.k(ex);
                                this.upstream.cancel();
                                queue.clear();
                                errors.tryAddThrowableOrReport(ex);
                                errors.tryTerminateConsumer(downstream);
                                return;
                            }
                            this.state = 1;
                            ss.c(this.inner);
                        }
                    } else if (s2 == 2 && (e2 = this.emitted) != requested.get()) {
                        R w2 = this.item;
                        this.item = null;
                        downstream.onNext(w2);
                        this.emitted = e2 + 1L;
                        this.state = 0;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class ConcatMapSingleObserver<R>
        extends AtomicReference<b>
        implements al<R> {
            private static final long serialVersionUID = -3051469169682093892L;
            final ConcatMapSingleSubscriber<?, R> parent;

            ConcatMapSingleObserver(ConcatMapSingleSubscriber<?, R> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.replace(this, d2);
            }

            @Override
            public void onSuccess(R t2) {
                this.parent.innerSuccess(t2);
            }

            @Override
            public void onError(Throwable e2) {
                this.parent.innerError(e2);
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

