/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class FlowableSwitchMapMaybe<T, R>
extends j<R> {
    final j<T> agg;
    final h<? super T, ? extends w<? extends R>> agh;
    final boolean agi;

    public FlowableSwitchMapMaybe(j<T> source, h<? super T, ? extends w<? extends R>> mapper, boolean delayErrors) {
        this.agg = source;
        this.agh = mapper;
        this.agi = delayErrors;
    }

    @Override
    protected void d(d<? super R> s2) {
        this.agg.a(new SwitchMapMaybeSubscriber<T, R>(s2, this.agh, this.agi));
    }

    static final class SwitchMapMaybeSubscriber<T, R>
    extends AtomicInteger
    implements o<T>,
    e {
        private static final long serialVersionUID = -5402190102429853762L;
        final d<? super R> downstream;
        final h<? super T, ? extends w<? extends R>> mapper;
        final boolean delayErrors;
        final AtomicThrowable errors;
        final AtomicLong requested;
        final AtomicReference<SwitchMapMaybeObserver<R>> inner;
        static final SwitchMapMaybeObserver<Object> INNER_DISPOSED = new SwitchMapMaybeObserver(null);
        e upstream;
        volatile boolean done;
        volatile boolean cancelled;
        long emitted;

        SwitchMapMaybeSubscriber(d<? super R> downstream, h<? super T, ? extends w<? extends R>> mapper, boolean delayErrors) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.requested = new AtomicLong();
            this.inner = new AtomicReference();
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            w<R> ms;
            SwitchMapMaybeObserver<R> current = this.inner.get();
            if (current != null) {
                current.dispose();
            }
            try {
                ms = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null MaybeSource");
            }
            catch (Throwable ex) {
                a.k(ex);
                this.upstream.cancel();
                this.inner.getAndSet(INNER_DISPOSED);
                this.onError(ex);
                return;
            }
            SwitchMapMaybeObserver observer = new SwitchMapMaybeObserver(this);
            while ((current = this.inner.get()) != INNER_DISPOSED) {
                if (!this.inner.compareAndSet(current, observer)) continue;
                ms.c(observer);
                break;
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.errors.tryAddThrowableOrReport(t2)) {
                if (!this.delayErrors) {
                    this.disposeInner();
                }
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void disposeInner() {
            SwitchMapMaybeObserver<Object> current = this.inner.getAndSet(INNER_DISPOSED);
            if (current != null && current != INNER_DISPOSED) {
                current.dispose();
            }
        }

        @Override
        public void request(long n2) {
            io.reactivex.rxjava3.internal.util.b.a(this.requested, n2);
            this.drain();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.disposeInner();
            this.errors.tryTerminateAndReport();
        }

        void innerError(SwitchMapMaybeObserver<R> sender, Throwable ex) {
            if (this.inner.compareAndSet(sender, null)) {
                if (this.errors.tryAddThrowableOrReport(ex)) {
                    if (!this.delayErrors) {
                        this.upstream.cancel();
                        this.disposeInner();
                    }
                    this.drain();
                }
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }

        void innerComplete(SwitchMapMaybeObserver<R> sender) {
            if (this.inner.compareAndSet(sender, null)) {
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            d<R> downstream = this.downstream;
            AtomicThrowable errors = this.errors;
            AtomicReference<SwitchMapMaybeObserver<R>> inner = this.inner;
            AtomicLong requested = this.requested;
            long emitted = this.emitted;
            while (true) {
                boolean empty;
                if (this.cancelled) {
                    return;
                }
                if (errors.get() != null && !this.delayErrors) {
                    errors.tryTerminateConsumer(downstream);
                    return;
                }
                boolean d2 = this.done;
                SwitchMapMaybeObserver<R> current = inner.get();
                boolean bl2 = empty = current == null;
                if (d2 && empty) {
                    errors.tryTerminateConsumer(downstream);
                    return;
                }
                if (!empty && current.item != null && emitted != requested.get()) {
                    inner.compareAndSet(current, null);
                    downstream.onNext(current.item);
                    ++emitted;
                    continue;
                }
                this.emitted = emitted;
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class SwitchMapMaybeObserver<R>
        extends AtomicReference<b>
        implements t<R> {
            private static final long serialVersionUID = 8042919737683345351L;
            final SwitchMapMaybeSubscriber<?, R> parent;
            volatile R item;

            SwitchMapMaybeObserver(SwitchMapMaybeSubscriber<?, R> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onSuccess(R t2) {
                this.item = t2;
                this.parent.drain();
            }

            @Override
            public void onError(Throwable e2) {
                this.parent.innerError(this, e2);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete(this);
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

