/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeFlatMapObservable<T, R>
extends z<R> {
    final w<T> agt;
    final h<? super T, ? extends ae<? extends R>> agu;

    public MaybeFlatMapObservable(w<T> source, h<? super T, ? extends ae<? extends R>> mapper) {
        this.agt = source;
        this.agu = mapper;
    }

    @Override
    protected void d(ag<? super R> observer) {
        FlatMapObserver<? super T, ? super R> parent = new FlatMapObserver<T, R>(observer, this.agu);
        observer.onSubscribe(parent);
        this.agt.c(parent);
    }

    static final class FlatMapObserver<T, R>
    extends AtomicReference<b>
    implements ag<R>,
    t<T>,
    b {
        private static final long serialVersionUID = -8948264376121066672L;
        final ag<? super R> downstream;
        final h<? super T, ? extends ae<? extends R>> mapper;

        FlatMapObserver(ag<? super R> downstream, h<? super T, ? extends ae<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
        }

        @Override
        public void onNext(R t2) {
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.replace(this, d2);
        }

        @Override
        public void onSuccess(T t2) {
            ae<R> o2;
            try {
                o2 = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null Publisher");
            }
            catch (Throwable ex) {
                a.k(ex);
                this.downstream.onError(ex);
                return;
            }
            if (!this.isDisposed()) {
                o2.subscribe(this);
            }
        }
    }
}

