/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.a;
import io.reactivex.rxjava3.core.d;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.mixed.ConcatMapXMainObserver;
import io.reactivex.rxjava3.internal.operators.mixed.g;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableConcatMapCompletable<T>
extends a {
    final z<T> agx;
    final h<? super T, ? extends io.reactivex.rxjava3.core.g> agy;
    final ErrorMode agz;
    final int agA;

    public ObservableConcatMapCompletable(z<T> source, h<? super T, ? extends io.reactivex.rxjava3.core.g> mapper, ErrorMode errorMode, int prefetch) {
        this.agx = source;
        this.agy = mapper;
        this.agz = errorMode;
        this.agA = prefetch;
    }

    @Override
    protected void d(d observer) {
        if (!g.a(this.agx, this.agy, observer)) {
            this.agx.subscribe(new ConcatMapCompletableObserver<T>(observer, this.agy, this.agz, this.agA));
        }
    }

    static final class ConcatMapCompletableObserver<T>
    extends ConcatMapXMainObserver<T> {
        private static final long serialVersionUID = 3610901111000061034L;
        final d downstream;
        final h<? super T, ? extends io.reactivex.rxjava3.core.g> mapper;
        final ConcatMapInnerObserver inner;
        volatile boolean active;

        ConcatMapCompletableObserver(d downstream, h<? super T, ? extends io.reactivex.rxjava3.core.g> mapper, ErrorMode errorMode, int prefetch) {
            super(prefetch, errorMode);
            this.downstream = downstream;
            this.mapper = mapper;
            this.inner = new ConcatMapInnerObserver(this);
        }

        @Override
        void onSubscribeDownstream() {
            this.downstream.onSubscribe(this);
        }

        @Override
        void disposeInner() {
            this.inner.dispose();
        }

        void innerError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                if (this.errorMode != ErrorMode.END) {
                    this.upstream.dispose();
                }
                this.active = false;
                this.drain();
            }
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            AtomicThrowable errors = this.errors;
            ErrorMode errorMode = this.errorMode;
            io.reactivex.rxjava3.operators.g queue = this.queue;
            do {
                if (this.disposed) {
                    queue.clear();
                    return;
                }
                if (errors.get() != null && (errorMode == ErrorMode.IMMEDIATE || errorMode == ErrorMode.BOUNDARY && !this.active)) {
                    this.disposed = true;
                    queue.clear();
                    errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (this.active) continue;
                boolean d2 = this.done;
                boolean empty = true;
                io.reactivex.rxjava3.core.g cs = null;
                try {
                    Object v2 = queue.poll();
                    if (v2 != null) {
                        cs = Objects.requireNonNull(this.mapper.apply(v2), "The mapper returned a null CompletableSource");
                        empty = false;
                    }
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    this.disposed = true;
                    queue.clear();
                    this.upstream.dispose();
                    errors.tryAddThrowableOrReport(ex);
                    errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (d2 && empty) {
                    this.disposed = true;
                    errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (empty) continue;
                this.active = true;
                cs.c(this.inner);
            } while (this.decrementAndGet() != 0);
        }

        static final class ConcatMapInnerObserver
        extends AtomicReference<b>
        implements d {
            private static final long serialVersionUID = 5638352172918776687L;
            final ConcatMapCompletableObserver<?> parent;

            ConcatMapInnerObserver(ConcatMapCompletableObserver<?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.replace(this, d2);
            }

            @Override
            public void onError(Throwable e2) {
                this.parent.innerError(e2);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

