/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.mixed.ConcatMapXMainObserver;
import io.reactivex.rxjava3.internal.operators.mixed.g;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableConcatMapSingle<T, R>
extends z<R> {
    final ae<T> agF;
    final h<? super T, ? extends ao<? extends R>> agG;
    final ErrorMode agH;
    final int agI;

    public ObservableConcatMapSingle(ae<T> source, h<? super T, ? extends ao<? extends R>> mapper, ErrorMode errorMode, int prefetch) {
        this.agF = source;
        this.agG = mapper;
        this.agH = errorMode;
        this.agI = prefetch;
    }

    @Override
    protected void d(ag<? super R> observer) {
        if (!g.b(this.agF, this.agG, observer)) {
            this.agF.subscribe(new ConcatMapSingleMainObserver<T, R>(observer, this.agG, this.agI, this.agH));
        }
    }

    static final class ConcatMapSingleMainObserver<T, R>
    extends ConcatMapXMainObserver<T> {
        private static final long serialVersionUID = -9140123220065488293L;
        final ag<? super R> downstream;
        final h<? super T, ? extends ao<? extends R>> mapper;
        final ConcatMapSingleObserver<R> inner;
        R item;
        volatile int state;
        static final int STATE_INACTIVE = 0;
        static final int STATE_ACTIVE = 1;
        static final int STATE_RESULT_VALUE = 2;

        ConcatMapSingleMainObserver(ag<? super R> downstream, h<? super T, ? extends ao<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
            super(prefetch, errorMode);
            this.downstream = downstream;
            this.mapper = mapper;
            this.inner = new ConcatMapSingleObserver(this);
        }

        void innerSuccess(R item) {
            this.item = item;
            this.state = 2;
            this.drain();
        }

        void innerError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                if (this.errorMode != ErrorMode.END) {
                    this.upstream.dispose();
                }
                this.state = 0;
                this.drain();
            }
        }

        @Override
        void disposeInner() {
            this.inner.dispose();
        }

        @Override
        void onSubscribeDownstream() {
            this.downstream.onSubscribe(this);
        }

        @Override
        void clearValue() {
            this.item = null;
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            ag<R> downstream = this.downstream;
            ErrorMode errorMode = this.errorMode;
            io.reactivex.rxjava3.operators.g queue = this.queue;
            AtomicThrowable errors = this.errors;
            while (true) {
                if (this.disposed) {
                    queue.clear();
                    this.item = null;
                } else {
                    int s2 = this.state;
                    if (errors.get() != null && (errorMode == ErrorMode.IMMEDIATE || errorMode == ErrorMode.BOUNDARY && s2 == 0)) {
                        queue.clear();
                        this.item = null;
                        errors.tryTerminateConsumer(downstream);
                        return;
                    }
                    if (s2 == 0) {
                        boolean empty;
                        Object v2;
                        boolean d2 = this.done;
                        try {
                            v2 = queue.poll();
                        }
                        catch (Throwable ex) {
                            a.k(ex);
                            this.disposed = true;
                            this.upstream.dispose();
                            errors.tryAddThrowableOrReport(ex);
                            errors.tryTerminateConsumer(downstream);
                            return;
                        }
                        boolean bl2 = empty = v2 == null;
                        if (d2 && empty) {
                            errors.tryTerminateConsumer(downstream);
                            return;
                        }
                        if (!empty) {
                            ao<R> ss;
                            try {
                                ss = Objects.requireNonNull(this.mapper.apply(v2), "The mapper returned a null SingleSource");
                            }
                            catch (Throwable ex) {
                                a.k(ex);
                                this.upstream.dispose();
                                queue.clear();
                                errors.tryAddThrowableOrReport(ex);
                                errors.tryTerminateConsumer(downstream);
                                return;
                            }
                            this.state = 1;
                            ss.c(this.inner);
                        }
                    } else if (s2 == 2) {
                        R w2 = this.item;
                        this.item = null;
                        downstream.onNext(w2);
                        this.state = 0;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class ConcatMapSingleObserver<R>
        extends AtomicReference<b>
        implements al<R> {
            private static final long serialVersionUID = -3051469169682093892L;
            final ConcatMapSingleMainObserver<?, R> parent;

            ConcatMapSingleObserver(ConcatMapSingleMainObserver<?, R> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.replace(this, d2);
            }

            @Override
            public void onSuccess(R t2) {
                this.parent.innerSuccess(t2);
            }

            @Override
            public void onError(Throwable e2) {
                this.parent.innerError(e2);
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

