/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.a;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.d;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.mixed.g;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableSwitchMapCompletable<T>
extends a {
    final z<T> agJ;
    final h<? super T, ? extends io.reactivex.rxjava3.core.g> agK;
    final boolean agL;

    public ObservableSwitchMapCompletable(z<T> source, h<? super T, ? extends io.reactivex.rxjava3.core.g> mapper, boolean delayErrors) {
        this.agJ = source;
        this.agK = mapper;
        this.agL = delayErrors;
    }

    @Override
    protected void d(d observer) {
        if (!g.a(this.agJ, this.agK, observer)) {
            this.agJ.subscribe(new SwitchMapCompletableObserver<T>(observer, this.agK, this.agL));
        }
    }

    static final class SwitchMapCompletableObserver<T>
    implements ag<T>,
    b {
        final d agM;
        final h<? super T, ? extends io.reactivex.rxjava3.core.g> agN;
        final boolean agO;
        final AtomicThrowable agP;
        final AtomicReference<SwitchMapInnerObserver> agQ;
        static final SwitchMapInnerObserver agR = new SwitchMapInnerObserver(null);
        volatile boolean done;
        b upstream;

        SwitchMapCompletableObserver(d downstream, h<? super T, ? extends io.reactivex.rxjava3.core.g> mapper, boolean delayErrors) {
            this.agM = downstream;
            this.agN = mapper;
            this.agO = delayErrors;
            this.agP = new AtomicThrowable();
            this.agQ = new AtomicReference();
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.agM.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            SwitchMapInnerObserver current;
            io.reactivex.rxjava3.core.g c2;
            try {
                c2 = Objects.requireNonNull(this.agN.apply(t2), "The mapper returned a null CompletableSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.dispose();
                this.onError(ex);
                return;
            }
            SwitchMapInnerObserver o2 = new SwitchMapInnerObserver(this);
            while ((current = this.agQ.get()) != agR) {
                if (!this.agQ.compareAndSet(current, o2)) continue;
                if (current != null) {
                    current.dispose();
                }
                c2.c(o2);
                break;
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.agP.tryAddThrowableOrReport(t2)) {
                if (this.agO) {
                    this.onComplete();
                } else {
                    this.disposeInner();
                    this.agP.tryTerminateConsumer(this.agM);
                }
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            if (this.agQ.get() == null) {
                this.agP.tryTerminateConsumer(this.agM);
            }
        }

        void disposeInner() {
            SwitchMapInnerObserver o2 = this.agQ.getAndSet(agR);
            if (o2 != null && o2 != agR) {
                o2.dispose();
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            this.disposeInner();
            this.agP.tryTerminateAndReport();
        }

        @Override
        public boolean isDisposed() {
            return this.agQ.get() == agR;
        }

        void a(SwitchMapInnerObserver sender, Throwable error) {
            if (this.agQ.compareAndSet(sender, null)) {
                if (this.agP.tryAddThrowableOrReport(error)) {
                    if (this.agO) {
                        if (this.done) {
                            this.agP.tryTerminateConsumer(this.agM);
                        }
                    } else {
                        this.upstream.dispose();
                        this.disposeInner();
                        this.agP.tryTerminateConsumer(this.agM);
                    }
                }
            } else {
                io.reactivex.rxjava3.d.a.onError(error);
            }
        }

        void a(SwitchMapInnerObserver sender) {
            if (this.agQ.compareAndSet(sender, null) && this.done) {
                this.agP.tryTerminateConsumer(this.agM);
            }
        }

        static final class SwitchMapInnerObserver
        extends AtomicReference<b>
        implements d {
            private static final long serialVersionUID = -8003404460084760287L;
            final SwitchMapCompletableObserver<?> parent;

            SwitchMapInnerObserver(SwitchMapCompletableObserver<?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onError(Throwable e2) {
                this.parent.a(this, e2);
            }

            @Override
            public void onComplete() {
                this.parent.a(this);
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

