/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.mixed.g;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableSwitchMapSingle<T, R>
extends z<R> {
    final z<T> agV;
    final h<? super T, ? extends ao<? extends R>> agW;
    final boolean agX;

    public ObservableSwitchMapSingle(z<T> source, h<? super T, ? extends ao<? extends R>> mapper, boolean delayErrors) {
        this.agV = source;
        this.agW = mapper;
        this.agX = delayErrors;
    }

    @Override
    protected void d(ag<? super R> observer) {
        if (!g.b(this.agV, this.agW, observer)) {
            this.agV.subscribe(new SwitchMapSingleMainObserver<T, R>(observer, this.agW, this.agX));
        }
    }

    static final class SwitchMapSingleMainObserver<T, R>
    extends AtomicInteger
    implements ag<T>,
    b {
        private static final long serialVersionUID = -5402190102429853762L;
        final ag<? super R> downstream;
        final h<? super T, ? extends ao<? extends R>> mapper;
        final boolean delayErrors;
        final AtomicThrowable errors;
        final AtomicReference<SwitchMapSingleObserver<R>> inner;
        static final SwitchMapSingleObserver<Object> INNER_DISPOSED = new SwitchMapSingleObserver(null);
        b upstream;
        volatile boolean done;
        volatile boolean cancelled;

        SwitchMapSingleMainObserver(ag<? super R> downstream, h<? super T, ? extends ao<? extends R>> mapper, boolean delayErrors) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.inner = new AtomicReference();
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            ao<R> ss;
            SwitchMapSingleObserver<R> current = this.inner.get();
            if (current != null) {
                current.dispose();
            }
            try {
                ss = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null SingleSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.dispose();
                this.inner.getAndSet(INNER_DISPOSED);
                this.onError(ex);
                return;
            }
            SwitchMapSingleObserver observer = new SwitchMapSingleObserver(this);
            while ((current = this.inner.get()) != INNER_DISPOSED) {
                if (!this.inner.compareAndSet(current, observer)) continue;
                ss.c(observer);
                break;
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.errors.tryAddThrowableOrReport(t2)) {
                if (!this.delayErrors) {
                    this.disposeInner();
                }
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void disposeInner() {
            SwitchMapSingleObserver<Object> current = this.inner.getAndSet(INNER_DISPOSED);
            if (current != null && current != INNER_DISPOSED) {
                current.dispose();
            }
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.disposeInner();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void innerError(SwitchMapSingleObserver<R> sender, Throwable ex) {
            if (this.inner.compareAndSet(sender, null)) {
                if (this.errors.tryAddThrowableOrReport(ex)) {
                    if (!this.delayErrors) {
                        this.upstream.dispose();
                        this.disposeInner();
                    }
                    this.drain();
                }
            } else {
                a.onError(ex);
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            ag<R> downstream = this.downstream;
            AtomicThrowable errors = this.errors;
            AtomicReference<SwitchMapSingleObserver<R>> inner = this.inner;
            while (true) {
                boolean empty;
                if (this.cancelled) {
                    return;
                }
                if (errors.get() != null && !this.delayErrors) {
                    errors.tryTerminateConsumer(downstream);
                    return;
                }
                boolean d2 = this.done;
                SwitchMapSingleObserver<R> current = inner.get();
                boolean bl2 = empty = current == null;
                if (d2 && empty) {
                    errors.tryTerminateConsumer(downstream);
                    return;
                }
                if (!empty && current.item != null) {
                    inner.compareAndSet(current, null);
                    downstream.onNext(current.item);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class SwitchMapSingleObserver<R>
        extends AtomicReference<b>
        implements al<R> {
            private static final long serialVersionUID = 8042919737683345351L;
            final SwitchMapSingleMainObserver<?, R> parent;
            volatile R item;

            SwitchMapSingleObserver(SwitchMapSingleMainObserver<?, R> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onSuccess(R t2) {
                this.item = t2;
                this.parent.drain();
            }

            @Override
            public void onError(Throwable e2) {
                this.parent.innerError(this, e2);
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

