/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleFlatMapObservable<T, R>
extends z<R> {
    final ao<T> agY;
    final h<? super T, ? extends ae<? extends R>> agZ;

    public SingleFlatMapObservable(ao<T> source, h<? super T, ? extends ae<? extends R>> mapper) {
        this.agY = source;
        this.agZ = mapper;
    }

    @Override
    protected void d(ag<? super R> observer) {
        FlatMapObserver<? super T, ? super R> parent = new FlatMapObserver<T, R>(observer, this.agZ);
        observer.onSubscribe(parent);
        this.agY.c(parent);
    }

    static final class FlatMapObserver<T, R>
    extends AtomicReference<b>
    implements ag<R>,
    al<T>,
    b {
        private static final long serialVersionUID = -8948264376121066672L;
        final ag<? super R> downstream;
        final h<? super T, ? extends ae<? extends R>> mapper;

        FlatMapObserver(ag<? super R> downstream, h<? super T, ? extends ae<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
        }

        @Override
        public void onNext(R t2) {
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.replace(this, d2);
        }

        @Override
        public void onSuccess(T t2) {
            ae<R> o2;
            try {
                o2 = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null Publisher");
            }
            catch (Throwable ex) {
                a.k(ex);
                this.downstream.onError(ex);
                return;
            }
            if (!this.isDisposed()) {
                o2.subscribe(this);
            }
        }
    }
}

