/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.c;
import io.reactivex.rxjava3.operators.h;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class BlockingObservableIterable<T>
implements Iterable<T> {
    final ae<? extends T> ahb;
    final int ahc;

    public BlockingObservableIterable(ae<? extends T> source, int bufferSize) {
        this.ahb = source;
        this.ahc = bufferSize;
    }

    @Override
    public Iterator<T> iterator() {
        BlockingObservableIterator it = new BlockingObservableIterator(this.ahc);
        this.ahb.subscribe(it);
        return it;
    }

    static final class BlockingObservableIterator<T>
    extends AtomicReference<b>
    implements ag<T>,
    b,
    Iterator<T> {
        private static final long serialVersionUID = 6695226475494099826L;
        final h<T> queue;
        final Lock lock;
        final Condition condition;
        volatile boolean done;
        volatile Throwable error;

        BlockingObservableIterator(int batchSize) {
            this.queue = new h(batchSize);
            this.lock = new ReentrantLock();
            this.condition = this.lock.newCondition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            block5: while (true) {
                if (this.isDisposed()) {
                    Throwable e2 = this.error;
                    if (e2 != null) {
                        throw ExceptionHelper.r(e2);
                    }
                    return false;
                }
                boolean d2 = this.done;
                boolean empty = this.queue.isEmpty();
                if (d2) {
                    Throwable e3 = this.error;
                    if (e3 != null) {
                        throw ExceptionHelper.r(e3);
                    }
                    if (empty) {
                        return false;
                    }
                }
                if (!empty) break;
                try {
                    c.qC();
                    this.lock.lock();
                    try {
                        while (true) {
                            if (this.done || !this.queue.isEmpty() || this.isDisposed()) continue block5;
                            this.condition.await();
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                catch (InterruptedException ex) {
                    DisposableHelper.dispose(this);
                    this.signalConsumer();
                    throw ExceptionHelper.r(ex);
                }
            }
            return true;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return this.queue.poll();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this, d2);
        }

        @Override
        public void onNext(T t2) {
            this.queue.offer(t2);
            this.signalConsumer();
        }

        @Override
        public void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            this.signalConsumer();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.signalConsumer();
        }

        void signalConsumer() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
            this.signalConsumer();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }
    }
}

