/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableBuffer<T, U extends Collection<? super T>>
extends io.reactivex.rxjava3.internal.operators.observable.a<T, U> {
    final int ahL;
    final int ahM;
    final s<U> ahN;

    public ObservableBuffer(ae<T> source, int count, int skip, s<U> bufferSupplier) {
        super(source);
        this.ahL = count;
        this.ahM = skip;
        this.ahN = bufferSupplier;
    }

    @Override
    protected void d(ag<? super U> t2) {
        if (this.ahM == this.ahL) {
            a bes = new a(t2, this.ahL, this.ahN);
            if (bes.qk()) {
                this.aha.subscribe(bes);
            }
        } else {
            this.aha.subscribe(new BufferSkipObserver(t2, this.ahL, this.ahM, this.ahN));
        }
    }

    static final class BufferSkipObserver<T, U extends Collection<? super T>>
    extends AtomicBoolean
    implements ag<T>,
    b {
        private static final long serialVersionUID = -8223395059921494546L;
        final ag<? super U> downstream;
        final int count;
        final int skip;
        final s<U> bufferSupplier;
        b upstream;
        final ArrayDeque<U> buffers;
        long index;

        BufferSkipObserver(ag<? super U> actual, int count, int skip, s<U> bufferSupplier) {
            this.downstream = actual;
            this.count = count;
            this.skip = skip;
            this.bufferSupplier = bufferSupplier;
            this.buffers = new ArrayDeque();
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t2) {
            if (this.index++ % (long)this.skip == 0L) {
                Collection b2;
                try {
                    b2 = (Collection)ExceptionHelper.e(this.bufferSupplier.get(), "The bufferSupplier returned a null Collection.");
                }
                catch (Throwable e2) {
                    io.reactivex.rxjava3.exceptions.a.k(e2);
                    this.buffers.clear();
                    this.upstream.dispose();
                    this.downstream.onError(e2);
                    return;
                }
                this.buffers.offer(b2);
            }
            Iterator<U> it = this.buffers.iterator();
            while (it.hasNext()) {
                Collection b3 = (Collection)it.next();
                b3.add(t2);
                if (this.count > b3.size()) continue;
                it.remove();
                this.downstream.onNext(b3);
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.buffers.clear();
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            while (!this.buffers.isEmpty()) {
                this.downstream.onNext(this.buffers.poll());
            }
            this.downstream.onComplete();
        }
    }

    static final class a<T, U extends Collection<? super T>>
    implements ag<T>,
    b {
        final ag<? super U> ahO;
        final int ahP;
        final s<U> ahQ;
        U buffer;
        int size;
        b upstream;

        a(ag<? super U> actual, int count, s<U> bufferSupplier) {
            this.ahO = actual;
            this.ahP = count;
            this.ahQ = bufferSupplier;
        }

        boolean qk() {
            Collection b2;
            try {
                b2 = (Collection)Objects.requireNonNull(this.ahQ.get(), "Empty buffer supplied");
            }
            catch (Throwable t2) {
                io.reactivex.rxjava3.exceptions.a.k(t2);
                this.buffer = null;
                if (this.upstream == null) {
                    EmptyDisposable.error(t2, this.ahO);
                } else {
                    this.upstream.dispose();
                    this.ahO.onError(t2);
                }
                return false;
            }
            this.buffer = b2;
            return true;
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.ahO.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t2) {
            U b2 = this.buffer;
            if (b2 != null) {
                b2.add(t2);
                if (++this.size >= this.ahP) {
                    this.ahO.onNext(b2);
                    this.size = 0;
                    this.qk();
                }
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.buffer = null;
            this.ahO.onError(t2);
        }

        @Override
        public void onComplete() {
            U b2 = this.buffer;
            if (b2 != null) {
                this.buffer = null;
                if (!b2.isEmpty()) {
                    this.ahO.onNext(b2);
                }
                this.ahO.onComplete();
            }
        }
    }
}

