/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.a;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableBufferBoundary<T, U extends Collection<? super T>, Open, Close>
extends a<T, U> {
    final s<U> ahR;
    final ae<? extends Open> ahS;
    final h<? super Open, ? extends ae<? extends Close>> ahT;

    public ObservableBufferBoundary(ae<T> source, ae<? extends Open> bufferOpen, h<? super Open, ? extends ae<? extends Close>> bufferClose, s<U> bufferSupplier) {
        super(source);
        this.ahS = bufferOpen;
        this.ahT = bufferClose;
        this.ahR = bufferSupplier;
    }

    @Override
    protected void d(ag<? super U> t2) {
        BufferBoundaryObserver parent = new BufferBoundaryObserver(t2, this.ahS, this.ahT, this.ahR);
        t2.onSubscribe(parent);
        this.aha.subscribe(parent);
    }

    static final class BufferCloseObserver<T, C extends Collection<? super T>>
    extends AtomicReference<b>
    implements ag<Object>,
    b {
        private static final long serialVersionUID = -8498650778633225126L;
        final BufferBoundaryObserver<T, C, ?, ?> parent;
        final long index;

        BufferCloseObserver(BufferBoundaryObserver<T, C, ?, ?> parent, long index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this, d2);
        }

        @Override
        public void onNext(Object t2) {
            b upstream = (b)this.get();
            if (upstream != DisposableHelper.DISPOSED) {
                this.lazySet(DisposableHelper.DISPOSED);
                upstream.dispose();
                this.parent.close(this, this.index);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.get() != DisposableHelper.DISPOSED) {
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.boundaryError(this, t2);
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.get() != DisposableHelper.DISPOSED) {
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.close(this, this.index);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == DisposableHelper.DISPOSED;
        }
    }

    static final class BufferBoundaryObserver<T, C extends Collection<? super T>, Open, Close>
    extends AtomicInteger
    implements ag<T>,
    b {
        private static final long serialVersionUID = -8466418554264089604L;
        final ag<? super C> downstream;
        final s<C> bufferSupplier;
        final ae<? extends Open> bufferOpen;
        final h<? super Open, ? extends ae<? extends Close>> bufferClose;
        final io.reactivex.rxjava3.disposables.a observers;
        final AtomicReference<b> upstream;
        final AtomicThrowable errors;
        volatile boolean done;
        final io.reactivex.rxjava3.operators.h<C> queue;
        volatile boolean cancelled;
        long index;
        Map<Long, C> buffers;

        BufferBoundaryObserver(ag<? super C> actual, ae<? extends Open> bufferOpen, h<? super Open, ? extends ae<? extends Close>> bufferClose, s<C> bufferSupplier) {
            this.downstream = actual;
            this.bufferSupplier = bufferSupplier;
            this.bufferOpen = bufferOpen;
            this.bufferClose = bufferClose;
            this.queue = new io.reactivex.rxjava3.operators.h(z.mB());
            this.observers = new io.reactivex.rxjava3.disposables.a();
            this.upstream = new AtomicReference();
            this.buffers = new LinkedHashMap<Long, C>();
            this.errors = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.setOnce(this.upstream, d2)) {
                BufferOpenObserver open = new BufferOpenObserver(this);
                this.observers.a((b)open);
                this.bufferOpen.subscribe(open);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t2) {
            BufferBoundaryObserver bufferBoundaryObserver = this;
            synchronized (bufferBoundaryObserver) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                for (Collection b2 : bufs.values()) {
                    b2.add(t2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t2) {
            if (this.errors.tryAddThrowableOrReport(t2)) {
                this.observers.dispose();
                BufferBoundaryObserver bufferBoundaryObserver = this;
                synchronized (bufferBoundaryObserver) {
                    this.buffers = null;
                }
                this.done = true;
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            this.observers.dispose();
            BufferBoundaryObserver bufferBoundaryObserver = this;
            synchronized (bufferBoundaryObserver) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                for (Collection b2 : bufs.values()) {
                    this.queue.offer(b2);
                }
                this.buffers = null;
            }
            this.done = true;
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            if (DisposableHelper.dispose(this.upstream)) {
                this.cancelled = true;
                this.observers.dispose();
                BufferBoundaryObserver bufferBoundaryObserver = this;
                synchronized (bufferBoundaryObserver) {
                    this.buffers = null;
                }
                if (this.getAndIncrement() != 0) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.upstream.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open(Open token) {
            ae<Close> p2;
            Collection buf;
            try {
                buf = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null Collection");
                p2 = Objects.requireNonNull(this.bufferClose.apply(token), "The bufferClose returned a null ObservableSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                DisposableHelper.dispose(this.upstream);
                this.onError(ex);
                return;
            }
            long idx = this.index;
            this.index = idx + 1L;
            BufferBoundaryObserver bufferBoundaryObserver = this;
            synchronized (bufferBoundaryObserver) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                bufs.put(idx, buf);
            }
            BufferCloseObserver bc2 = new BufferCloseObserver(this, idx);
            this.observers.a((b)bc2);
            p2.subscribe(bc2);
        }

        void openComplete(BufferOpenObserver<Open> os) {
            this.observers.c(os);
            if (this.observers.size() == 0) {
                DisposableHelper.dispose(this.upstream);
                this.done = true;
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(BufferCloseObserver<T, C> closer, long idx) {
            this.observers.c(closer);
            boolean makeDone = false;
            if (this.observers.size() == 0) {
                makeDone = true;
                DisposableHelper.dispose(this.upstream);
            }
            BufferBoundaryObserver bufferBoundaryObserver = this;
            synchronized (bufferBoundaryObserver) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                this.queue.offer(this.buffers.remove(idx));
            }
            if (makeDone) {
                this.done = true;
            }
            this.drain();
        }

        void boundaryError(b observer, Throwable ex) {
            DisposableHelper.dispose(this.upstream);
            this.observers.c(observer);
            this.onError(ex);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            ag<C> a2 = this.downstream;
            io.reactivex.rxjava3.operators.h<C> q2 = this.queue;
            while (true) {
                boolean empty;
                if (this.cancelled) {
                    q2.clear();
                    return;
                }
                boolean d2 = this.done;
                if (d2 && this.errors.get() != null) {
                    q2.clear();
                    this.errors.tryTerminateConsumer(a2);
                    return;
                }
                Collection v2 = (Collection)q2.poll();
                boolean bl2 = empty = v2 == null;
                if (d2 && empty) {
                    a2.onComplete();
                    return;
                }
                if (!empty) {
                    a2.onNext(v2);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class BufferOpenObserver<Open>
        extends AtomicReference<b>
        implements ag<Open>,
        b {
            private static final long serialVersionUID = -8498650778633225126L;
            final BufferBoundaryObserver<?, ?, Open, ?> parent;

            BufferOpenObserver(BufferBoundaryObserver<?, ?, Open, ?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onNext(Open t2) {
                this.parent.open(t2);
            }

            @Override
            public void onError(Throwable t2) {
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.boundaryError(this, t2);
            }

            @Override
            public void onComplete() {
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.openComplete(this);
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }

            @Override
            public boolean isDisposed() {
                return this.get() == DisposableHelper.DISPOSED;
            }
        }
    }
}

